package beamlinercp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.ui.part.ViewPart;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

import java.awt.Color;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JLabel;





public class BeamlineStatusView extends ViewPart 
{
	public static final String ID = "beamlinercp.BeamlineStatusView";
	private SashForm top = null;
	private DeviceProxy database;
	private DeviceProxy fe;
	private DeviceProxy beamshutter1;
	private DeviceProxy beamshutter2;
	private DeviceProxy beamshutter3;
	private DeviceProxy moco;
	private DeviceProxy valve1;
	private DeviceProxy valve2;
	private DeviceProxy valve3;
	private DeviceProxy valve4;
	private DeviceProxy valve5;
	private DeviceProxy valve6;
	private DeviceProxy front_end;
	private DeviceProxy beamline;
	private Runnable timer;
	private StyledText sText;
	private JFreeChart chartExternal;
	private JFreeChart chartInhouse;
	private Group gEx;
	private Group gIn;
	private JLabel lblChart1;
	private JLabel lblChart2;
	private Composite swtAwtComponent2;
	private Composite swtAwtComponent1;
	private Text textExperiment;
	private Text textSample;
	private Text textUser;
	private Label labelBS1;
	private Label labelBS2;
	private Label labelBS3;
	private Label labelV1;
	private Label labelV2;
	private Label labelV3;
	private Label labelV4;
	private Label labelV5;
	private Label labelV6;
	private Label labelM;
	private Group groupChart;
	private boolean stop = false;
	private boolean init = false;
	private Composite swtAwtComponent;
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) 
	{
        top = new SashForm(parent, SWT.NONE);
        GridLayout gL = new GridLayout();
        gL.numColumns = 2;
       	top.setLayout(gL);

 
        try
        {
        	database = new DeviceProxy("taco:id11/database/1");
        	// to avoid timeouts set the protocol to TCP
        	database.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        }
        catch (DevFailed e) 
        {
        	System.out.println("DATABASE:/ " + e);
        };

        try
        {
        	beamshutter1 = new DeviceProxy("taco:id11/beamshutter/1");
        	// to avoid timeouts set the protocol to TCP
        	beamshutter1.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	beamshutter2 = new DeviceProxy("taco:id11/beamshutter/2");
        	// to avoid timeouts set the protocol to TCP
        	beamshutter2.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	beamshutter3 = new DeviceProxy("taco:id11/beamshutter/3");
        	// to avoid timeouts set the protocol to TCP
        	beamshutter3.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        }
        catch (DevFailed e) 
        {
        	System.out.println("BEAM SHUTTER:/ " + e);
        };

        try
        {
        	moco = new DeviceProxy("taco:id11/isg-moco/1");
        	// to avoid timeouts set the protocol to TCP
        	moco.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        }
        catch (DevFailed e) 
        {
        	System.out.println("Device not defined in the database:/ " + e);
        };

        try
        {
        	valve1 = new DeviceProxy("taco:id11/rv/0");
        	// to avoid timeouts set the protocol to TCP
        	valve1.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	valve2 = new DeviceProxy("taco:id11/rv/2");
        	// to avoid timeouts set the protocol to TCP
        	valve2.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	valve3 = new DeviceProxy("taco:id11/rv/3");
        	// to avoid timeouts set the protocol to TCP
        	valve3.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	valve4 = new DeviceProxy("taco:id11/rv/4");
        	// to avoid timeouts set the protocol to TCP
        	valve4.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	valve5 = new DeviceProxy("taco:id11/rv/5");
        	// to avoid timeouts set the protocol to TCP
        	valve5.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	valve6 = new DeviceProxy("taco:id11/rv/6");
        	// to avoid timeouts set the protocol to TCP
        	valve6.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        }
        catch (DevFailed e) 
        {
        	System.out.println("VALVE:/ " + e);
        };

        try
        {
        	beamline = new DeviceProxy("taco:id11/beamline/1");
        	// to avoid timeouts set the protocol to TCP
        	beamline.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        }
        catch (DevFailed e) 
        {
        	System.out.println("BEAMLINE:/ " + e);
        };

        /*try
        {
        	front_end = new DeviceProxy("//aries/fe/id/11");
        	// to avoid timeouts set the protocol to TCP
        	front_end.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
        	
        }
        catch (DevFailed e) 
        {
        	System.out.println("Device not defined in the database:/ " + e);
        };*/

        
       	createOther();
       	createStorage();
             
        updateMethod();
        timer.run();
        
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() 
	{
	}

	private void createOther()
	{
		Composite composite = new Composite(top, SWT.NONE);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		composite.setLayout(new GridLayout());
		
		createModes(composite);
		createTexts(composite);
		createStatus(composite);
	}


	/**
	 * This method initializes composite	
	 *
	 */
	private void createModes(Composite composite) 
	{
		Composite compositeM = new Composite(composite, SWT.NONE);
		compositeM.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		compositeM.setLayout(gL);	
		
		createBeamlineMode(compositeM);
		createOpticMode(compositeM);
	}

	/**
	 * This method initializes composite1	
	 *
	 */
	private void createStatus(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		group.setText("STATUS");
		RowLayout rL = new RowLayout();
		rL.fill = true;
		group.setLayout(new FillLayout());	
		
		createStatusOther(group);
		createValves(group);
	}

	/**
	 * This method initializes composite2	
	 *
	 */
	private void createStorage() 
	{
		groupChart = new Group(top, SWT.NONE);
		groupChart.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout gL = new GridLayout();
		groupChart.setLayout(gL);
		groupChart.setText("DATA STORAGE");
	}

	/**
	 * This method initializes composite3	
	 *
	 */
	private void createOpticMode(Composite composite) {
		Composite compositeO = new Composite(composite, SWT.BORDER);
		compositeO.setLayoutData(new GridData(GridData.FILL_BOTH));
		compositeO.setLayout(new GridLayout());
		
		Composite tmp1 = new Composite(compositeO, SWT.NONE);
		tmp1.setLayoutData(new GridData(GridData.FILL_BOTH));
		tmp1.setLayout(new GridLayout());
		sText = new StyledText(tmp1, SWT.NONE);
		sText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		sText.setText("OPTIC MODE:");
		sText.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		
		Button b1 = new Button(tmp1, SWT.RADIO);
		Button b2 = new Button(tmp1, SWT.RADIO);
		b1.setText("white");
		b2.setText("monochromatic");
		
		
		//action
		b1.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				StyleRange styleRange = new StyleRange();
				styleRange.start = 0;
				styleRange.length = 11;
				styleRange.foreground = top.getDisplay().getSystemColor(SWT.COLOR_BLACK);
				sText.setStyleRange(styleRange);
				
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
//		action
		b2.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){
				styledTextF();
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action


	}

	/**
	 * This method initializes composite4	
	 *
	 */
	private void createBeamlineMode(Composite composite) {
		Composite compositeB = new Composite(composite, SWT.BORDER);
		compositeB.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		compositeB.setLayout(gL);
		
		Composite tmp2 = new Composite(compositeB, SWT.NONE);
		tmp2.setLayoutData(new GridData(GridData.FILL_BOTH));
		tmp2.setLayout(new GridLayout());
		
		Label label = new Label(tmp2, SWT.NONE);
		label.setText("BEAMLINE MODE:");
		label.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		final Label iconL = new Label(tmp2, SWT.CENTER);
		iconL.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/users.png"));
		
		Composite tmp1 = new Composite(compositeB, SWT.NONE);
		tmp1.setLayoutData(new GridData(GridData.FILL_BOTH));
		tmp1.setLayout(new GridLayout());
		final Button b1 = new Button(tmp1, SWT.RADIO);
		final Button b2 = new Button(tmp1, SWT.RADIO);
		final Button b3 = new Button(tmp1, SWT.RADIO);
		b1.setText("user");
		b2.setText("aligning");
		b3.setText("shutdown");
	
		
//		action
		b1.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				iconL.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/users.png"));
				
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
//		action
		b2.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				iconL.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/align2.gif"));
				
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
		
//		action
		b3.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				iconL.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/button-shutdown.png"));
				
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
	}
	
	/**
	 * This method initializes composite3	
	 *
	 */
	private void createTexts(Composite composite) 
	{
		Composite compositeT = new Composite(composite, SWT.NONE);
		compositeT.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compositeT.setLayout(new FillLayout());
		
		createUser(compositeT);
		createExperiment(compositeT);
		createSample(compositeT);
	}

	/**
	 * This method initializes composite4	
	 *
	 */
	private void createStatusOther(Group group) 
	{
		Composite composite = new Composite(group, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.VERTICAL));
		
		createShutters(composite);
		createMocoFE(composite);
	}
	
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createUser(Composite composite) 
	{
		Group group = new Group(composite, SWT.NULL);
		group.setLayout(new FillLayout());
		group.setText("user");
		
		textUser = new Text(group, SWT.BORDER|SWT.READ_ONLY);
	}
	
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createExperiment(Composite composite) 
	{
		Group group = new Group(composite, SWT.NULL);
		group.setLayout(new FillLayout());
		group.setText("experiment");
		
		textExperiment = new Text(group, SWT.BORDER|SWT.READ_ONLY);
	}
	
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createShutters(Composite composite)
	{
		Group group = new Group(composite, SWT.NULL);
		group.setText("shutters");
		
		group.setLayout(new FillLayout());
		
		Group g1 = new Group(group, SWT.NULL);
		g1.setText("1");
		g1.setLayout(new FillLayout());
		labelBS1 = new Label(g1, SWT.CENTER);
		Group g2 = new Group(group, SWT.NULL);
		g2.setText("2");
		g2.setLayout(new FillLayout());
		labelBS2 = new Label(g2, SWT.CENTER);
		Group g3 = new Group(group, SWT.NULL);
		g3.setText("3");
		g3.setLayout(new FillLayout());
		labelBS3 = new Label(g3, SWT.CENTER);
	}
		
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createMoco(Composite composite) 
	{
		Group group = new Group(composite, SWT.NULL);
		group.setText("moco");
		group.setLayout(new GridLayout());
		labelM = new Label(group, SWT.NONE);
		labelM.setText("DEVMOVING");
		labelM.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelM.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
	}
	
	private void createSample(Composite composite) 
	{
		Group group = new Group(composite, SWT.NULL);
		group.setLayout(new FillLayout());
		group.setText("sample");

		textSample = new Text(group, SWT.BORDER|SWT.READ_ONLY);
		textSample.setText("");
	}
	
	private void styledTextF(){
		
		StyleRange styleRange = new StyleRange();
		styleRange.start = 0;
		styleRange.length = 3;
		styleRange.foreground = top.getDisplay().getSystemColor(SWT.COLOR_BLUE);
		sText.setStyleRange(styleRange);
		
		styleRange = new StyleRange();
		styleRange.start = 3;
		styleRange.length = 3;
		styleRange.foreground = top.getDisplay().getSystemColor(SWT.COLOR_RED);
		sText.setStyleRange(styleRange);
		
		styleRange = new StyleRange();
		styleRange.start = 6;
		styleRange.length = 3;
		styleRange.foreground = top.getDisplay().getSystemColor(SWT.COLOR_GREEN);
		sText.setStyleRange(styleRange);

		styleRange = new StyleRange();
		styleRange.start = 9;
		styleRange.length = 2;
		styleRange.foreground = top.getDisplay().getSystemColor(SWT.COLOR_MAGENTA);
		sText.setStyleRange(styleRange);
	}
	
	private void createValves(Group group) 
	{
		Group groupV = new Group(group, SWT.NONE);
		groupV.setText("valves");
		GridLayout gL = new GridLayout();
		gL.numColumns = 3;
		groupV.setLayout(gL);
		
		Group g1 = new Group(groupV, SWT.NULL);
		g1.setText("1");
		g1.setLayout(new FillLayout());
		g1.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV1 = new Label(g1, SWT.CENTER);
		
		Group g2 = new Group(groupV, SWT.NULL);
		g2.setText("2");
		g2.setLayout(new FillLayout());
		g2.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV2 = new Label(g2, SWT.CENTER);
		
		Group g3 = new Group(groupV, SWT.NULL);
		g3.setText("3");
		g3.setLayout(new FillLayout());
		g3.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV3 = new Label(g3, SWT.CENTER);
			
		Group g4 = new Group(groupV, SWT.NULL);
		g4.setText("4");
		g4.setLayout(new FillLayout());
		g4.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV4 = new Label(g4, SWT.CENTER);
		
		Group g5 = new Group(groupV, SWT.NULL);
		g5.setText("5");
		g5.setLayout(new FillLayout());
		g5.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV5 = new Label(g5, SWT.CENTER);
		
		Group g6 = new Group(groupV, SWT.NULL);
		g6.setText("6");
		g6.setLayout(new FillLayout());
		g6.setLayoutData(new GridData(GridData.FILL_BOTH));
		labelV6 = new Label(g6, SWT.CENTER);
	}
	
	
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createMocoFE(Composite composite) {
		Composite compositeMFE = new Composite(composite, SWT.NONE);
		compositeMFE.setLayout(new FillLayout());
		
		createMoco(compositeMFE);
		createFrontEnd(compositeMFE);
	}
	
	
	/**
	 * This method initializes composite4	
	 *
	 */
	private void createFrontEnd(Composite composite) {
		Group group= new Group(composite, SWT.NONE);
		group.setText("front end");
		group.setLayout(new FillLayout());
		
		Label label = new Label(group, SWT.CENTER);
	}
	
	private void updateMethod() {
		final int time = 10000;
        timer = new Runnable () 
        {
        	public void run () {
        		updateState();
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	private void updateState() {
		

		
		//experiment
		try 
		{	
			DeviceData in = new DeviceData();
			String[] s_arr = {"experiment", "%"};
			in.insert(s_arr);
			DeviceData mydata = beamline.command_inout("BlDbQuerySettings",in);
			String[] out_arr = mydata.extractStringArray();
			
			textExperiment.setText(out_arr[0]);
			textExperiment.setToolTipText("Last time updated: " + out_arr[1]);
		}
		catch (DevFailed e) 
		{
			System.out.println(e.errors[0].desc);
			textExperiment.setText("err");
		};
 
		
		//sample
		try 
		{	
			DeviceData in = new DeviceData();
			String[] s_arr = {"sample", "%"};
			in.insert(s_arr);
			DeviceData mydata = beamline.command_inout("BlDbQuerySettings",in);
			String[] out_arr = mydata.extractStringArray();
			textSample.setText(out_arr[0]);
			textSample.setToolTipText("Last time updated: " + out_arr[1]);
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			textSample.setText("err");
		};

	
		//SHUTTERS
		try 
		{				
			DeviceData mydata = beamshutter1.command_inout("DevState");
			short mode = mydata.extractShort();
			
			if(mode == 4)
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
				labelBS1.setToolTipText("DEVOPEN");
			}
			else if(mode == 3)
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
				labelBS1.setToolTipText("DEVCLOSE");
			}
			else if(mode == 9)
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
				labelBS1.setToolTipText("DEVMOVING");
			}
			else if(mode == 46)
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/dis.gif"));
				labelBS1.setToolTipText("DEVDISABLED");
			}
			else if(mode == 23)
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));
				labelBS1.setToolTipText("DEVFAULT");
			}
			else
			{
				labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				labelBS1.setToolTipText("?UNKNOWN?");
			}
		}
			
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelBS1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
			labelBS1.setToolTipText("?UNKNOWN?");
		};
			

		try 
		{				
			DeviceData mydata = beamshutter2.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
				labelBS2.setToolTipText("DEVOPEN");
			}
			else if(mode == 3)
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
				labelBS2.setToolTipText("DEVCLOSE");
			}
			else if(mode == 9)
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
				labelBS2.setToolTipText("DEVMOVING");
			}
			else if(mode == 46)
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/dis.gif"));
				labelBS2.setToolTipText("DEVDISABLED");
			}
			else if(mode == 23)
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));
				labelBS2.setToolTipText("DEVFAULT");
			}
			else
			{
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				labelBS2.setToolTipText("?UNKNOWN?");
			}
		}
		catch (DevFailed e) 
		{
				System.out.println(e);
				labelBS2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				labelBS2.setToolTipText("?UNKNOWN?");
		};
		
			
		try 
		{				
			DeviceData mydata = beamshutter3.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
		    	labelBS3.setToolTipText("DEVOPEN");
			}
			else if(mode == 3)
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
				labelBS3.setToolTipText("DEVCLOSE");
			}
			else if(mode == 9)
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
				labelBS3.setToolTipText("DEVMOVING");
			}
			else if(mode == 46)
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/dis.gif"));
				labelBS3.setToolTipText("DEVDISABLED");
			}
			else if(mode == 23)
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));
				labelBS3.setToolTipText("DEVFAULT");
			}
			else
			{
				labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				labelBS3.setToolTipText("?UNKNOWN?");
			}
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelBS3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
			labelBS3.setToolTipText("?UNKNOWN?");
		};
		
		
		//VALVES
		try 
		{	
			DeviceData mydata = valve1.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 3)
				labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		}
		catch (DevFailed e) 
		{
			System.out.println("!!!!"+e);
			labelV1.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};
			

		try 
		{				
			DeviceData mydata = valve2.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 3)
				labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				
		}
		catch (DevFailed e) 
		{
			System.out.println("aaa"+e);
			labelV2.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};

		try 
		{				
			DeviceData mydata = valve3.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 0)
				labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelV3.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};

		try 
		{				
			DeviceData mydata = valve4.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 0)
				labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelV4.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};
		

		try 
		{				
			DeviceData mydata = valve5.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 0)
				labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
				
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelV5.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};


		try 
		{				
			DeviceData mydata = valve6.command_inout("DevState");
			short mode = mydata.extractShort();

			if(mode == 4)
				labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/upL.gif"));
			else if(mode == 0)
				labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/downL.gif"));
			else if(mode == 9)//moving
				labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/mov.jpg"));
			else if(mode == 23)//fault
				labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/faul.gif"));	
			else
				labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelV6.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/qm_small.gif"));
		};
		
		
		//MOCO
		try 
		{	
			DeviceData in = new DeviceData();
			in.insert("?STATE");
			DeviceData out = moco.command_inout("DevRequest",in);
			String mode;
			mode = out.extractString();
			
			labelM.setText(mode);
			labelM.setToolTipText(mode);
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
			labelM.setText("?UNKNOWN?");
			labelM.setToolTipText("?UNKNOWN?");
		};
		
		
		updateAllCharts();
	}
	
	private void updateAllCharts()
	{
		createCharts();
		drawCharts();
		init = true;
		stop = false;
	}
	
	
	private void createCharts()
	{
		String s = "", out = "", externalStr = "", inhouseStr = "";
		String ex[], in[];
		float exU = 0, exF = 0, inU = 0, inF = 0;
		
		 try 
		 {
			 Process p = Runtime.getRuntime().exec("rsh -l opid11 crunch cd /data/opid11/inhouse; rsh -l opid11 crunch cd /data/opid11/external; rsh -l opid11 crunch df -h");
			 BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));

			 while ((s = stdInput.readLine()) != null)
				 out += s;
		 }
		 catch (Exception e) 
		 {
			 System.out.println(e);
		 }

		externalStr = out.substring(out.indexOf("id11srv2ge1.esrf.fr:/qt_opid11ext/external") , out.indexOf("/mntdirect/_data_opid11_external"));
		inhouseStr = out.substring(out.indexOf("id11srvge1.esrf.fr:/qt_opid11inh/inhouse") , out.indexOf("/mntdirect/_data_opid11_inhouse"));

		ex = getValues(externalStr);
		in = getValues(inhouseStr);
 
		if(ex[3].endsWith("G"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1));
		else if(ex[3].endsWith("T"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) * 1000;
		else if(ex[3].endsWith("M"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) / 1000;
		else if(ex[3].endsWith("K"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) / 1000000;
		
		if(ex[2].endsWith("G"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1));
		else if(ex[2].endsWith("T"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) * 1000;
		else if(ex[2].endsWith("M"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) / 1000;
		else if(ex[2].endsWith("K"))
			exF = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) / 1000000;


		DefaultPieDataset pieDataset = new DefaultPieDataset();
		pieDataset.setValue("used [GB]", exU);
		pieDataset.setValue("free [GB]", exF);
		chartExternal = ChartFactory.createPieChart3D
			(null,   		  			  // Title
			pieDataset,                   // Dataset
			false,                        // Show legend
			true,                         // Use tooltips
			false);                       // Configure chart to generate URLs?
				
		PiePlot plot2 = (PiePlot) chartExternal.getPlot();
		plot2.setSectionPaint(0, Color.red);
		plot2.setSectionPaint(1, Color.green);

        	
		if(in[3].endsWith("G"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1));
		else if(in[3].endsWith("T"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) * 1000;
		else if(in[3].endsWith("M"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) / 1000;
		else if(in[3].endsWith("K"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) / 1000000;
    		
		if(in[2].endsWith("G"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1));
		else if(in[2].endsWith("T"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1)) * 1000;
		else if(in[2].endsWith("M"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1)) / 1000;
		else if(in[2].endsWith("K"))
			exF = Float.parseFloat(in[2].substring(0, in[2].length()-1)) / 1000000;

		DefaultPieDataset pieDataset2 = new DefaultPieDataset();
		pieDataset2.setValue("used [GB]", inU);
		pieDataset2.setValue("free [GB]", inF);
		chartInhouse = ChartFactory.createPieChart3D
			(null,      				   // Title
			pieDataset2,                   // Dataset
			false,                         // Show legend
			true,                          // Use tooltips
			false);                        // Configure chart to generate URLs?
        	     
		PiePlot plot3 = (PiePlot) chartInhouse.getPlot();
		plot3.setSectionPaint(0, Color.red);
		plot3.setSectionPaint(1, Color.green);
    	
    	Color background = new Color(234,233,231);
        plot3.setBackgroundPaint(background);
        plot2.setBackgroundPaint(background);
	}
	


	
	/**
	 * getValues
	 * @param str - string that is to be parsed
	 * @return - parsed string divided into shorter parts
	 */
	private String[] getValues(String str)
	{
		String valueArr[] = new String[5];
		int j = 0;
		String tmpArr[] = str.split(" ");
		for(int i = 0; i< tmpArr.length; i++)
			if(tmpArr[i].length() != 0 && tmpArr[i].length() != 1)
			{
				valueArr[j] = tmpArr[i];
				j++;
			}	
		return valueArr;
	}
	
	/**
	 * drawCharts
	 */
	private void drawCharts()
	{
		if(init == false)
		{
			gEx = new Group(groupChart, SWT.NONE);
			gEx.setLayoutData(new GridData(GridData.FILL_BOTH));
			gEx.setLayout(new FillLayout());
			gEx.setText("External usage");
			
			gIn = new Group(groupChart, SWT.NONE);
			gIn.setLayoutData(new GridData(GridData.FILL_BOTH));
			gIn.setText("Inhouse usage");
			gIn.setLayout(new FillLayout());
			
			swtAwtComponent1 = new Composite(gEx, SWT.EMBEDDED);
	    	java.awt.Frame frame1 = SWT_AWT.new_Frame(swtAwtComponent1);
			javax.swing.JPanel panel1 = new javax.swing.JPanel( );
			BufferedImage image1 = chartExternal.createBufferedImage(250,100);
			lblChart1 = new JLabel();
			lblChart1.setIcon(new ImageIcon(image1));
			panel1.add(lblChart1);
			frame1.add(panel1);

	    	swtAwtComponent2 = new Composite(gIn, SWT.EMBEDDED);
	    	java.awt.Frame frame2 = SWT_AWT.new_Frame(swtAwtComponent2);
			javax.swing.JPanel panel2 = new javax.swing.JPanel( );
			BufferedImage image2 = chartInhouse.createBufferedImage(250,100);
			lblChart2 = new JLabel();
			lblChart2.setIcon(new ImageIcon(image2));
			panel2.add(lblChart2);
			frame2.add(panel2);

			stabilizeCharts();
		}
		else
		{
			lblChart1.removeAll();
			lblChart2.removeAll();

			lblChart2.setIcon(new ImageIcon(chartExternal.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2))));
			lblChart1.setIcon(new ImageIcon(chartInhouse.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2))));
		}
		

		
	}
	
	
	private void stabilizeCharts()
	{
		groupChart.addControlListener(new ControlListener()
		{
			public void controlResized(ControlEvent event)
			{
				lblChart1.removeAll();
				BufferedImage image1;
				
				if(swtAwtComponent1.getSize().x == 0 || swtAwtComponent1.getSize().y == 0)
					image1 = chartExternal.createBufferedImage(100,100);
				else
					image1 = chartExternal.createBufferedImage(swtAwtComponent1.getSize().x,swtAwtComponent1.getSize().y);
				
				lblChart1.setIcon(new ImageIcon(image1));

				lblChart2.removeAll();
				BufferedImage image2;
				
				if(swtAwtComponent2.getSize().x == 0 || swtAwtComponent2.getSize().y == 0)
					image2 = chartInhouse.createBufferedImage(100,100);
				else
					image2 = chartInhouse.createBufferedImage(swtAwtComponent2.getSize().x,swtAwtComponent2.getSize().y);
				
				lblChart2.setIcon(new ImageIcon(image2));	
				
			}
			public void controlMoved(ControlEvent event)
			{
			}
		});

	}

	
	
}  