package beamlinercp;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor extends ActionBarAdvisor {
	
	
	private IWorkbenchAction helpAction;
	private IWorkbenchAction aboutAction;
	private IWorkbenchAction exitAction;
	private IWorkbenchAction preferencesAction;
	private NewSampleAction newSample;  
	private NewExperimentAction newExperimant;  
	private MakeMovieAction makeMovie; 
	private LinkamAction linkamAction;
	private EurothermAction eurothermAction;
	private ShutterAction shutterAction;
	private DiodemuxAction diodemuxAction;
	
    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
    	exitAction = ActionFactory.QUIT.create(window);
        register(exitAction);
        helpAction = ActionFactory.HELP_CONTENTS.create(window);
        register(helpAction);
        aboutAction = ActionFactory.ABOUT.create(window);
        register(aboutAction);
        preferencesAction = ActionFactory.PREFERENCES.create(window);
        register(preferencesAction);
        
        newSample = new NewSampleAction(window);
        register(newSample);
        newExperimant = new NewExperimentAction(window);
        register(newExperimant);
        makeMovie = new MakeMovieAction(window);
        register(makeMovie);
        linkamAction = new LinkamAction(window);
        register(linkamAction);
        eurothermAction = new EurothermAction(window);
        register(eurothermAction);
        shutterAction = new ShutterAction(window);
        register(shutterAction);
        diodemuxAction = new DiodemuxAction(window);
        register(diodemuxAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
    	
    	MenuManager fileMenu = new MenuManager("&File", IWorkbenchActionConstants.M_FILE);
    	MenuManager editMenu = new MenuManager("&Edit", IWorkbenchActionConstants.M_EDIT);
    	MenuManager windowMenu = new MenuManager("&Window", IWorkbenchActionConstants.M_WINDOW);
    	MenuManager helpMenu = new MenuManager("&Help", IWorkbenchActionConstants.M_HELP);
    	MenuManager newMenu = new MenuManager("&New", "new");
    	MenuManager viewMenu = new MenuManager("&Show view", "show view");
    	
    	menuBar.add(fileMenu);
    	menuBar.add(editMenu);
    	menuBar.add(windowMenu);
    	menuBar.add(helpMenu);
    	
    	newMenu.add(newSample);
    	newMenu.add(newExperimant);
    	newMenu.add(makeMovie);
    	fileMenu.add(newMenu);
    	fileMenu.add(exitAction);
    	
    	editMenu.add(preferencesAction);
    	
    	viewMenu.add(linkamAction);
    	viewMenu.add(shutterAction);
    	viewMenu.add(diodemuxAction);
    	viewMenu.add(eurothermAction);
    	windowMenu.add(viewMenu);
    	
    	helpMenu.add(helpAction);

    }
    
}
