package bqs_perspective;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.part.ViewPart;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;



public class Slave extends ViewPart implements IPropertyChangeListener 
{
	public static final String ID = "bqs_perspective.Slave";
	private Composite top = null;
	private Runnable timer;
	private Label slaveName;
	private List listSl;
	private Label labelStatus;
	ArrayList myListeners = new ArrayList();
	private String glob_name = "!@#$";
	private DeviceProxy slave;
	private Button buttonAbort;
	private Button buttonAbortAll;
	public static Slave thisView = null;
	private DebugConsole console = null;
	private Label labelNumberL;
	private Label labelNumberR;
	private Master masterView;
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		thisView = this;
		Master.thisView.addPropertyChangeListener(thisView);
		console = DebugConsole.thisConsole;
		masterView = Master.thisView;
	
	    parent.setLayout(new GridLayout());
	        
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout());
		top.setLayoutData(new GridData(GridData.FILL_BOTH));

		createCompositeName();
		createCompositeSl();
		
		updateMethod();
		timer.run();
	}

	
	private void createCompositeName()
	{
		Composite composite = new Composite(top, SWT.NULL);
		composite.setLayout(new FillLayout());
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
	    slaveName = new Label(composite, SWT.BORDER | SWT.CENTER);
	}


	private void createCompositeSl()
	{
		Composite composite = new Composite(top, SWT.NONE);
		GridLayout rL = new GridLayout();
		rL.numColumns = 2;
		composite.setLayout(rL);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createCompositeSlL(composite);
		createList(composite);
	}
	
	private void createCompositeSlL(Composite composite)
	{
		Composite compositeL = new Composite(composite, SWT.NONE);
		compositeL.setLayout(new GridLayout());
		compositeL.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		
		createCompositeStat(compositeL);
		createCompositeDB(compositeL);
		
	}
	
	private void createList(Composite composite)
	{
		Composite compositeR = new Composite(composite, SWT.BORDER);
		compositeR.setLayout(new GridLayout());
		compositeR.setLayoutData(new GridData(GridData.FILL_BOTH));
	
		listSl = new List(compositeR, SWT.V_SCROLL | SWT.BORDER);
		listSl.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
		listSl.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		buttonAbort = new Button(compositeR, SWT.PUSH);
		buttonAbort.setText("Abort");
		buttonAbort.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		buttonAbort.setEnabled(false);
		
		buttonAbortAll = new Button(compositeR, SWT.PUSH);
		buttonAbortAll.setText("AbortAll");
		buttonAbortAll.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		buttonAbortAll.setEnabled(false);
		
		//action
		buttonAbort.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{					
					DeviceData in = new DeviceData();
		        	in.insert(Long.parseLong(listSl.getItem(listSl.getSelectionIndex())));
		        	DeviceData mydata = masterView.getMaster().command_inout("DevAbortJob", in);
					String res = mydata.extractString();
					console.displayOk(masterView.getMasterName()+" -> \"DevAbortJob\"" + ":   EXECUTED");
				}
				catch (DevFailed e) 
				{
					console.displayErr(masterView.getMasterName()+" -> \"DevAbortJob\"" + ":  "+e);
				};
				
				buttonAbort.setEnabled(false);
				if(listSl.getItemCount() == 0)
					buttonAbortAll.setEnabled(false);
					
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
//		action
		buttonAbortAll.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{					
					DeviceData in = new DeviceData();
		        	in.insert(slaveName.getText());
		        	DeviceData mydata = masterView.getMaster().command_inout("DevAbortAllOn1", in);
					String res = mydata.extractString();
					console.displayOk(masterView.getMasterName()+" -> \"DevAbortAllOn1\"" + ":   EXECUTED");
				}
				catch (DevFailed e) 
				{
					console.displayErr(masterView.getMasterName()+" -> \"DevAbortAllOn1\"" + ":  "+e);
				};
				
				buttonAbort.setEnabled(false);
				if(listSl.getItemCount() == 0)
					buttonAbortAll.setEnabled(false);
					
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
		
		
		//list action
		listSl.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				
//				read data
				try 
				{				
					String dev_name = "taco:"+slaveName.getText();
					DeviceProxy slave = new DeviceProxy(dev_name);
					
					
					
					DeviceData in = new DeviceData();
					in.insert(listSl.getItem(listSl.getSelectionIndex()));
					DeviceData mydata = slave.command_inout("DevGetJob", in);
					String job = mydata.extractString();
					
					sendJob(myListeners, job);
					console.displayOk("\"Display job\"" + ":   EXECUTED");

				}
				catch (DevFailed e) 
				{
					System.out.println(e);
				};
				//
				
		       }

		       public void widgetDefaultSelected(SelectionEvent event) 
		       {
					buttonAbort.setEnabled(true);
					buttonAbortAll.setEnabled(true);
		       }
		     });
		//~list action

	
	}
	
	
	/**
	 * This method initializes composite	
	 *
	 */
	private void createCompositeStat(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("status");
		group.setLayout(new GridLayout());
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		labelStatus = new Label(group, SWT.CENTER);
		labelStatus.setImage(createIcon("qm_small.gif"));
		labelStatus.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createCompositeCounter(group);
	}

	
	/**
	 * This method initializes compositeDB	
	 *
	 */
	private void createCompositeDB(Composite composite) 
	{
		Composite compositeDB = new Composite(composite, SWT.BORDER);
		compositeDB.setLayout(new GridLayout());
		compositeDB.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Button button1 = new Button(compositeDB, SWT.NONE);
		button1.setText("On");
		button1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//action
		button1.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					if(!glob_name.equals(slaveName.getText()))
					{	
						String dev_name = "taco:"+slaveName.getText();
						slave = new DeviceProxy(dev_name);
						glob_name = dev_name;
					}
		        	// to avoid timeouts set the protocol to TCP
		        	slave.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
					slave.command_inout("DevOn");
					labelStatus.setImage(createIcon("upL.gif"));
					console.displayOk(glob_name+" -> \"DevOn\"" + ":   EXECUTED");	
				}
					catch (DevFailed e) 
					{
						console.displayErr(glob_name+" -> \"DevOn\"" + ":  "+e);	;
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
		Button button2 = new Button(compositeDB, SWT.NONE);
		button2.setText("Off");
		button2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
//		action
		button2.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					if(!glob_name.equals(slaveName.getText()))
					{	
						String dev_name = "taco:"+slaveName.getText();
						slave = new DeviceProxy(dev_name);
						glob_name = dev_name;
					}
		        	// to avoid timeouts set the protocol to TCP
		        	slave.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
					slave.command_inout("DevOff");
					labelStatus.setImage(createIcon("downL.gif"));
					console.displayOk(glob_name+" -> \"DevOff\"" + ":   EXECUTED");	
				}
					catch (DevFailed e) 
					{
						console.displayErr(glob_name+" -> \"DevOff\"" + ":  "+e);	
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
		Button button3 = new Button(compositeDB, SWT.NONE);
		button3.setText("Reset");	
		button3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
//		action
		button3.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					if(!glob_name.equals(slaveName.getText()))
					{	
						String dev_name = "taco:"+slaveName.getText();
						slave = new DeviceProxy(dev_name);
						glob_name = dev_name;
					}

		        	// to avoid timeouts set the protocol to TCP
		        	slave.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
					slave.command_inout("DevReset");
					console.displayOk(glob_name+" -> \"DevReset\"" + ":   EXECUTED");	
				}
					catch (DevFailed e) 
					{
						console.displayErr(glob_name+" -> \"DevReset\"" + ":  "+e);	
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
	}
	private void createCompositeCounter(Group group) 
	{
		Composite compositeC = new Composite(group, SWT.NONE);
		compositeC.setLayout(new FillLayout());
		compositeC.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		labelNumberL = new Label(compositeC, SWT.RIGHT);
		labelNumberL.setImage(createIcon("0.jpg"));
		labelNumberL.setToolTipText("number of jobs");
		labelNumberR = new Label(compositeC, SWT.LEFT);
		labelNumberR.setImage(createIcon("0.jpg"));
		labelNumberR.setToolTipText("number of jobs");
	}
	
	private Image createIcon(String icon)
	{
		return new Image(Display.getCurrent(), masterView.getImagePath() + icon);
	}
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
	}

	
	public void propertyChange(PropertyChangeEvent event) {
		if(event.getProperty().equals("slave_sent")) 
		{
			String val = (String)event.getNewValue();
			slaveName.setText(val);
			
//			read data
			try 
			{				
				
				DeviceData in = new DeviceData();
				in.insert("slave#"+val);
				DeviceData mydata = masterView.getMaster().command_inout("DevCheck", in);
				String slave = mydata.extractString();
				String arr[] = slave.split("#");
				
				listSl.removeAll();
				
				for(int i = 1; i< arr.length; i++)
					listSl.add(arr[i]);
			}
			catch (DevFailed e) 
			{
				System.out.println("DEVCHECK: " + e);
			};
			//
			
			
			
			
			try 
			{		
				if(!glob_name.equals(slaveName.getText()))
				{	
					String dev_name = "taco:"+slaveName.getText();
					slave = new DeviceProxy(dev_name);
					glob_name = dev_name;
				}
				
	        	// to avoid timeouts set the protocol to TCP
	        	slave.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
				
				
				DeviceData mydata = slave.command_inout("DevState");
				if(mydata.extractShort() == 2)
					labelStatus.setImage(createIcon("upL.gif"));
				else if(mydata.extractShort() == 1)
					labelStatus.setImage(createIcon("downL.gif"));
				else
					labelStatus.setImage(createIcon("qm_small.gif"));
			}
			catch (DevFailed e) 
			{
				System.out.println("DEVSTATE: " + e);
				labelStatus.setImage(createIcon("qm_small.gif"));
			};
			
		}
	}

	
	
	
	
	public void addPropertyChangeListener(IPropertyChangeListener listener) {

		if(!myListeners.contains(listener));
				myListeners.add(listener);
	}
	
	
	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		
		myListeners.remove(listener);
	}
	
	
	void sendJob(ArrayList listeners, String jobid) {
		
		for(Iterator it = listeners.iterator(); it.hasNext(); )
		{
			IPropertyChangeListener element = (IPropertyChangeListener)it.next();
			element.propertyChange(new PropertyChangeEvent(thisView, "job_sent_slave", null, jobid));
		}
			
	}
	
	

	private void updateMethod() 
	{
		final int time = 1000;
        timer = new Runnable () 
        {
        	public void run () 
        	{
        		updateState();
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	
	private void updateState() 
	{
		if(slaveName.getText().equals(""))
			return;
		
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("slave#"+slaveName.getText());
			DeviceData mydata = masterView.getMaster().command_inout("DevCheck", in);
			String slave = mydata.extractString();
			if(!slave.equals(""))
			{
				String arr[] = slave.split("#");
				String tmp = "";
					if(listSl.getSelectionIndex() != -1)
				tmp = listSl.getItem(listSl.getSelectionIndex());
				
				listSl.removeAll();
				
				for(int i = 0; i< arr.length; i++)
					listSl.add(arr[i]);
				
				
				for(int i = 0; i<listSl.getItemCount(); i++)
					if(listSl.getItem(i).equals(tmp))
						listSl.setSelection(i);
			}
			else
				listSl.removeAll();
		}
		catch (DevFailed e) 
		{
			System.out.println("DEVCHECK (FILL TABLE): " + e);
		};
		//
		
		
		
		
		try 
		{	
			if(!glob_name.equals(slaveName.getText()))
			{	
				String dev_name = "taco:"+slaveName.getText();
				slave = new DeviceProxy(dev_name);
				glob_name = dev_name;
			}
			
        	// to avoid timeouts set the protocol to TCP
        	slave.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
			
			
			DeviceData mydata = slave.command_inout("DevState");
			if(mydata.extractShort() == 2)
				labelStatus.setImage(createIcon("upL.gif"));
			else if(mydata.extractShort() == 1)
				labelStatus.setImage(createIcon("downL.gif"));
			else
			{
				labelStatus.setImage(createIcon("qm_small.gif"));
				listSl.removeAll();
			}
		}
		catch (DevFailed e) 
		{
			System.out.println("DEVSTATE: " + e);
			labelStatus.setImage(createIcon("qm_small.gif"));
			listSl.removeAll();
		};
		
		displayNumberOfJobs(listSl.getItemCount());
		
	}

	
	private void displayNumberOfJobs(int number)
	{
		int n10, n1;
		if(number > 9)
		{
			n10 = 1;
			n1 = number - 10;
		}
		else
		{
			n10 = 0;
			n1 = number;
		}
		
		labelNumberL.setImage(createIcon(n10 + ".jpg"));
		labelNumberR.setImage(createIcon(n1 + ".jpg"));
	}
	
	
}