package bqs_perspective;

import java.io.IOException;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;


public class PreferencePage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {
 
	public static final String MASTERS = "taco:id11/master/fable";
	public static final String IMAGE_PATH = "/home/lslezak/Desktop/img";
	private ScopedPreferenceStore preferences;
	private StringFieldEditor masterEditor;
	private StringFieldEditor imagePathEditor;
	
	/**
	 * Set preference page.
	 *
	 */
	public PreferencePage() {
		super(GRID);
		preferences = new ScopedPreferenceStore(new ConfigurationScope(), Application.ID);
		setPreferenceStore(preferences);
	}

	/**
	 * Generic init method.
	 */
	public void init(IWorkbench workbench) {
	}

	/**
	 * Set the field editor for storing default values for the peaksearching.py options.
	 */
	protected void createFieldEditors() {
		masterEditor = new StringFieldEditor(MASTERS, "list of masters:", getFieldEditorParent());
		addField(masterEditor);
		imagePathEditor = new StringFieldEditor(IMAGE_PATH, "path to images:", getFieldEditorParent());
		addField(imagePathEditor);
	}

	
	/**
	 * Public method invoked when OK button from preference page is pushed.
	 * Values inserted into the editor are saved in the store.
	 */
	public boolean performOk() {
		Master view = Master.thisView;
		DebugConsole console = DebugConsole.thisConsole;
	
		preferences.setValue(MASTERS, masterEditor.getStringValue());
		preferences.setValue(IMAGE_PATH, imagePathEditor.getStringValue());
		
		try
		{
			preferences.save();
			view.updateCombo(masterEditor.getStringValue(), false);
			view.updateImagePath(imagePathEditor.getStringValue());
			console.displayOk("Preferences saved");
		}
		catch(IOException e)
		{
			console.displayErr("Unable to save preferences:  " + e);
		}
		

		
		return true;
	}
	
	public void performDefaults() {
		masterEditor.setStringValue("taco:id11/master/fable");
		imagePathEditor.setStringValue("/home/lslezak/Desktop/img");
		
	}
	
	
}

