package bqs_perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

public class Perspective implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);
		layout.setFixed(false);
		
		layout.addStandaloneView(Master.ID,  true, IPageLayout.BOTTOM, 1.0f, editorArea);
		layout.addView(IConsoleConstants.ID_CONSOLE_VIEW, IPageLayout.BOTTOM, 0.79f, Master.ID);
		
		IFolderLayout slave_list = layout.createFolder("slave_list", IPageLayout.RIGHT, 0.55f, Master.ID);
		slave_list.addView(Slave.ID);
		slave_list.addView(OutputList.ID);
		
		layout.addStandaloneView(Job.ID, true, IPageLayout.TOP, 0.48f, Slave.ID);



		
		
	}
}