package bqs_perspective;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;


import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;

public class OutputList extends ViewPart  
{

	public static final String ID = "bqs_perspective.OutputList";
	public static OutputList thisView;
	private DebugConsole console;
	private Composite top;
	private Runnable timer;
	private ArrayList myListeners = new ArrayList();
	private Button buttonRemove;
	private List list;
	private Master masterView;
	private Label labelCounter;
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		thisView = this;
		console = DebugConsole.thisConsole;
		masterView = Master.thisView;
 
		masterView.outputListCreated = true;
		
		parent.setLayout(new GridLayout());
		
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout());
		top.setLayoutData(new GridData(GridData.FILL_BOTH));

		createLabel();
		createCompositeList();
		createRemove();

		
		updateMethod();
		timer.run();
	}

	private void createCompositeList()
	{
		Composite composite = new Composite(top, SWT.NONE);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		composite.setLayout(gL);
		
		Label label = new Label(composite, SWT.TOP);
		label.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		label.setText("list:");
		
		list = new List(composite, SWT.BORDER | SWT.SINGLE | SWT.V_SCROLL);
		list.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		//list action
		list.addSelectionListener(new SelectionListener() 
		{
			public void widgetSelected(SelectionEvent event) 
			{
				buttonRemove.setEnabled(true);
				sendOutput(myListeners, (list.getItem(list.getSelectionIndex())));
				
		    }

		 	public void widgetDefaultSelected(SelectionEvent event) 
			{
			}
		});
		//~list action
	}
	
	private void createLabel()
	{
		labelCounter = new Label(top, SWT.RIGHT);
		labelCounter.setText("items: ?");
		labelCounter.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}
	
	private void createRemove()
	{
		buttonRemove = new Button(top, SWT.PUSH);
		buttonRemove.setText("Remove");
		buttonRemove.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		buttonRemove.setEnabled(false);
		
//		list action
		buttonRemove.addSelectionListener(new SelectionListener() 
		{
			public void widgetSelected(SelectionEvent event) 
			{
				try 
				{				
					DeviceData in = new DeviceData();
					in.insert(Long.parseLong(list.getItem(list.getSelectionIndex())));
					masterView.getMaster().command_inout("DevRemoveOutput", in);
					console.displayOk(masterView.getMasterName()+" -> \"DevRemoveOutput\"" + ":   EXECUTED");
					
				}
				catch (DevFailed e) 
				{
					console.displayErr(masterView.getMasterName()+" -> \"DevRemoveOutput\"" + ":  " + e);
				};
				
				buttonRemove.setEnabled(false);
		    }

		 	public void widgetDefaultSelected(SelectionEvent event) 
			{
			}
		});
		//~list action
		

	}
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
	}
	


	
	
	
	
	public void addPropertyChangeListener(IPropertyChangeListener listener) {

		if(!myListeners.contains(listener));
				myListeners.add(listener);
	}
	
	
	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		
		myListeners.remove(listener);
	}
	
	
	void sendOutput(ArrayList listeners, String jobid) {
		
		for(Iterator it = listeners.iterator(); it.hasNext(); )
		{
			IPropertyChangeListener element = (IPropertyChangeListener)it.next();
			element.propertyChange(new PropertyChangeEvent(thisView, "output_sent", null, jobid));
			
		}
		
			
	}
	
	

	private void updateMethod() 
	{
		final int time = 1000;
        timer = new Runnable () 
        {
        	public void run () 
        	{
        		updateState();
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	
	private void updateState() 
	{
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("output");
			DeviceData mydata = masterView.getMaster().command_inout("DevCheck", in);
			String out = mydata.extractString();
			String arr[] = out.split(",");
			
			String tmp = "";
			if(list.getSelectionIndex() != -1)
				 tmp = list.getItem(list.getSelectionIndex());
			
			//sort
			for(int i = 0; i<arr.length; i++)
				for(int j = 1; j<arr.length; j++)
					if(Integer.parseInt(arr[j]) < Integer.parseInt(arr[j-1]))
					{
						String a1 = arr[j];
						String a2 = arr[j-1];
						arr[j] = a2;
						arr[j-1] = a1;
					}
			//~sort
			
			
		
			
			list.removeAll();
			if(!arr[0].equals(""))
				for(int i = 0; i < arr.length; i++)
					list.add(arr[i]);
			
			
			
			for(int i = 0; i<list.getItemCount(); i++)
				if(list.getItem(i).equals(tmp))
					list.setSelection(i);
			
			labelCounter.setText("items: "+list.getItemCount());
			
		}
		catch (DevFailed e) 
		{
		//	System.out.println("DEVCHECK: " + e);
		};
	}


	
	
}
