package bqs_perspective;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;


public class Master extends ViewPart {
	
	public static final String ID = "bqs_perspective.Master";
	private Composite top = null;

	private DeviceProxy master;
	ArrayList myListeners = new ArrayList();
	private int active;
	private Runnable timer;
	private List listJQ;
	private Button buttonJQ1;
	private Button buttonJQ2;
	private Button buttonJQ3;
	private Label labelSl1;
	private Label labelSl2;
	private List listSl;
	private Label labelJQ2;
	private Label labelJQ1;
	private Label labelStatus;
	private Label oL;
	private String masterName = "";
	public static Master thisView = null;
	private DebugConsole console = null;
	private Combo combo;
	private boolean first_time = true;
	private ScopedPreferenceStore preferences;
	private IStructuredSelection selection;
	public boolean outputListCreated = false;
	private String imagePath = null;
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		
		thisView = this;
		console = DebugConsole.thisConsole;
		
		preferences = new ScopedPreferenceStore(new ConfigurationScope(), Application.ID);
		masterName = updateCombo(preferences.getString(PreferencePage.MASTERS), first_time);
		imagePath = preferences.getString(PreferencePage.IMAGE_PATH);
		
		try 
	    {
			master = new DeviceProxy(masterName);
	      	master.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
	      	console.displayOk("\"Exporting Master\" " +  masterName + ":   EXECUTED");
	  	}
	 	catch (DevFailed e) 
	  	{
	 		console.displayErr("\"Exporting Master\" " + masterName + ":  "+e);
	  	};

	    active = 0;
	       
	    
	    parent.setLayout(new GridLayout());
	    
	    top = new Composite(parent, SWT.NONE);
	    top.setLayout(new GridLayout());
	    top.setLayoutData(new GridData(GridData.FILL_BOTH));
	    
	    createName();
	    createCompositeMaster();
	    createCompositeLists();
	    createCompositeListButt();
		
		updateMethod();
		timer.run();
	}

	
	private void createName() 
	{
	    combo = new Combo(top, SWT.CENTER);
	    

	    combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
	    combo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    combo.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
	    
	    
	    updateCombo(preferences.getString(PreferencePage.MASTERS), false);
	    
	    
	    combo.setText(masterName.toUpperCase());
	    
	    
	    
	    
	    combo.addSelectionListener(new SelectionListener()
	    {
	    	public void widgetSelected(SelectionEvent event)
	    	{
	    		masterName = combo.getItem(combo.getSelectionIndex()).toLowerCase();
	    		listJQ.removeAll();
	    		labelJQ2.setText("(?)");
	    		listSl.removeAll();
	    		labelSl2.setText("(?)");
	    		oL.setText("?");
	    		sendSlave(myListeners, "");
	    		combo.setText(combo.getItem(combo.getSelectionIndex()).toUpperCase());
	    		combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
	    		
	    		 try 
	 	        {
	 	        	master = new DeviceProxy(masterName);
	 	        	master.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
	 	        	console.displayOk("\"Exporting Master\"" + masterName + ":   EXECUTED");
	 	        }
	 	        catch (DevFailed e) 
	 	        {
	 	        	console.displayErr("\"Exporting Master\"" +  masterName + ":  "+e);
	 	        };
	    	}
	    	public void widgetDefaultSelected(SelectionEvent event)
	    	{
	    	}
	    });
	}
	
	/**
	 * This method initializes compositeJQ	
	 *
	 */
	private void createCompositeLists() 
	{
		Group group = new Group(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		group.setLayout(gL);
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		group.setText(".::LISTS::.");

	    createCompositeJQ(group);
	    createCompositeSl(group);
		
	}

	
	/**
	 * This method initializes compositeJQ	
	 *
	 */
	private void createCompositeJQ(Group group) 
	{
		Composite compositeJQ = new Composite(group, SWT.BORDER);
		compositeJQ.setLayout(new GridLayout());
		compositeJQ.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		labelJQ1 = new Label(compositeJQ, SWT.CENTER);
		labelJQ1.setText("JOB QUEUE");
		labelJQ1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		labelJQ2 = new Label(compositeJQ, SWT.CENTER);
		labelJQ2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		listJQ = new List(compositeJQ, SWT.V_SCROLL | SWT.BORDER);
		listJQ.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
		listJQ.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		//
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("queue");
			DeviceData mydata = master.command_inout("DevCheck", in);
			String queue = mydata.extractString();

			if(queue.length() != 0)
			{
				//parse queue = job1!job2!...
				String []arr = queue.split("!");

				for(int i = 0; i<arr.length; i++)
				{
					listJQ.add(arr[i]);
				}
			}
			
		}
		catch (DevFailed e) 
		{
			//System.out.println(e);
		};
		//

		labelJQ2.setText("(?)");
		
		//list action
		listJQ.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				listSl.deselectAll();
				buttonJQ1.setEnabled(true);
				buttonJQ2.setEnabled(true);
				buttonJQ3.setEnabled(true);
				active = 1;
				sendJob(myListeners, (listJQ.getSelectionIndex()+1)+"\n"+listJQ.getItem(listJQ.getSelectionIndex()));
				console.displayOk("\"Display job\"" + ":   EXECUTED");
		       }

		       public void widgetDefaultSelected(SelectionEvent event) {
		       }
		     });
		//~list action
		
//		list action
		listJQ.addFocusListener(new FocusListener() {

			public void focusLost(FocusEvent event) {
			
		       }

		       public void focusGained(FocusEvent event) {
		    		listSl.deselectAll();
					buttonJQ1.setEnabled(true);
					buttonJQ2.setEnabled(false);
					if(listJQ.getItemCount() == 0)
						buttonJQ3.setEnabled(false);
					else
						buttonJQ3.setEnabled(true);
					active = 1;
					labelJQ1.setText("> JOB QUEUE <");
					labelSl1.setText("SLAVES");
		       }
		     });
		//~list action

		
		
		
	}

	


	/**
	 * This method initializes composite17	
	 *
	 */
	private void createCompositeListButt() {
		Composite compositeB = new Composite(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 3;
		gL.makeColumnsEqualWidth = true;
		compositeB.setLayout(gL);
		compositeB.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		buttonJQ1 = new Button(compositeB, SWT.VERTICAL);
		buttonJQ1.setText("Add");
		buttonJQ1.setEnabled(false);
		buttonJQ1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//action
		buttonJQ1.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){


				
				//job queue active!!
				if(active == 1)
				{						
					AddBatchWizard wizard = new AddBatchWizard();
					wizard.init(PlatformUI.getWorkbench(), selection);
					WizardDialog dialog = new WizardDialog(top.getShell(), wizard);
					dialog.open();
				}//if
				
				//slaves list active
				if(active == 2)
				{

					final Shell dialog = new Shell(top.getShell(), SWT.APPLICATION_MODAL
						        | SWT.DIALOG_TRIM);	
					dialog.setLocation(90, 235);

					RowLayout rL = new RowLayout(SWT.VERTICAL);
					rL.spacing = 10;
					rL.pack = false;
					dialog.setLayout(rL);
					
					Label label = new Label(dialog, SWT.CENTER);
					label.setText("full device name:");

					final Text field = new Text(dialog, SWT.BORDER);

					Button buttonAdd= new Button(dialog, SWT.PUSH);
					buttonAdd.setText("Add");
					dialog.pack();
					dialog.open();

					//action
					buttonAdd.addSelectionListener(new SelectionListener(){

						public void widgetSelected(SelectionEvent event){

							
							try 
							{				
								DeviceData in = new DeviceData();
								in.insert(field.getText());
								master.command_inout("DevNewSlave", in);
								console.displayOk(masterName+" -> \"DevNewSlave\"" + ":   EXECUTED");	
								}
							catch (DevFailed e) 
							{
								console.displayErr(masterName+" -> \"DevNewSlave\"" + ":  "+e);
							};
							
							listSl.add(field.getText());
							dialog.close();
							labelSl2.setText("(" + listSl.getItemCount() + ")");
							}

						public void widgetDefaultSelected(SelectionEvent event){
						}
					});
					//~action
					
					
				}
			}
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action

		buttonJQ2 = new Button(compositeB, SWT.NONE);
		buttonJQ2.setText("Delete");
		buttonJQ2.setEnabled(false);
		buttonJQ2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		//action
		buttonJQ2.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				if(active == 1)
				{
				try 
				{				
					DeviceData in = new DeviceData();
					String tmp = listJQ.getItem(listJQ.getSelectionIndex());
					in.insert(Long.valueOf(tmp).longValue());
					master.command_inout("DevDeQueue", in);
					console.displayOk(masterName+" -> \"DevDeQueue\"" + ":   EXECUTED");
				}
				catch (DevFailed e) 
				{
					console.displayErr(masterName+" -> \"DevDeQueue\"" + ":  "+e);
				};
					
				listJQ.remove(listJQ.getSelectionIndex());
				buttonJQ2.setEnabled(false);
				labelJQ2.setText("(" + listJQ.getItemCount() + ")");
				}
				
				if(active == 2)
				{
					try 
					{				
						DeviceData in = new DeviceData();
						in.insert(listSl.getItem(listSl.getSelectionIndex()));
						master.command_inout("DevRemoveSlave", in);
						console.displayOk(masterName+" -> \"DevRemoveSlave\"" + ":   EXECUTED");
					}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevRemoveSlave\"" + ":  "+e);
					};
					
					listSl.remove(listSl.getSelectionIndex());
					buttonJQ2.setEnabled(false);
					labelSl2.setText("(" + listSl.getItemCount() + ")");
				}
		
				
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action

		buttonJQ3 = new Button(compositeB, SWT.NONE);
		buttonJQ3.setText("Clear");
		buttonJQ3.setEnabled(false);
		buttonJQ3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//action
		buttonJQ3.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event){

				if(active == 1)
				{
				try 
				{				
					master.command_inout("DevClearQueue");
					console.displayOk(masterName+" -> \"DevClearQueue\"" + ":   EXECUTED");
				}
				catch (DevFailed e) 
				{
					console.displayErr(masterName+" -> \"DevClearQueue\"" + ":  "+e);
				};
				
				listJQ.removeAll();
				buttonJQ3.setEnabled(false);
				labelJQ2.setText("(" + listJQ.getItemCount() + ")");
				}
				
				if(active == 2)
				{
					try 
					{				
						master.command_inout("DevAbortAll");
						console.displayOk(masterName+" -> \"DevAbortAll\"" + ":   EXECUTED");
					}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevAbortall\"" + ":  "+e);
					};
					
					listSl.removeAll();
					buttonJQ3.setEnabled(false);
					labelSl2.setText("(0)");
					
				}
			}

			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action

	}

	
	/**
	 * This method initializes compositeSl	
	 *
	 */
	private void createCompositeSl(Group group) 
	{
		Composite compositeSl = new Composite(group, SWT.BORDER);
		compositeSl.setLayout(new GridLayout());
		compositeSl.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		labelSl1 = new Label(compositeSl, SWT.CENTER);
		labelSl1.setText("SLAVES");
		labelSl1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		labelSl2 = new Label(compositeSl, SWT.CENTER);
		labelSl2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		labelSl2.setText("(?)");
		
		listSl = new List(compositeSl, SWT.V_SCROLL | SWT.BORDER);
		listSl.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
		listSl.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		
		
	/*	//		
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("slaves");
			DeviceData mydata = master.command_inout("DevCheck", in);
			String list = mydata.extractString();
			//parse queue = slave1!slave2!...
			String []arr = list.split("!!");
			if(list.length() != 0)
				for(int i = 0; i<arr.length; i++)
				{
					listSl.add(arr[i]);
				}
			
		}
		catch (DevFailed e) 
		{
			//System.out.println("DEVCHECK: " + e);
		};
		//
*/		

		
		//list action
		listSl.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				buttonJQ1.setEnabled(true);
				buttonJQ2.setEnabled(true);
				buttonJQ3.setEnabled(true);
				listJQ.deselectAll();
				active = 2;
				
				sendSlave(myListeners, (listSl.getItem(listSl.getSelectionIndex())));
				
		       }

		       public void widgetDefaultSelected(SelectionEvent event) {
		       }
		     });
		//~list action

		
//		list action
		listSl.addFocusListener(new FocusListener() {

			public void focusLost(FocusEvent event) {
			
		       }

		       public void focusGained(FocusEvent event) {
		    		listJQ.deselectAll();
					buttonJQ1.setEnabled(true);
					buttonJQ2.setEnabled(false);
					if(listSl.getItemCount() == 0)
						buttonJQ3.setEnabled(false);
					else
						buttonJQ3.setEnabled(true);
					active = 2;
					labelJQ1.setText("JOB QUEUE");
					labelSl1.setText("> SLAVES <");
		       }
		     });
		//~list action
		
		
		
	}
	

	/**
	 * This method initializes compositeSlR	
	 *
	 */
	private void createCompositeMaster() 
	{
		Composite composite = new Composite(top, SWT.BORDER);
		GridLayout gL = new GridLayout();
		gL.numColumns = 3;
		composite.setLayout(gL);
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		createCompositeDB(composite);
		createcompositeStatus(composite);
		createCompositeOutput(composite);

	}

	/**
	 * This method initializes composite13	
	 *
	 */
	private void createcompositeStatus(Composite composite) 
	{
		Composite tmpComp = new Composite(composite, SWT.NONE);
		tmpComp.setLayout(new GridLayout());
		tmpComp.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Group group = new Group(tmpComp, SWT.NULL);
		group.setLayout(new FillLayout());
		group.setText("status");
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		labelStatus = new Label(group, SWT.CENTER);
		

		
		//Read a status
		try 
		{				
			DeviceData mydata = master.command_inout("DevState");
			short tmp = mydata.extractShort();
			
			if(tmp == 2)
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "UpL.gif"));
			else if(tmp == 1)
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "DownL.gif"));
			else 
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "Qm_small.gif"));
		}
		catch (DevFailed e) 
		{
			//System.out.println("DEVSTATE: " + e);
			labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "Qm_small.gif"));
		};

	}
	
	//
	///Device buttons
	//
	/**
	 * This method initializes compositeDB	
	 *
	 */
	private void createCompositeDB(Composite composite) 
	{
		Composite compositeDB = new Composite(composite, SWT.NONE);;
		compositeDB.setLayout(new GridLayout());
		
		Button button1 = new Button(compositeDB, SWT.NONE);
		button1.setText("On");
		button1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Button button2 = new Button(compositeDB, SWT.NONE);
		button2.setText("Off");
		button2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Button button3 = new Button(compositeDB, SWT.NONE);
		button3.setText("Reset");	
		button3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		
		//action
		button1.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					master.command_inout("DevOn");
					labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "UpL.gif"));
					console.displayOk(masterName+" -> \"DevOn\"" + ":   EXECUTED");
				}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevOn\"" + ":  "+e);
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action

//		action
		button2.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					master.command_inout("DevOff");
					labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "DownL.gif"));
					console.displayOk(masterName+" -> \"DevOff\"" + ":   EXECUTED");
				}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevOff\"" + ":  "+e);
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		

		
//		action
		button3.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					master.command_inout("DevReset");
					console.displayOk(masterName+" -> \"DevReset\"" + ":   EXECUTED");
				}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevReset\"" + ":  "+e);
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
	}
	
	
	private void createCompositeOutput(Composite composite)
	{
		Composite compositeMain = new Composite(composite, SWT.NONE);
		compositeMain.setLayoutData(new GridData(GridData.FILL_BOTH));
		compositeMain.setLayout(new GridLayout());
		
		Group output = new Group(compositeMain, SWT.NONE);
		output.setText("outputs:");
		output.setLayoutData(new GridData(GridData.FILL_BOTH));
		output.setLayout(new GridLayout());
		
		oL = new Label(output, SWT.CENTER);
		oL.setText("?");
		oL.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Button clear = new Button(output, SWT.NONE);
		clear.setText("Clear");
		clear.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//action
		clear.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{	
				try 
				{
					master.command_inout("DevFlushBuffer");
					console.displayOk(masterName+" -> \"DevFlushBuffer\"" + ":   EXECUTED");
				}
					catch (DevFailed e) 
					{
						console.displayErr(masterName+" -> \"DevFlushBuffer\"" + ":  "+e);
					};
					
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});
		//~action
	}

	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
	}

	
	public void addPropertyChangeListener(IPropertyChangeListener listener) {

		if(!myListeners.contains(listener));
				myListeners.add(listener);
	}
	
	
	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		
		myListeners.remove(listener);
	}

	
	void sendJob(ArrayList listeners, String jobid) {
		
		for(Iterator it = listeners.iterator(); it.hasNext(); )
		{
			IPropertyChangeListener element = (IPropertyChangeListener)it.next();
			element.propertyChange(new PropertyChangeEvent(thisView, "job_sent", null, jobid));
		}
			
	}

	void sendSlave(ArrayList listeners, String slave) {
		
		for(Iterator it = listeners.iterator(); it.hasNext(); )
		{
			IPropertyChangeListener element = (IPropertyChangeListener)it.next();
			element.propertyChange(new PropertyChangeEvent(thisView, "slave_sent", null, slave));
		}
			
	}

	
	
	private void updateMethod() {
		final int time = 1000;
        timer = new Runnable () 
        {
        	public void run () {
        		updateState();
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	private void updateState() 
	{

		//
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("queue");
			DeviceData mydata = master.command_inout("DevCheck", in);
			String queue = mydata.extractString();
			String tmp = "";
			if(listJQ.getSelectionIndex() != -1)
				 tmp = listJQ.getItem(listJQ.getSelectionIndex());
			
			listJQ.removeAll();
			
			if(queue.length() != 0)
			{
				//parse queue = job1!job2!...
				String []arr = queue.split("!");
				
				
				//sort
				for(int i = 0; i<arr.length; i++)
					for(int j = 1; j<arr.length; j++)
						if(Integer.parseInt(arr[j]) < Integer.parseInt(arr[j-1]))
						{
							String a1 = arr[j];
							String a2 = arr[j-1];
							arr[j] = a2;
							arr[j-1] = a1;
						}
				//~sort
				
				
				for(int i = 0; i<arr.length; i++)
				{
					listJQ.add(arr[i]);
				}
			}
			
		for(int i = 0; i<listJQ.getItemCount(); i++)
			if(listJQ.getItem(i).equals(tmp))
				listJQ.setSelection(i);
		
		labelJQ2.setText("("+listJQ.getItemCount()+")");
		
		}
		catch (DevFailed e) 
		{
		//	System.out.println(e);
		};
		//
	
		//Read a status
		try 
		{				
			DeviceData mydata = master.command_inout("DevState");
			short tmp = mydata.extractShort();
			
			if(tmp == 2)
			{
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "UpL.gif"));
				combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN));
			}
			else if(tmp == 1)
			{
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "DownL.gif"));
				combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
			}
			else 
			{
				labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "Qm_small.gif"));
				combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
			}
		}
		catch (DevFailed e) 
		{
		//	System.out.println("DEVSTATE: " + e);
			labelStatus.setImage(new Image(Display.getCurrent(), getImagePath() + "Qm_small.gif"));
			combo.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
		};
		
		
//		
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("slaves");
			DeviceData mydata = master.command_inout("DevCheck", in);
			String list = mydata.extractString();
			
			String tmp = "";
			if(listSl.getSelectionIndex() != -1)
				 tmp = listSl.getItem(listSl.getSelectionIndex());
			
			listSl.removeAll();
			//parse queue = slave1!slave2!...
			String []arr = list.split("!!");
			if(list.length() != 0)
				for(int i = 0; i<arr.length; i++)
				{
					listSl.add(arr[i]);
				}
			
			for(int i = 0; i<listSl.getItemCount(); i++)
				if(listSl.getItem(i).equals(tmp))
					listSl.setSelection(i);
			
			labelSl2.setText("("+listSl.getItemCount()+")");
			
		}
		catch (DevFailed e) 
		{
		//	System.out.println("DEVCHECK: " + e);
		};
		//
		
		
		try 
		{				
			DeviceData in = new DeviceData();
			in.insert("output");
			DeviceData mydata = master.command_inout("DevCheck", in);
			String out = mydata.extractString();
			String arr[] = out.split(",");
			if(arr[0].equals(""))
				oL.setText("0");
			else
				oL.setText((arr.length)+"");

			
		}
		catch (DevFailed e) 
		{
		//	System.out.println("DEVCHECK: " + e);
		};
		//
	
		
	}
	
	public String updateCombo(String str, boolean time)
	{
		String [] masters;
		if(str.contains(", "))
			masters = str.split(", ");
		else if(str.contains(" "))
			masters = str.split(" ");
		else
			masters = str.split(",");
		
		if(time)
			return masters[0];
			
		combo.removeAll();
		for(int i = 0; i < masters.length; i++)
			combo.add(masters[i]);
		
		masterName = combo.getItem(0).toLowerCase();
		combo.setText(masterName.toUpperCase());
		
		return masters[0];
	}
	
	public DeviceProxy getMaster()
	{
		return master;
	}
	
	public String getMasterName()
	{
		return masterName;
	}
	
	public void updateImagePath(String str)
	{
		imagePath = str;
	}
	
	public String getImagePath()
	{
		return imagePath + "/";
	}
}