package bqs_perspective;


import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;


public class Job extends ViewPart implements IPropertyChangeListener 
{
	public static final String ID = "bqs_perspective.Job";
	private Composite top;
	String res = "";
	private Text text1;
	private Text text2;
	private Text text3;
	private Text text4;
	private Button buttonContents;
	public static Job thisView = null;
	private Master masterView;
	private boolean block = false;
	private Runnable timer;
	private DebugConsole console;
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		thisView = this;
		
		Master.thisView.addPropertyChangeListener(thisView);
		Slave.thisView.addPropertyChangeListener(thisView);
		masterView = Master.thisView;
		console = DebugConsole.thisConsole;
		
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout());
		top.setLayoutData(new GridData(GridData.FILL_BOTH));
	
		createCompositeJob();
		createCompositeFind();
		
		updateMethod();
		timer.run();
	}

	
	
	
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
	}

	
	private void createCompositeJob()
	{
		Composite composite = new Composite(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		composite.setLayout(gL);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createCompositeOther(composite);
		createCompositeContents(composite);
	}
	
	
	private void createCompositeOther(Composite compositeM)
	{
		Composite composite = new Composite(compositeM, SWT.BORDER);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		composite.setLayout(gL);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
			
		Label label1 = new Label(composite, SWT.LEFT);
		label1.setText("id:");
		text1 = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		text1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Label label2 = new Label(composite, SWT.LEFT);
		label2.setText("type:");
		text2 = new Text(composite, SWT.BORDER | SWT.READ_ONLY);	
		text2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Label label3 = new Label(composite, SWT.LEFT);
		label3.setText("index:");
		text3 = new Text(composite, SWT.BORDER | SWT.READ_ONLY);	
		text3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Label label4 = new Label(composite, SWT.LEFT);
		label4.setText("status:");
		text4 = new Text(composite, SWT.BORDER | SWT.READ_ONLY);	
		text4.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
	}
	
	private void createCompositeContents(Composite compositeM)
	{
		Composite composite = new Composite(compositeM, SWT.NULL);
		composite.setLayout(new FillLayout());
		composite.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		
		buttonContents = new Button(composite, SWT.NONE);
		buttonContents.setText("Contents");

		//action
		buttonContents.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent event)
			{

				Shell dialog = new Shell(top.getShell(), SWT.APPLICATION_MODAL
					        | SWT.DIALOG_TRIM);	
				

				dialog.setLayout(new FillLayout());
				dialog.setText("Contents:");

				Text field = new Text(dialog, SWT.BORDER | SWT.READ_ONLY | SWT.HORIZONTAL|SWT.VERTICAL);

				field.setText(res);
				dialog.pack();
				dialog.open();

				if(dialog.getSize().x>300 || dialog.getSize().y >300)
					dialog.setSize(300, 300);
				else
					dialog.pack();
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action
		
		
		//read data
		try 
		{				
			DeviceData in = new DeviceData();
			DeviceData mydata = masterView.getMaster().command_inout("DevCheck", in);
			String job = mydata.extractString();

			String arr[] = job.split("\n", 4);
			
			text1.setText(arr[1]);
			text2.setText(arr[2]);

			
		}
		catch (DevFailed e) 
		{
			System.out.println(e);
		};
		//
		
	}
	
	
	public void propertyChange(PropertyChangeEvent event) {
		
		if(event.getProperty().equals("job_sent")) 
		{
			String val = (String)event.getNewValue();
			String id_ind[] = val.split("\n",2);
			
//			read data
			try 
			{				
				
				DeviceData in = new DeviceData();
				in.insert("job#" + id_ind[1].substring(id_ind[1].indexOf("\n") + 1));
				DeviceData mydata = masterView.getMaster().command_inout("DevCheck", in);
				String job = mydata.extractString();

				String arr[] = job.split("\n");
				
				text1.setText(arr[1]);
				text2.setText(arr[2]);
				text3.setEnabled(true);
				text3.setText(id_ind[0]);
				
				res = "";
				for(int i = 3; i<arr.length; i++)
				{
					res += arr[i];
					if(i != arr.length - 1)
						res += "\n";
				}
				buttonContents.setToolTipText(res);
				text4.setText("QUEUED");
			}
			catch (DevFailed e) 
			{
				System.out.println(e);
			};
			//
			
		}

		
		else if(event.getProperty().equals("job_sent_slave"))
		{
			String job = (String)event.getNewValue();	
			
			String arr[] = job.split("\n");
			
			text1.setText(arr[1]);
			text2.setText(arr[2]);
			text3.setEnabled(false);
			
			res = "";
			for(int i = 3; i<arr.length; i++)
			{
				res += arr[i];
				if(i != arr.length - 1)
					res += "\n";
			}

			buttonContents.setToolTipText(res);
			text4.setText("EXECUTING");
		}
		else if(event.getProperty().equals("output_sent")) 
		{
			String val = (String)event.getNewValue();
			
			text1.setText(val);
			text2.setText("output");
			text3.setEnabled(false);
			text4.setText("FINISHED");
			try 
			{				
				DeviceData in = new DeviceData();
				in.insert(Long.parseLong(val));
				DeviceData mydata = masterView.getMaster().command_inout("DevGetOutput", in);
				res = mydata.extractString();
				res = res.substring(0, res.length()-1);
				buttonContents.setToolTipText(res);
				console.displayOk(masterView.getMasterName()+" -> \"Display output\"" + ":   EXECUTED");
			}
			catch (DevFailed e) 
			{
				console.displayErr(masterView.getMasterName()+" -> \"Display output\"" + ":   EXECUTED");
			};
		}

			
			
		}
			
	//
	///Find
	//
	
	/**
	 * This method initializes compositeFind
	 *
	 */
	private void createCompositeFind() {
		Group group = new Group(top, SWT.NONE);
		group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group.setText(".::FIND A JOB::.");
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		group.setLayout(gL);
		
		final Text text = new Text(group, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		final Button button = new Button(group, SWT.PUSH);
		button.setText("-> FIND <-");
		button.setEnabled(false);
		
		
		text.addListener(SWT.Verify, new Listener() {
			public void handleEvent(Event e) {
				String string = e.text;
				char[] chars = new char[string.length()];
				string.getChars(0, chars.length, chars, 0);
				for (int i = 0; i < chars.length; i++) {
					if (!('0' <= chars[i] && chars[i] <= '9')) {
						e.doit = false;
						return;
					}
				}
            }
		});
		
		text.addKeyListener(new KeyListener(){
			
			public void keyPressed(KeyEvent event){
			}
			
			public void keyReleased(KeyEvent event){
				if(text.getCaretPosition() == 0)					
				{
					button.setEnabled(false);
				}
				else
				{
					button.setEnabled(true);
				}
			
			}
		});

//		action
		button.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					DeviceData in = new DeviceData();
					long tmp = Long.valueOf(text.getText()).longValue();
					in.insert(tmp);
					DeviceData out = masterView.getMaster().command_inout("DevGetJobState", in);
					short my_out = out.extractShort();  

			        MessageBox messageBox = new MessageBox(top.getShell(), SWT.ICON_INFORMATION | SWT.OK);
			        
			        messageBox.setText("Searching results:");
			        
			        switch(my_out) 
			        {
			        	case 0:
			        		messageBox.setMessage("The job with id: " + tmp + " is waiting for the execution in the queue");
			        		break;
			        		
			        	case 1:
			        		messageBox.setMessage("The job with id: " + tmp + " is being executed");
			        	  	break;
			        	  		
			        	case 2:
			        		messageBox.setMessage("The job with id: " + tmp + " was executed and there is some output");
			        		break;
			        			
			        	case 99:
			        		messageBox.setMessage("The job with id: " + tmp + " was not found");
			        		break;
			        }
	
			        messageBox.open();
			       
			        text.setText("");
			        button.setEnabled(false);
					
				}
					catch (DevFailed e) 
					{
						System.out.println(e);
					};
				
			}
			
			public void widgetDefaultSelected(SelectionEvent event){
			}
		});
		//~action	
		
		
	}
	
	
	
	private void updateMethod() 
	{
		final int time = 1000;
        timer = new Runnable () 
        {
        	public void run () 
        	{
        		if(masterView.outputListCreated == true && block == false)
        		{
        			OutputList.thisView.addPropertyChangeListener(thisView);
        			block = true;
        		}
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	
}