package bqs_perspective;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class DebugConsole extends MessageConsole 
{

	private MessageConsoleStream errMessageStream;

	private MessageConsoleStream okMessageStream;

	public static DebugConsole thisConsole = null;

	public static final String ID = "bqs_perspective.debugconsole";


	public DebugConsole() {

	super("BQS Debug", null);
	thisConsole = this;

	this.okMessageStream = newMessageStream();
	this.okMessageStream.setColor(Display.getCurrent().getSystemColor(
	SWT.COLOR_DARK_GREEN));
	this.errMessageStream = newMessageStream();
	this.errMessageStream.setColor(Display.getCurrent().getSystemColor(
	SWT.COLOR_RED));
	}

	

		public void displayOk(String message){
		okMessageStream.println(message);
		}


		public void displayErr(String message){
		errMessageStream.println(message);
		}

}
