package bqs_perspective;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

	private IWorkbenchAction exitAction;
	private IWorkbenchAction helpAction;
	private IWorkbenchAction backAction;
	private IWorkbenchAction prefAction;
	private IWorkbenchAction abouAction;
	
	
    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
    	exitAction = ActionFactory.QUIT.create(window);
		register(exitAction);
		helpAction = ActionFactory.HELP_CONTENTS.create(window);
		register(helpAction);
		backAction = ActionFactory.BACK.create(window);
		register(backAction);
		prefAction = ActionFactory.PREFERENCES.create(window);
		register(prefAction);
		abouAction = ActionFactory.ABOUT.create(window);
		register(abouAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
    	MenuManager fileMenu = new MenuManager("&File",
				IWorkbenchActionConstants.M_FILE);
    	MenuManager editMenu = new MenuManager("&Edit",
				IWorkbenchActionConstants.M_FILE);
    	MenuManager viewMenu = new MenuManager("&View",
				IWorkbenchActionConstants.M_FILE);
    	MenuManager helpMenu = new MenuManager("&Help",
				IWorkbenchActionConstants.M_FILE);
    	
    	
		menuBar.add(fileMenu);
		menuBar.add(editMenu);
		menuBar.add(viewMenu);
		menuBar.add(helpMenu);
		
		fileMenu.add(exitAction);
		editMenu.add(backAction);
		viewMenu.add(prefAction);
		helpMenu.add(abouAction);
		helpMenu.add(helpAction);
    }
    
}
