package bqs_perspective;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;

public class AddBatchWizard extends Wizard implements INewWizard 
{
	private Master view;
	private AddBatchPage1 page1;
	private DebugConsole console = null;

	public AddBatchWizard() 
	{
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setWindowTitle("Add batch of jobs");
		setNeedsProgressMonitor(true);
		setDefaultPageImageDescriptor(ImageDescriptor.createFromImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/help_hand.gif")));

	}
	
	public boolean performFinish()
	{
		if(page1.getSelection().length == 0)
		{
			page1.setErrorMessage("At leat one job must be chosen!");
			return false;
		}
		
		view = Master.thisView;
		console = DebugConsole.thisConsole;
		
		String filepath = "";

		for(int i = 0; i < page1.getSelection().length; i++)
		{
			String s = "", s2 = "";
			
			filepath = page1.getSelection()[i];
			
			try
			{
				BufferedReader in;
				
				try
				{
					in = new BufferedReader(new FileReader(filepath));
					while((s = in.readLine())!= null)
						s2 += s + "\n";
					in.close();
				}
				catch(FileNotFoundException eIO)
				{
					System.out.print("File Not Found:" + filepath);
				}
				
			} 
			catch(IOException e) 
			{
		      System.out.println(e);
			}

	
			if(filepath.substring(filepath.length()-3).equals(".py"))
			{
				s2 = view.getMasterName().substring(5)+"\npython\n" + s2;
			}
			else
			{
				s2 = view.getMasterName().substring(5)+"\nbash\n" + s2;
			}
			
			try 
			{				
				DeviceData in = new DeviceData();
				in.insert(s2);
				DeviceData out = view.getMaster().command_inout("DevEnQueue", in);
				long id = out.extractLong();
	
			    console.displayOk(view.getMasterName()+" -> \"DevEnQueue\":  EXECUTED, new job added ("+id+")");
			}
			catch (DevFailed e) 
			{
				console.displayErr(view.getMasterName()+" -> \"DevEnQueue\"" + ":   "+e);
			};
		
		}

		return true;
	}
	
	public void addPages() 
	{
		page1 = new AddBatchPage1();
		page1.setTitle("ADD BATCH OF JOBS");
		page1.setDescription("Choose all the jobs you want to add to the queue");
		addPage(page1);

	}

		
	
}
