package bqs_perspective;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.jface.wizard.WizardPage
;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class AddBatchPage1 extends WizardPage {

	private Composite top;
	private Table table;
	private Label labelInfo;
	private Tree tree;
	public static AddBatchPage1 thisPage = null;
	private String glob_path = null;
	private SashForm sash;
	private String readFile = "";
	private Shell editShell;


	public AddBatchPage1() 
	{
		super("AddBatchPage1");
		thisPage = this;
	}
	
	public void createControl(Composite parent) 
	{

		top = new Composite(parent, SWT.NONE);
		top.setLayout(new FillLayout());

        
		createBrowser();

		setControl(parent);
		
		return;
	}

	private void createBrowser()
	{
		sash = new SashForm(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		sash.setLayout(gL);

		
        createTree(sash);
        createTable(sash);
	}
	
	private void createTable(SashForm sash) 
	{    
		Composite compositeT = new Composite(sash, SWT.NONE);
		compositeT.setLayout(new GridLayout());
		compositeT.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		table = new Table(compositeT, SWT.MULTI|SWT.BORDER );
		table.setLayoutData(new GridData(GridData.FILL_BOTH));
		table.setLayoutData(new GridData(GridData.FILL_BOTH));
	    
		createLabels(compositeT);
		
		table.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent event)
			{
				if(getErrorMessage().equals("At leat one job must be chosen!") || table.getSelectionCount() != 0)
					setErrorMessage("OK");
				else if(getErrorMessage().equals("OK") || table.getSelectionCount() == 0)
					setErrorMessage("At leat one job must be chosen!");
				
				
				labelInfo.setText("Selected: "+ table.getSelectionCount() + " of " + table.getItemCount()+" file(s)");
		    	}
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		    	
		    });

	}

	private void createLabels(Composite composite)
	{
		Composite compositeL = new Composite(composite, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		compositeL.setLayout(gL);
		compositeL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		labelInfo = new Label(compositeL, SWT.LEFT);
		labelInfo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		labelInfo.setText("Selected: "+ table.getSelectionCount() + " of " + table.getItemCount()+" file(s)");
		
		Button button = new Button(compositeL, SWT.PUSH);
		button.setText("Edit");
		button.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		button.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent event)
			{
				if(getSelection().length == 0)
					setErrorMessage("Choose a file!");
				else if(getSelection().length > 1)
					setErrorMessage("Too many files chosen!");
				else
				{
					readFile = getSelection()[0];
					createEdit();
					
					if(getErrorMessage().equals("Too many files chosen!") || getErrorMessage().equals("Choose a file!"))
						setErrorMessage("OK");
				}
		    	}
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		    	
		    });
	}
	

	private void createEdit()
	{
		editShell = new Shell(top.getShell(), SWT.APPLICATION_MODAL|SWT.DIALOG_TRIM);	
		editShell.setLayout(new GridLayout());
		editShell.setText(readFile);
		
		Text text = new Text(editShell, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		text.setLayoutData(new GridData(GridData.FILL_BOTH));
		String out = "", s;
		
		//read file
		try
		{
			BufferedReader stdInput = new BufferedReader(new FileReader(readFile));

			while ((s = stdInput.readLine()) != null)
				out += "\n" + s;
			out = out.substring(1);
			
			text.setText(out);
		}
			catch (Exception e)
		{
				text.setText("File input error");
		}		
		//~read file
			
			createButtons(editShell, out, text);
			
			editShell.setSize((int)(top.getSize().x * 1.03), top.getSize().y * 2);
			editShell.open();
	}
	
	private void createButtons(Shell shell, final String outputString, final Text text)
	{
		Composite compositeB = new Composite(shell, SWT.NONE);
		compositeB.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		compositeB.setLayout(gL);
		
		Button save = new Button(compositeB, SWT.PUSH);
		save.setText("Save");
		save.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Button cancel = new Button(compositeB, SWT.PUSH);
		cancel.setText("Cancel");
		cancel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		save.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent event)
			{
				try 
				{
					BufferedWriter out = new BufferedWriter(new FileWriter(readFile));
					out.write(outputString);
					out.close();
					editShell.dispose();
				}
				catch (IOException e) 
				{
					text.setText("You can't access file: " + readFile + "\nCheck your permissions!\nPress Cancel (This text is not going to be saved)");
				}
			}
			public void widgetDefaultSelected(SelectionEvent event)
		 	{
		 	}    	
		});
		
		
		cancel.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent event)
			{
				editShell.dispose();
			}
			public void widgetDefaultSelected(SelectionEvent event)
		 	{
		 	}    	
		});
		
		
	}
	
	/**
	 * setRootDirectory 
	 */
	 private void setRootDirectory(File dir) 
	 {
		 if(! (dir.exists() && dir.isDirectory()))
			 throw new IllegalArgumentException("Invalid directory. ");

		 table.removeAll();

		 File[] files = dir.listFiles();
		 int counter = 0;
		 
		 for(int i=0; files != null && i < files.length; i++) 
		 {
			 File file = files[i];
			 
			 
			 if(files[i].isDirectory())
				 continue;
			 
			 counter++;
			 
			 TableItem item;
			 item = new TableItem(table, SWT.NULL);
			 item.setText(file.getName());
			 item.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
			 item.setBackground(counter % 2 == 0 ? top.getDisplay().getSystemColor(SWT.COLOR_WHITE) :
				 top.getDisplay().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		 }
	 }
	
	 
	 
	 
	 /**
	  * createTree
	  */
	 private void createTree(SashForm sash)
	 {
		 tree = new Tree(sash, SWT.BORDER);
		 tree.setLayoutData(new GridData(GridData.FILL_BOTH));

		 File main = new File("/mnt");
		 File roots[] = main.listFiles();
		 
		 for (int i = 0; i < roots.length; i++) 
		 {
			 TreeItem root = new TreeItem(tree, 0);
			 root.setText(roots[i].toString());
			 root.setData(roots[i]);
			 root.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
			 new TreeItem(root, 0);
		 }
		 
		 tree.addListener(SWT.Expand, new Listener() 
		 {
			 public void handleEvent(final Event event) 
			 {
				 final TreeItem root = (TreeItem) event.item;
				 TreeItem[] items = root.getItems();
				 for (int i = 0; i < items.length; i++) 
				 {
					 if (items[i].getData() != null)
						 return;
					 items[i].dispose();
				 }
				 File file = (File) root.getData();
				 File[] files = file.listFiles();
				 if (files == null)
					 return;
				 for (int i = 0; i < files.length; i++) 
				 {
					 if(files[i].isDirectory() == false)
						 continue;
		        	
					 TreeItem item = new TreeItem(root, 0);
					 item.setText(files[i].getName());
					 item.setData(files[i]);
					 item.setFont(new Font(Display.getDefault(), "Sans", 8, SWT.NORMAL));
					 if (files[i].isDirectory()) 
					 {
						 new TreeItem(item, 0);
					 }
				 } 	        
			 }
		 });
		 
		 tree.addSelectionListener(new SelectionListener()
		 {
			 public void widgetSelected(SelectionEvent event)
			 {
		    		
				 TreeItem item = (TreeItem)event.item;
				 String path = item.getText();	  
				 do
				 {
					 if(item.getText().equals("/mnt/inhouse") || item.getText().equals("/mnt/external"))
						 break; 
					 item = item.getParentItem();
					 path = item.getText() + "/" + path;
				 }
				 while(true);
		    		
				 setRootDirectory(new File(path));
				 glob_path = path;
				 labelInfo.setText("Selected: "+ table.getSelectionCount() + " of " + table.getItemCount()+" file(s)");

			 }
		    	
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		 });
		 
	 }
	 
	
	public String[] getSelection()
	{
		String selected[] = new String[table.getSelectionCount()];
		for(int i = 0; i < table.getSelectionCount(); i++)
			selected[i] = glob_path + "/" + table.getSelection()[i].getText();
		
		return selected;
	}
	
}
