/*  These are the functions that are supported in 
    AcqControl, They are also the array position
    pointers used in ACQCMD_BOARDOPTIONS
*/
typedef enum {
	ACQCMD_WIDTH = 0,              /* 0 */
	ACQCMD_HEIGHT,
	ACQCMD_GREATERTHANEIGHT,       /* return TRUE if image BPP > 8 */
	ACQCMD_PASSTHRU,
	ACQCMD_CONTROLOPTS,
	ACQCMD_DESCRIPTION,            /* 5 */
	ACQCMD_VIDEOSTD,
	ACQCMD_CAMERA,
	ACQCMD_CHANNEL,					/* select input cable. */
	ACQCMD_CONTRAST,
	ACQCMD_BRIGHTNESS,              /* 10 */
	ACQCMD_GENLOCK,
	ACQCMD_EXTRIG,
	ACQCMD_GREYACQUIRE,
	ACQCMD_BPP,
	ACQCMD_HUE,                     /* 15 */
	ACQCMD_SAT,
	ACQCMD_CAMERARGB,
	ACQCMD_VOLTAGE,
	ACQCMD_NFRAMES,
	ACQCMD_SETFRAME,                /* 20 */

	ACQCMD_CONFIGDLG,
	ACQCMD_BOARDHANDLE, 
 
	ACQCMD_OPTSTART,
	ACQCMD_OPTEND,

	ACQCMD_BOARDOPTIONS,            /* 25 */
	ACQCMD_2MONLIVE,
	ACQCMD_MULTISNAP,

	ACQCMD_SUBCLASSLIVE,
	ACQCMD_SUBCLASSOPTIONS,
	ACQCMD_CNFGSTOPLIVE,            /* 30 */

	ACQCMD_PTSIZE,
	ACQCMD_PTSPEED,
	ACQCMD_APPHANDLE,

	ACQCMD_CUTOFF,
	ACQCMD_AUTOGAIN,                /* 35 */
	ACQCMD_FRAMESKIP,
	ACQCMD_MAXSKIP,
	ACQCMD_RESERVED,

	ACQCMD_DCIOPEN,
	ACQCMD_DCICLOSE,                /* 40 */
	ACQCMD_DCIXFER,                              
	
	ACQCMD_OPTIONS,
	ACQCMD_MODE,
	ACQCMD_LUT,
	ACQCMD_ZOOM,					/* 45 */
	ACQCMD_PANSCROLL,
	ACQCMD_LOADACQDRIVER,			/* FOR INTERNAL USE ONLY! */

	ACQCMD_CAPTRECT,
	ACQCMD_EXPOSURE,
	ACQCMD_DIGITALSNAP,             /* 50 */
	ACQCMD_DIGITALSTATUS,
	ACQCMD_BINNING,
	ACQCMD_DIGITALGAIN,
	ACQCMD_INIFILE,											

	ACQCMD_CAPTRECT_LIMITS,									/* 55 */
	ACQCMD_CHANNEL_LIMITS,
	ACQCMD_CONTRAST_LIMITS,
	ACQCMD_BRIGHTNESS_LIMITS,                               
	ACQCMD_HUE_LIMITS,                                                      
	ACQCMD_SAT_LIMITS,										/* 60 */
	ACQCMD_CAMERARGB_LIMITS,
	ACQCMD_VOLTAGE_LIMITS,
	ACQCMD_ZOOM_LIMITS,											
	ACQCMD_PANSCROLL_LIMITS,								
	ACQCMD_EXPOSURE_LIMITS,									/* 65 */
	ACQCMD_BINNING_LIMITS,
	ACQCMD_DIGITALGAIN_LIMITS,
	ACQCMD_AVG_LIMITS,
	ACQCMD_INIFILE_NAME,

	/* Options for frelon-EDT driver */
	FRLCMD_BURST = 1000,	/* Multisnap in burst mode                                          */
	FRLCMD_SEND,			/* For sending data to the camera via a C or C++ program            */
	FRLCMD_CHANNEL,			/* Define the readout mode for the frelon and for the mux           */
	FRLCMD_RESET,			/* Resets the system frelon + mux + edt board                       */
	FRLCMD_ROI_MAX,			/* Returns in lParam a RECT that contains the maximal ROI supported */
	FRLCMD_GETPARAM,		/* Get camera parameters                                            */
	FRLCMD_SET_EXTRIG,		/* Set external trigger                                             */
	FRLCMD_GET_EXTRIG,		/* Get external trigger                                             */
	FRLCMD_SET_RINGBUFFER,  /* Set or unset the ring buffer mode                                */
	FRLCMD_GET_RINGBUFFER,  /* Get ring buffer mode                                             */
	FRLCMD_SET_RINGBUFFER_T,/* Set up ring buffer timeout										*/
	FRLCMD_GET_RINGBUFFER_T,/* Get ring buffer timeout											*/
	FRLCMD_GET_ADC,			/* Get adc values													*/
	FRLCMD_GET_DAC,			/* Get dac values													*/
	FRLCMD_SENDU,			/* For getting unformatted command                                  */
	FRLCMD_STATE,			/* Get Acquisition status  1=Free 0=Exposing                        */
	FRLCMD_SETHBINNING,		/* Set Horizontal binning                                           */
	FRLCMD_SETVBINNING,		/* Set Horizontal binning                                           */
	FRLCMD_GETCWIDTH,		/* Get Current width                                                */
	FRLCMD_GETCHEIGHT,		/* Set Current Height                                               */
	FRLCMD_SETMODE,	  	    /* Set camera mode                                                  */
	FRLCMD_SETSLN,	  	    /* Enable spectroscopy mode                                         */
	FRLCMD_SETSIN,		    /* Enable spectroscopy mode                                         */
	FRLCMD_SETEXPOSURE,	    /* Set integration time                                             */
	FRLCMD_SETVERTMIRROR,   /* Set Vertical mirror                                              */
	FRLCMD_SETHORZMIRROR,   /* Set Horizontal mirror                                            */
	FRLCMD_GETVERTMIRROR,   /* Get Vertical mirror                                              */
	FRLCMD_GETHORZMIRROR,   /* Get Horizontal mirror                                            */
	FRLCMD_STOP,            /* Stop aquisition                                                  */
	FRLCMD_SETCONCATMODE,   /* Set or unset concat mode                                         */
	FRLCMD_SETCAPTRECT,     /* Set Capture rectangle                                            */
	FRLCMD_SETSLB,			/* Set Spectro beginning line                                       */
	FRLCMD_GETDEPTH,		/* Return the depht of the camera									*/
	FRLCMD_GETHDDMODE,		/* Return the hdd mode												*/
	FRLCMD_GETHDDPREF,      /* Return the hdd filename prefix                                   */
	FRLCMD_GETHDDDESCR,     /* Return the hdd filename description                              */
	FRLCMD_GETHDDOUT,		/* Return 1 when user wants to get the acquisition result in IPP    */
	FRLCMD_SETHDDMODE,		/* Set the hdd mode												    */
	FRLCMD_SETHDDPREF,      /* Set the hdd filename prefix                                      */
	FRLCMD_SETHDDDESCR,     /* Set the hdd filename description                                 */
	FRLCMD_SETHDDOUT,		/* Allow to return the EDF files in IPP gui                         */
	FRLCMD_GETNBDMA,		/* return number of DMA buffer										*/

	/* This MUST remain last */
	ACQCMD_LAST,
} ACQCMD;