/*static char RcsId[] = "$Header: /segfs/dserver/classes/ccd/imagepro/include/RCS/ImagePro.h,v 1.3 2001/03/21 18:55:43 goetz Exp $ ";*/
/*********************************************************************
 *
 * File:	ImagePro.h
 *
 * Project:	Beamline Control
 *
 * Description:	The public include file the ImagePro device class for
 *		controlling the ImagePro xray camera.
 *		
 *
 * Author(s):	Andy Gotz
 *
 * Original:	3 December 1997
 *
 * $Log: ImagePro.h,v $
 * Revision 1.3  2001/03/21 18:55:43  goetz
 * *** empty log message ***
 *
 *
 * Copyright(c) 1997 by European Synchrotron Radiation Facility, 
 *                      Grenoble, France
 *
 *
 *********************************************************************/

#ifndef _IMAGEPRO_H
#define _IMAGEPRO_H

/*************************************************************************
 * Include here the file which contains the definition of DevsensiCamBase,
 * may be  CntrlDsNumbers.h, DasDsNumbers.h or BlcDsNumbers.h.
 * See DSN096.
 *************************************************************************/
#include <BlcDsNumbers.h>

typedef struct _ImageProClassRec *ImageProClass;
typedef struct _ImageProRec *ImagePro;

extern ImageProClass imageProClass;

/*************************************************************************
 * Example of definition of commands which are not belonging to DevCmds.h
 * See DSN096.
 *************************************************************************/


#define DevIpMacroRun		DevImageProBase + 1
#define DevIpMacroStop		DevImageProBase + 2
#define DevIpMacroLoad		DevImageProBase + 3
#define DevIpAcqControl		DevImageProBase + 4
#define DevIpAcqTimed		DevImageProBase + 5
#define DevIpSetVariable	DevImageProBase + 6
#define	DevIpAcqSnap		DevImageProBase + 7
#define DevIpWsSaveAs		DevImageProBase + 8
#define DevIpGetImageSize	DevImageProBase + 9
#define DevIpGetImage		DevImageProBase	+ 10
#define DevIpGetArea		DevImageProBase + 11
#define DevIpWsChangeDescription DevImageProBase + 12
#define DevIpGetVariable	DevImageProBase + 13
#define DevIpPreSnapMacro	DevImageProBase + 14
#define DevIpPostSnapMacro	DevImageProBase + 15
#define DevIpDocId			DevImageProBase + 16
#define DevIpDocSelect		DevImageProBase + 17

#define DevIpGetStats		DevImageProBase + 18



#endif /*_SENSICAM_H*/
