static char RcsId[] = "$Header: /segfs/dserver/classes++/beamline/id11/fitem/src/RCS/startup.cpp,v 1.1 2003/05/16 04:55:58 goetz Exp goetz $";

//+**********************************************************************
//
// File:	startup.C
//
// Project:	Device Servers in C++
//
// Description:	Startup file for the Fitem class implemented in C++
//		
//
// Author(s):	Andy Gotz
//
// Original:	April 2000
//
// $Revision: 1.1 $
//
// $Date: 2003/05/16 04:55:58 $
//
// $Author: goetz $
//
// $Log: startup.cpp,v $
// Revision 1.1  2003/05/16 04:55:58  goetz
// Initial revision
//
// Revision 1.2  2001/04/10 08:00:43  goetz
// latest version from ID11
//
// Revision 1.1  2001/01/30 13:48:41  goetz
// Initial revision
//
// Revision 1.1  2000/05/03 18:52:08  goetz
// first version deployed on cryopc
//
//
//+**********************************************************************
		
#include <pthread.h>
#include <iostream>
#include <string>
#include <API.h>
#include <DevSignal.h>
#include <DevServer.h> 
#include <Fitem.h>

Fitem *device_ds[16];
unsigned int n_devices;

long startup(char *svr_name, long *error)
{
   char **dev_list;
   unsigned int i;
   long status;

   cout << "startup(): startup for Fitemds (server name = " << svr_name << ")" << endl;

//
// install signal handler
//

//   ds__signal(SIGINT,catchSig,error);
//   ds__signal(SIGQUIT,catchSig,error);
//   ds__signal(SIGHUP,catchSig,error);

//
// get the list of device name to be served from the static database
//

   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
        cout << "startup(): db_getdevlist() failed, error " << *error << endl;
        return(DS_NOTOK);
   }
   cout << "startup(): following devices found in static database: " << endl << endl;
   for (i=0;i<n_devices;i++)
   {
       	cout << "\t" << dev_list[i] << endl;
   }

//
// now loop round creating and exporting the devices
//

   for (i=0; i<n_devices; i++)
   {
      	device_ds[i] = new Fitem(dev_list[i],error);
	if ((device_ds[i] == 0) || (*error != 0))
	{
		cout << "startup(): error when trying to create device " << dev_list[i] << endl;
		return(DS_NOTOK);
	}

//
// export the device onto the network
//

      	status = dev_export((char*)device_ds[i]->name,(Device*)device_ds[i],(long*)error);

      	cout << "startup(): dev_export() returned " << status << " (error = " << *error << ")" << endl;
   }

   cout << "startup(): leaving startup and all is OK" << endl;

   return(DS_OK);
}
