//static char RcsId[] = "$Header: /segfs/dserver/classes++/beamline/id11/fitem/include/RCS/Fitem.h,v 1.1 2003/05/16 04:56:12 goetz Exp goetz $";

//+**********************************************************************
//
// File:	Fitem.h
//
// Project:	Device Servers in C++
//
// Description:	public include file containing definitions and declarations 
//		for implementing the Fitem class in C++ (FitemClass).
//
// Author(s):	Andy Gotz
//
// Original:	May 2001
//
// $Revision: 1.1 $
//
// $Date: 2003/05/16 04:56:12 $
//
// $Author: goetz $
//
// $Log: Fitem.h,v $
// Revision 1.1  2003/05/16 04:56:12  goetz
// Initial revision
//
//
//
//+**********************************************************************

#ifndef _Fitem_H
#define _Fitem_H

class Fitem : public Device {

//
// private members
// 

private :

   long ClassInitialise (long *error );
   long GetResources (char *res_name, long *error);

   static short         class_inited;
   static short		class_destroyed;

   char			*rebin_file; 		/* rebinned file */
   char			*fit_file; 		/* fit output file */
   double		*xb;			/* rebinned positions */
   double		*yb;			/* rebinned counts */
   double		*sb;			/* rebinned sigma  */
   double		x_start;
   double		x_end;
   double		x_step;
   int			nbins;			/* number of bins */

//
// protected members
//

protected:

//
// routines that actually do the work, adapted from Gavin's rebin.c to
// get scan input data from internal array (which have been previously
// copied from SPEC)
//
   int fit (char *file, float start, float end, float step, int scan, double *fits);
   int output_fit (float start, float end, float step);

   long StateMachine (long cmd, long *error);
//
// commands
//

   long FitSinglePeak (void *argin, void *argout, long *error);
   long SetParameters (void *argin, void *argout, long *error);
   long NewFile (void *argin, void *argout, long *error);

//
// public members
//
public:


   Fitem (char *name, long *error);
   ~Fitem ();


//
// Some very simple member functions to get object private data
//

// inline short get_nada(void) {return(nada);}
};

//#define FitemSinglePeak        		1 
#define FitemSinglePeak        		DevFitemBase+1 
#define FitemSetParameters     		DevFitemBase+2

#endif /* _Fitem_H */
