#include <stdio.h>
#include <string.h>
#include <math.h>
#define NRANSI
#include "../headers/leastsq.h"
#include "../../utilities/headers/gbmv_util.h"
#include "../../utilities/headers/nrutil.h"

#define VERBOSE 0
/***************************************************************/
/* this file features things needed to input parameters, guess */
/* peak parameters, and write an input file for marquette.     */
/***************************************************************/

/* marquette needs a new file, containing 'lasting' parameters */
/* input protocol : 
   active vs passive - command line fname or argc = 1    
   defaults for plotopt, statistics
*/

/* in the case of marquette output, do we want a file generated? */
/* give choice of refits... */


/* input :

file related :

1) file name 
2) scan number
3) no. of data points ( to be read by better grabber )
4) assign uncertainties

model related :

1) no. of parameters (prop # of peaks)
2) model type : always pv for the moment
3) range to be used ( must recalculate data points )
4) should prog guess initial parameters ? (intensities)

 Could input just relative peak intents, then scale them considering
 highest data + fw...

5) bk complexity...
 
parameters themselves 

1) 'global' - fw + eta
2) background
3) peak pos + int

how to input : 

1) read from current data file
2) read from stdin
3) read from para file

give choice between 2 + 3 ? command line arg ?

run it from a spec macro : default to last scan, 
default parameters : 1 peak,  pseudo voigt. const back at value of lowest point. refine all.
range all on command line...
**/

int term_input(short  p, char *datafile, char *ctlfile, unsigned long ndata )
{
/** get plotopt elsewhere **/

  FILE *fpj, *fpflag;
  char inp_string[132], line[132];
  int nint=1, npar=11, plotopt=1, *ia ; /** should get a better way */
  int npeaks=1, i, back_order;
  float *a, f_temp;
  struct peak_params guess = { 0.00001, 0.0000, .05, .5, 1.0e38 };

/* prompt for input from terminal, with default values, If they hit q, */
/* remaining parameters are defaulted. for background, detect order. */
/* prompt for number of peaks */

  npeaks = 1; /** defaults for unprompted input **/
  npar = 11;
  back_order=1;

  if(p) { /* prompted input */
    printf("return for default...\n\n");
  
    printf("number of peaks [1] ?  ");
    if(!(getline(inp_string, 132))) 
      npar = 11;
    else {
      while(!is_an_int(inp_string,&npeaks)){
	printf("%s is not an integer\n", inp_string);
	if(yorn_dialogue("enter another value?"))
	  getline(inp_string, 132);
	else
	  exit(1);
      }
      npar = 9 + npeaks * 2;
      if(npeaks>1) p=1 ;/* must use prompted input */
    }
   
    printf("order of background (negative for _NO_ background) [%d] ?",
	   back_order);
    if(getline(inp_string, 132)) {
      while(!is_an_int(inp_string,&back_order)){
	printf("%s is not an integer\n", inp_string);
	if(yorn_dialogue("enter another value?"))
	  getline(inp_string, 132);
	else
	  exit(1);
      }
    }
    if(back_order>6) {
      printf("you asked for a ridiculously high order polynomial for your background\n");
      printf("for the moment, I refuse to give you anything higher than six\n");
      back_order=6;
    }
  }
 /* allocate parameter and refine key arrays here */

  a = vector(1, npar);
  ia = ivector(1, npar);
  
  if(back_order>=0) {
    a[1] = 1.;
    ia[1] = 1;
  } else {
    a[1] = 0.;
    ia[1] = 0;
  }
  if(back_order>=1) {
     a[2] = 0.1;
    ia[2] = 1;
  } else {
    a[2] = 0.;
    ia[2] = 0;
  }
  for(i=3; i<=(back_order+1); i++) {
    a[i] = 0.000001;
    ia[i] = 1;
  }
  for( ; i<=7; i++) {
    a[i] = 0.;
    ia[i] = 0;
  }
	/** get rid of this if they want to flag em later */
  for(i=8; i<=npar; i++) ia[i] = 1;
  /* should read in defaults if they exist */
  /* these are what to hold, where, what to vary */
  /* what background, what eta */
  if((fpflag=open_file_to_read_if_it_exists("flags.par")) != NULL) {
    printf("flags were  %d %d %d %g\n", ia[1], ia[2], ia[3], a[9]);
    fscanf(fpflag, "%d %d %d %g", &ia[1], &ia[2], &ia[3], &a[9]);
    printf("flags are %d %d %d %g\n", ia[1], ia[2], ia[3], a[9]);
    if(!ia[1]) a[1]=0.;
    if(!ia[2]) a[2]=0.;
    if(!ia[3]) a[3]=0.;
    if( a[9]==0 || a[9] == 1) ia[9]=0;
    fclose(fpflag);
  }

  if(npeaks == 1) { /** must do it with prompt if npeaks > 1 **/
#if VERBOSE
    printf("npeaks = 1 why does it not work?\n");
    printf("guess.back = %g\n", guess.back);
    printf(" want to read %s\n", datafile);
    fpj = open_file_to_read(datafile);
    fgets(line, 132, fpj);
    puts(line); 
    fgets(line, 80, fpj);
    puts(line);
    fclose(fpj);
    quit_dialogue();
       
#endif
    guess_peak(&guess, datafile);
    if(back_order>=0) a[1] = 0.9 * guess.back;
    else a[1] = 0.0;
    if(back_order>=1) a[2] = 0.001 * guess.back ;
    else a[2] = 0.0;
    for(i=3; i<back_order; i++) a[i] = 0.000001;
    a[8] = guess.fw;
    if(ia[9]) a[9] = guess.eta; /* no eta in flags.par */
    a[10] = guess.intensity;
    a[11] = guess.position;
    npar = 11;
    nint = 1;
  }

  if(!p) { 
    /** must do it with prompt if npeaks > 1 **/
    /** intensity equal to zero was a bad guess **/

#if VERBOSE
    printf("in prep...npeaks = %d, prompt= %d, guess.intensity = %f\n",
	   npeaks, p, guess.intensity);
    for(i=1;i<=11;i++)
      printf("%g\t%d ** \n", a[i], ia[i]);
    for(i=12;i<=npar;i++)
      printf("%g\t%d** \n", a[i], ia[i]);
    quit_dialogue();
#endif
    if(!write_input_file(nint, npar, plotopt, ndata, a, ia, ctlfile)){
      printf("can't write input file for some reason\n");
      exit(1);
    }
    free_vector(a, 1, npar);
    free_ivector(ia, 1, npar);
    return(1);
  }

/** the rest for prompted input only **/

  if(npeaks == 1) {
    printf("guessed parameters:\n");
    for(i=1; i<=npar; i++)
      printf("a[%d] = %f, ia[%d] = %d\n", i,a[i],i,ia[i]);

    if( yorn_dialogue_default_no(
	  "would you to edit these paramaters before fitting") ){
      if(!write_input_file(nint, npar, plotopt, ndata, a, ia, ctlfile)){
	printf("can't write input file for some reason\n");
	exit(1);
      }
      printf("why am i here?\n");
      free_vector(a, 1, npar);
      free_ivector(ia, 1, npar);
      return(1);
    }
  }

  printf("fullwidth [%f] ?", guess.fw);
  if(!(getline(inp_string, 132))) 
    a[8] = guess.fw;
  else {
    if(!is_a_float(inp_string,&a[8]))
    quit_dialogue();
  }
  
  printf("eta [%f] ?", guess.eta);
  if(!(getline(inp_string, 132))) 
    a[9] = guess.eta;
  else {
    if(!is_a_float(inp_string,&a[9]))
    quit_dialogue();
  }
  for(i=10;i<=npar; i=i+2){
     printf("position and intensity for peak %d [%f,%f] ?", ((i-10)/2), guess.position, guess.intensity);
     if(!(getline(inp_string, 132))) {
       a[i] = guess.intensity;
       a[i+1] = guess.position ;
     }
     else {
       while(sscanf(inp_string,"%f%*[, \t]%f", &a[i+1], &a[i]) != 2) {
	 printf("not enough values, try again or return for default\n");
	 printf("position and intensity for peak %d [%f,%f] ?", ((i-10)/2), guess.position, guess.intensity);
	 if(!(getline(inp_string, 132))) {
	   a[i] = guess.intensity;
	   a[i+1] = guess.position ;
	 }
       }
     }
#if VERBOSE
     printf("i=%d, a[i] = %f\ni=%d, a[i] = %f\n", i, a[i], (i+1), a[i+1]);
#endif
  }

  if(!write_input_file(nint, npar, plotopt, ndata, a, ia, ctlfile)){
    printf("can't write input file for some reason\n");
    exit(1);
  }

  free_vector(a, 1,npar);
  free_ivector(ia, 1, npar);
  return(1);
}

void guess_peak(struct peak_params *guess, char datafile[])
{

  /* open data, skim through looking for : max value, pt to right closest to */
  /* being half of that, lowest value */

  FILE *fp;
  char line[132];
  static unsigned short flag = 0;
  float ymax = 0.;
  float y,x;

  fp = open_file_to_read(datafile);

/** could call this while reading in data file first time, but nice **/
/** to see guesses... **/

  printf("guessing peak = opening %s\n",datafile);

#if VERBOSE
  printf(" first line :\n");
  fgets(line,132,fp);
  puts(line);
  printf(" 2nd line :\n");
  fgets(line,132,fp);
  puts(line);
#endif

  while(fgets(line, 132, fp) != NULL) {
    if(sscanf(line, "%f%*[\t, ]%f%*[\t, ]%*s",&x,&y) != 2) {
      printf("line no damn good\n");
      puts(line);
      printf("I think x = %f, y = %f", x,y);
      exit(1);
    }
#if VERBOSE
    printf("read in :\n");
    puts(line);
    printf(" I think x=%f, y=%f",x,y);
    printf("\nguesses are back=%f, int=%f, pos=%f, fw=%f\n",
	   guess->back,guess->intensity,
	   guess->position,guess->fw);
    quit_dialogue();
#endif
    if(y>ymax) { /* call it the top */
      ymax=y;
      guess->position = x;
      flag = 0;
    } else { /* on far side of peak */
      if ( y < guess->back )
	guess->back = y;
      if( !flag && (y<=(ymax - guess->back)/2.)) { /* gives 1 pt resolution */
	guess->fw = 2. * fabs( x - guess->position );
	guess->intensity = (ymax- guess->back) * guess->fw ; 
	guess->eta = 1.0 ; /* can't think of anything more clever */
	flag = 1;
      }
    } 
  }
  /* that means peak height is less than twice background */
  /* try again looking for the halfway point on rising */
  (void)fflush(fp);
  rewind(fp);
  printf("Retry\n");
  while(fgets(line, 132, fp) != NULL) {
    if(sscanf(line, "%f%*[\t, ]%f%*[\t, ]%*s",&x,&y) != 2) {
      printf("line no damn good\n");
      puts(line);
      printf("I think x = %f, y = %f", x,y);
      exit(1);
    }
#if VERBOSE
    printf("read in :\n");
    puts(line);
    printf(" I think x=%f, y=%f",x,y);
    printf("guesses are %f, %f, %f, %f\n",guess->back,guess->intensity,\
	   guess->position,guess->fw);
    quit_dialogue();
#endif
    if(y >= (ymax+guess->back)/2.) {
      if(y != ymax)
	guess->fw = 2. * fabs( x - guess->position ); 
      else { /* one point in peak! */
	if(fgets(line, 132, fp) == NULL) /* hopeless now */
	  guess->fw = 0.05;
	else {
	  if(sscanf(line, "%f%*[\t, ]%f%*[\t, ]%*s",&x,&y) != 2) {
	    printf("line no damn good\n");
	    puts(line);
	    printf("I think x = %f, y = %f", x,y);
	    exit(1);
	  } else  /* half the distance between  points...*/
	    guess->fw = fabs( x - guess->position );
	}
      }
      printf("Ymax = %f at %f guess.back=%f setting guess.fw to %f at %f\n",
	     ymax, guess->position, guess->back, guess->fw, y);
      guess->intensity = (ymax- guess->back) * guess->fw ; 
      guess->eta = 1.0 ; /* can't think of anything more clever */
      break;
    } 
  }

  if(guess->intensity == 0.) { /** try to eliminate some crashes **/
    printf("No intensity in guessed peak !\n");
    /* that means peak height is less than twice background */
    /* give some guesses  of dubious validity... */
    guess->fw = 0.05; /* most common sort of value*/
    guess->intensity = 2.* guess->back * guess->fw;
    /* PUT THIS BACK LATER */
    /*
    quit_dialogue();
    printf("You must enter the input parameters by hand\n");
    */
  }
  fclose(fp); /* datafile */ 

}

#ifdef NUMLINES 
#undef NUMLINES
#endif
#define NUMLINES 3

int make_2colmtv( char rootname[], struct MTVINFO printinfo , short file_flag)
{

  FILE *fpmtv, *fpdat;
  int len, i;
  char *datafile, *mtvfile;
  char mtvn[] = ".mtv";
  char dat[] = ".dat";
  char inp[] = ".inp";
  char line[132];
  float x, y;
  static struct output mtv = {
    7,1,1,0,7,3,"cts/monitor "
  };

#if VERBOSE 
  printf("in 2col...\n");
#endif

  
  len = strlen(rootname); /* this gives the length without the "\0"*/
  len += 5;
  datafile = csvector(0,(len-1));
  mtvfile = csvector(0,(len-1));      
  for(i=0; i<(len-4); i++)
    mtvfile[i] = datafile[i] = rootname[i];
  strcat(mtvfile,mtvn);
  if(file_flag < 1) {/* only raw file, can't do it  */
    printf("You need to run specfit with at least +P1 in order to make a plot\n");
    return(-1);
  } else if(file_flag < 3) /** there is only an inp file **/
    strcat(datafile,inp);
  else
    strcat(datafile,dat);

#if VERBOSE 
  printf("got names ok\n");
#endif

  fpmtv = open_file_to_write(mtvfile);
  fpdat = open_file_to_read(datafile);


#if VERBOSE 
  printf("opened files ok\n");
#endif
	
  fprintf(fpmtv, "$DATA=CURVE2D\n\n%cGlobal properties\n",(35));
	  /* need to put : */
	  /* spec file name ( if exists ) */
	  /* scan number */
	  /* counts per ... */
	  /* motor name as x-axis */
  fprintf(fpmtv, "%c xlabel = \"%s\"\n", (37), printinfo.x);
  fprintf(fpmtv, "%c ylabel = \"%s\"\n", (37), printinfo.y);
  fprintf(fpmtv, "%c toplabel = \"%s\"",
	  (37),  printinfo.title);

  fprintf(fpmtv, "\n%c\n", (35));
  fprintf(fpmtv, "%c linecolor = %d\n",(37),    mtv.linecolor);
  fprintf(fpmtv, "%c linewidth = %d\n", (37),   mtv.linewidth );
  fprintf(fpmtv, "%c linetype = %d\n", (37),    mtv.linetype );
  fprintf(fpmtv, "%c markertype = %d\n", (37),  mtv.markertype);
  fprintf(fpmtv, "%c markercolor = %d\n", (37), mtv.markercolor);
  fprintf(fpmtv, "%c markersize = %d\n", (37),  mtv.markersize);
  fprintf(fpmtv, "%c linelabel  = \"%s\"\n", (37), printinfo.y );


#if VERBOSE 
  printf("wrote header ok\n");
#endif

  while(fgets(line, 132, fpdat) != NULL){
#if VERBOSE 
  printf("got this line:\n%s\n",line);
#endif
    if(sscanf(line, "%f%*[\t ,]%f%*s\n",&x,&y)!=2){
      printf("problem reading data file\n");
      exit(-1);
    }
#if VERBOSE 
  printf("got these values x=%f, y=%f\n",x,y);
#endif
    fprintf(fpmtv, " %f   %f\n",x, y);
  }
  
  fclose(fpdat);

  fprintf(fpmtv, "\n");
  fprintf(fpmtv, "\n$QUIT");
  fclose(fpmtv);
  free_csvector(mtvfile, 0 , (len-1));
  free_csvector(datafile, 0 , (len-1));
#if VERBOSE 
  printf("done with 2 column mtv file ok\n");
#endif
  return(1);
}


#undef NRANSI

