/* Driver for routine mrqmin - this is a total mess - should be rewritten */
/* in particular : want to input debug signal (ie VERBOSE at present */
/* other things... */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#define 	NRANSI
#include "../headers/leastsq.h"
#include "../../utilities/headers/nr.h"
#include "../../utilities/headers/nrutil.h"
#include "../../utilities/headers/gbmv_util.h"

#define	 	VERBOSE	0   /* usual debug type junk */
#define         CHATTY  0    /* some more excessive prints...*/

#define PER_ERR 	0.0001
#define DEFAULT_SIG	1.0     /** weight for points with 0 counts **/
#define MAX_INT		40 	/* this seems to be a limit...this will be read in eventually*/
#define  SMALL_SIG 0
#define SMALL_SIGVAL 0.1


/**************************** Converted version of xmrqmin ********************************/

#define EC_RELAX 0 /** get rid of this */

/* NOW for 1-6 indp variables (this is limited by input funct... */

/** added optional command line fname input to main */
/*- separate main, filename allocation,  and marquette driver */
/** main does essentially nothing - in order to faciliate calling by other progs */


/** extern int *Fwa, nFws; Really bad, but want to keep format consistent with general program */


int lsq_driver( char fnames[], struct MTVINFO printinfo  )
{
	FILE *fpdat, *fpctl;
	/*long idum=(-911);*/
	char line[132];
	char *datafile, *ctlfile, *plotfile, *fitfile, *mtvfile;
	char *newctlfile;
	int  fwi, fwj, same_fws;
	int i, j, k, *ia, itst, mfit, in_check;
	int len, npts, na, print_flag, nind;
	float alamda, chisq, ochisq, *a, **x, *y, *sig, **covar, **alpha;

	const char dat[] = ".dat"; /*  double quotes NULL terminate*/
	const char plt[] = ".plt";
	const char bkg[] = ".bkg";
	const char ctl[] = ".ctl";
	const char mtv[] = ".mtv";
	const char inp[] = ".inp";
	const char ncl[] = ".ncl";
	      
	len = strlen(fnames); /* this gives the length without the "\0"*/
	   
/* so to add .xxx, must allocate FIVE bits, not four*/
	
	len += 5;
	
/* (re)create file names*/
	
	datafile = csvector(0,(len-1));		/* data file*/
	ctlfile = csvector(0,(len-1));		/* control file*/
	plotfile = csvector(0,(len-1));		/* plot file*/
	fitfile = csvector(0,(len-1));		/* parameters, matrices, etc.*/
	mtvfile = csvector(0,(len-1));          /* for cool plotmtv program */
	
	for(i=0; i<(len-4); i++)
	  datafile[i] = ctlfile[i] = plotfile[i] = mtvfile[i] = fnames[i];
	
	strcat(datafile,dat); /* strcat automatically null terminates */     
	fpdat = open_file_to_read(datafile);
	strcat(ctlfile,ctl);
	fpctl = open_file_to_read(ctlfile);
	strcat(plotfile,plt);
	strcat(mtvfile,mtv);
				
	printf("Reading files %s and %s\n", ctlfile, datafile);
	printf("Writing files %s and %s\n", plotfile, mtvfile);
	
/* read control file */

	if (fgets(line, 80, fpctl) != NULL) ctl_scan(line,&npts,ctlfile);
	else {
		printf("control file does not have correct format, on line 1, quitting\n");
		exit(1);
	}
	
	if (fgets(line, 80, fpctl) != NULL) ctl_scan(line,&na,ctlfile);	
	else {
		printf("control file does not have correct format, on line 2, quitting\n");
		exit(1);
	}
	
	if (fgets(line, 80, fpctl) != NULL) ctl_scan(line,&nind,ctlfile);	
	else {
		printf("control file does not have correct format, on line 3, quitting\n");
		exit(1);
	}
	
	if (fgets(line, 80, fpctl) != NULL) ctl_scan(line,&print_flag,ctlfile);
		/*				print_flags:  	0) final short only*/
		/*						1) final long only*/
		/*						2) int + final short*/
		/*						3) int + final long*/
		/*		print_flag > 1 also makes plot + mtv files */
 	else {
		printf("control file does not have correct format, on line 4, quitting\n");
		exit(1);
	}
	
#if VERBOSE

	printf("Got by first four lines of ctl ok...\n");
	printf("Read %d %d %d %d\n\n",npts,na,nind,print_flag);
	
#endif
	
	ia = ivector(1,na); 
	/* 5/9/97 */
	Fwa = ivector(1,na); 
	a = vector(1,na); 
	mfit = 0;
	
	for (i=1; (fgets(line, 80, fpctl) != NULL && i <= na) ; i++){
	/* reading in dep. parameters - this is pointer arith..*/
	/* "a" means &a[0], thus "a+i" means &a[i]*/
	  /* 5/9/97 == added possibility of families of fws... */
		if((in_check = sscanf(line, "%f%*[,\t ;]%d%*[,\t ;]%d%*[,\t ;]", 
				      a+i, ia+i, Fwa+i)) < 2){
			printf("read in %f %d\n", a[i], ia[i]);
			printf("problem, %d items read in on line %d of \n", in_check,(i+1));
			printf("%s. Quiting is imperitive...\nI have quit, sorry.",ctlfile);
			exit(1);
		} 
		if(in_check < 3) Fwa[i]=0;
		if(ia[i]) mfit++;
#if VERBOSE
		printf("line = key %d = %d \n", i, Fwa[i]);		       
#endif
	}
	/* check number of fw (or whatever) families */
	nFws=0;
	for(fwi=1;fwi<na;fwi++) {
	  same_fws=0;
	  for(fwj=1;fwj<fwi;fwj++){
	    if(Fwa[fwj]==Fwa[fwi]) {
	      same_fws=1;
	      break;
	    }
	  }
	  if(!same_fws) nFws++;
	}
	if( (i-1) < na ) {						
		printf("couldn't read in as many parameters as you claimed,\n");
		printf("only got to line %d.",(i-1));
		quit_dialogue();
		/* didn't quit...filling in 0. (0)  for the rest of the parameters*/
		printf("\nparametes %d to %d will be held at 0.0\n\n",i,na); 
		for( ; i <= na ; i++){ 	
			a[i] = 0.;
			ia[i] = 0;	
		}
	} 
	
	dim_check((i-1), nind, ctlfile); /* make sure that there are the right number */ 
	                               /* of ind and dep variables for the compiled model*/
#if VERBOSE

	printf("Number of parameters ok says dim_check...\n\n");
	printf("(i-1) = %d, na = %d, nind = %d\n",(i-1),na,nind);
	for (i=1;i<=na;i++)
		printf("read in %d %f, %d\n", i, a[i], ia[i]);
	printf("%d parameter(s) to be fit\n\n",mfit);
	quit_dialogue();
	
#endif

	fclose(fpctl);
	free_csvector(ctlfile,0,len);
	

	x= matrix(1, npts, 1, nind);			/* indp variables*/
	y=vector(1, npts);						/* dep variable*/
	sig=vector(1, npts);					/* sigmas*/
	
	j = k = 0; /* using this as flags for sigma < 0, sigma = 0...*/
	
	for (i=1 ; (fgets(line, 132, fpdat) != NULL && i <= npts) ; i++) {

	/* this assumes that we know the format of the input, at least somewhat...*/
	/* thus I'll just write a bunch of redundant input sscanf's...*/
	/* could also do non-buffered input and look for spaces, but more risky and */
	/* time consuming*/
	
		if((in_check = data_scan(line,x,y,sig,nind,i)) != (nind+2)){
			/* data_scan returns the number of items input by scanf: ie nind + y + sig*/
			printf("problem, %d items read in on line %d of \n", in_check,i);
			printf("%s. Quiting is imperitive...\nI have to quit, sorry.",datafile);
			printf("the malfeasant line was the following :\n%s",line);
			printf("that was it - should have had %d columns\n", (nind+2));

			exit(1);
		}
		
#if EC_RELAX /** eliminate this rubbish !!! */

		/* just kludgy statistics...*/
		/* measure del Q each time, uncertainties are cumulative*/
		/* imagine that the actual 100 measurements fall in a gaussian with*/
		/* a width of 0.03 * delQ*/

		/*if(i==1) sig[1] = fabs(0.01 * y[1]);*/
		/*else sig[i] = sqrt(0.0009 * (y[i] - y[i-1]) * (y[i]- y[i-1]) + sig[i-1] * sig[i-1]);*/
		
		sig[i] = fabs(0.01 * y[i]);
#endif
		if(sig[i] < 0.0) {
#if CHATTY
			printf("You input sigma = %f on line %d...this is bad.\n", sig[i],i);
#endif
			sig[i] = -sig[i]; /* can't have negative sigma..*/
#if CHATTY
			printf("I changed it to %f\n",sig[i]);
#endif
			j++;
		} else if(sig[i] == 0.0) {
			sig[i] = DEFAULT_SIG; /* can't have zero sigma..*/
#if CHATTY
			printf("You input sigma = 0.0 on line %d...this is bad.\n", i);
			printf("I changed it to %f\n",sig[i]);
#endif
			k++;
		}
	}
#if SMALL_SIG
              sig[i] = SMALL_SIGVAL; 
#endif

	if(j || k) { /* ie if either sigmas <= 0.0*/
		printf("You had %d point(s) with sigma < 0.0 and %d point(s) with sigma = 0\n", j, k);
		printf("I was obliged to change these as indicated...");

		if(j>0) printf(" sigma = -x -> sigma = +x\n");
		if(k>0) printf(" sigma = 0 -> sigma = %f\n", DEFAULT_SIG);
#if CHATTY
		quit_dialogue();
#endif
	}
	if( (i-1) < npts ) {						
		printf("couldn't read in as many data points as you claimed,\n");
		printf("only got to line %d. Setting pts to %d.",(i-1),(i-1));
		/* should realloc...*/
		npts = i-1;/*
		quit_dialogue();
		printf("\nWill assign O.0...0.0, 0.0 +- 999.0 to points %d to %d\n\n",i,npts); 
		for( ; i <= npts ; i++){ 
			for(j=0;j<=nind; j++) x[i][j ] = 0.0;
			y[i] = 0.0;
			sig[i] = 999.0;	
			}*/
	} 
	
	fclose(fpdat); 
	free_csvector(datafile,0,len);
	
#if VERBOSE

	printf("%d data points read in\n",(i-1));
	if(yorn_dialogue( "do you want to see all of the datapoints" ))
		for (i=1;i<=npts;i++){
			printf("read in data point %d ",i);
			for(j=1;j<=nind;j++) printf("%f ",x[i][j]);
			printf("-- %f, %f\n", y[i], sig[i]);
		}
	quit_dialogue();
	
#endif
	
	covar = matrix(1,na,1,na);		/* allocate*/
	alpha = matrix(1,na,1,na);		/* stat stuff*/
	
	
	/* do the actual fitting*/
	
#if VERBOSE

	printf("going to start fitting now...\n");
	quit_dialogue();
	
#endif
	
	
	alamda = -1.0;
	if(print_flag > 5)  /* simulation mode, no varying parameters */
	  for(k=1;k<=na;k++) ia[k]=0;
	md_mrqmin(x,y,sig,npts,a,ia,na,
		  covar,alpha,&chisq,fit_funct,&alamda);  /* first call to mrqmin*/
	k = 1;
	itst = 0;
	
	for (;;) {	
	
	/* printouts to be done elsewhere*/
	
		if(print_flag > 1)
			inter_print( k, na, chisq, alamda, a);	
			
		if(print_flag > 5){ /* this is non-fit mode, just make the output files*/
			final_fit( npts, na, mfit, a, x, y, sig, fit_funct, 
				   plotfile, mtvfile, print_flag, printinfo );
			break;
		}
			
		k++; 
		ochisq = chisq;
		md_mrqmin(x,y,sig,npts,a,ia,na,covar,
			  alpha,&chisq,fit_funct,&alamda); /* iterative calls*/
		 /* these are tests to see if we continue..*/
		if (k <= MAX_INT) { /* 1) Not at Max interations */
		 
		  if (chisq > ochisq)  itst=0;	/* 2) Continue if chisq has increased*/	
		  else if (fabs(ochisq-chisq) < 0.1)  itst++;  /* start counting */
			                        /* 3) continue if the change has been*/
		                                /*    small less than four times... */
		  if (itst < 4) continue; 
		}
		
		/*else: last call:*/
		
#if VERBOSE
		
		printf("made it to the last call\n");
		quit_dialogue();
#endif
		
		alamda = 0.0; /* for no refinement*/
		md_mrqmin(x,y,sig,npts,a,ia,na,covar,
			  alpha,&chisq,fit_funct,&alamda); /* final call */
		
			final_print( k, na, chisq, alamda, a, ia, covar, print_flag);
#if VERBOSE
		printf("alive and happy before\n");
#endif
		
		final_fit( npts, na, mfit, a, x, y, sig, fit_funct, 
			   plotfile, mtvfile, print_flag, printinfo); 
			   
		break;
	}
		/* write updated ctl file */
	newctlfile = csvector(0,(len-1));
	for(i=0;i<(len-4);i++) newctlfile[i] = fnames[i];
	strcat(newctlfile,  ncl);
	printf("writing updated control file to %s\n", newctlfile); 
	write_input_file(nind, na, 5, npts, a, ia, newctlfile);

	/* free everything left... */
	
	free_csvector(plotfile,0,(len-1));
	free_csvector(fitfile,0,(len-1));
	free_csvector(mtvfile,0,(len-1));
	free_csvector(newctlfile,0,(len-1));

	free_ivector(ia,1,na);
	free_ivector(Fwa,1,na);

	free_vector(sig,1,npts);
	free_vector(y,1,npts);

	free_matrix(x,1, nind, 1, npts);
	free_matrix(alpha,1,na,1,na);
	free_matrix(covar,1,na,1,na);
	return(1);
}
#undef NRANSI
