#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../headers/leastsq.h"
#include "../../utilities/headers/gbmv_util.h"

#define NRANSI1
#include "../../utilities/headers/nrutil.h"

/* this is main for the vesion which makes 3-col out of two col... */

int main( int argc, char **argv )
{
  struct MTVINFO printinfo = {
    "Your Data",
    "x",
    "y"
  };

  const char p_on[] = "MARQ_PROMPT=on";
  const char p_off[] = "MARQ_PROMPT=off";
  
  char inp_string[132], *datafile, *ctlfile, *inpfile, fnames[132], *c;
  short i, flag, len, p = -999;
  unsigned long ndata;
  float r1, r2;
  /* file extensions*/
	
  const char dat[] = ".dat";	/* double quotes NULL terminate*/
  const char plt[] = ".plt";
  const char bkg[] = ".bkg";
  const char ctl[] = ".ctl";
  const char mtv[] = ".mtv";
  const char inp[] = ".inp";
         
	
/* char strings for yorn_dialogue*/

  const char nada[] = "";
  const char datapts[] = "Do you want to see all of the data points read in?";

  putenv("COLUMNS=132");
  /* default range */
  
  if(argc == 5) { /* range has been entered */
    /* range must be last two, cheezy I know but it's a bricolage */
    if(!is_a_float(argv[3] , &r1)){
      printf("bad range\n");
      exit(-1);
    } 
    if(!is_a_float(argv[4] , &r2)){
      printf("bad range\n");
      exit(-1);
    } 
    argc = 3;
  } else {
    r1 = -999999.; 
    r2 = 999999.;
  }
  /* Read in file names, assign output file names*/
  /* check if already on command line */
  flag = 0; /* flag to see if name is already read in */
  for(i=1; i<argc ; i++ ) {
    switch(argv[i][0])
      {
      case '+':
	/* go to prompted input */
	if(!putenv(p_on)) printf("prompt on\n");
	else printf("unable to joggle prompt\n");
	/* putenv returns zero if it worked */
 
	
	break;

      case '-':
	/* go to unprompted input */
	if(!putenv(p_off)) printf("prompt off\n");
	else printf("unable to joggle prompt\n");
	/* putenv returns zero if it worked */
	break ;
      default :
	/* hopefully is fname */
	if(flag){ /* already read in fname */
	  printf(" ambiguous command line\n");
	  printf(" enter +/- to turn on/off prompting and/or filename\n");
	}
	strcpy(fnames, argv[i] );
	while(!is_a_unix_fname(fnames)) {
	  printf("%s is not an acceptable unix filemame morsel\n", fnames);
	  if(!yorn_dialogue("do you want to enter another?")) 
	    exit(1) ;
	  printf("please input file name (extentions .dat, .ctl assumed)\n");
	  scanf("%s", fnames);
	}
	flag = 1;
	break ;
      }
  }

 


  if( !flag ) { /** fname not entered */
    /** get from prompted input **/
    printf("please input file names (extentions .dat, .ctl assumed)\n");
    scanf("%s",fnames);
    while(!is_a_unix_fname(fnames)) {
      printf("%s is not an acceptable unix filemame morsel\n", fnames);
      if(!yorn_dialogue("do you want to enter another?")) 
	exit(1) ;
      printf("please input file name (extentions .dat, .ctl assumed)\n");
      scanf("%s", fnames);
    }
  }
  
  len = strlen(fnames); /* this gives the length without the "\0"*/
  
  /* so to add .xxx, must allocate five bits, not four*/
  
  len += 5;
  
  /* create file names*/
  
  datafile = csvector(0,(len-1));		/* data file*/
  ctlfile = csvector(0,(len-1));		/* control file*/
  inpfile = csvector(0,(len-1));                /* 2 col input file */
  
  for(i=0; i<(len-4); i++)
    datafile[i] = ctlfile[i] = inpfile[i] = fnames[i];
  
  strcat(datafile,dat); /* strcat automatically null terminates catenation*/
  strcat(ctlfile, ctl);
  strcat(inpfile,inp);

          /* determine prompting condition */

  if((c = getenv("MARQ_PROMPT")) == NULL) {
    printf("cannot access environment variable MARQ_PROMPT\n");
    printf("default to prompted input\n");
    if(!putenv(p_on)) {
      c = getenv("MARQ_PROMPT");
      printf("prompt %s\n",c);
    } else  {
      printf("unable to joggle prompt\n"); 
      quit_dialogue();
    }    
  }
  if (strcmp(c,"on") == 0){/* strcmp returns zero if exact */
    printf(" enter range (low, high) [full] ");
    if(!(getline(inp_string, 132))) {
      r1 = -999999.; 
      r2 = 999999.;
    } else {
      while(sscanf(inp_string,"%f%*[ \t , ]%f", &r1, &r2) != 2) {
	printf("bad input : not enough values or bad separation\n");
	if(yorn_dialogue("try again?"))
	  getline(inp_string, 132);
	else
	  exit(-1);
      }
    }
    p=1; 
  } else {
    if (strcmp(c,"off")==0) p=0;
    else
      printf("no match c = %s\n",c);
  } 
/*  printf(" got mp == %s, now p = %d\n", c, p); */
/*  quit_dialogue(); */

              /* make data file */
              /* -999 since we dont know if data are rising or falling */
  ndata = grab_vanilla_scan(inpfile, datafile,r1,r2,-999);
  free_csvector(inpfile, 0, (len-1));
  
          /* make control file */

  if(!term_input(p, datafile, ctlfile, ndata)){
    printf("terminal input didn't work correctly\n");
    exit(1);
  }
  free_csvector(ctlfile, 0, (len-1));
  free_csvector(datafile, 0, (len-1));
  
  /** call refinement program **/
  if(!lsq_driver(fnames, printinfo)) 
    printf("didn't work, dunno why...\n");
  printf("done\n");

  return(1);
}
