#! /usr/local/bin/tcsh -f

if( $# != 5  && $# != 3 && $# != 2 && $# != 6 ) then
	echo "usage" $0 " first_file last_file (nth_file) (low high) (1=add pos) "
	exit
endif

if ( -e fits ) mv fits fits.old
echo removing old mtv files
#rm -f *.mtv 
echo removing old ncl files
rm -f *.ncl


set val=$1
set next_val=$1

touch fits

if ($# < 3 ) then
    set nth=1
else
    set nth=$3
endif

if ($# < 5 ) then
    set low=-999
    set high=999
else
    set low=$4
    set high=$5
endif

echo 

while( $val <= $2 )

	if( $val != $next_val) then
		@ val ++
		continue
	else
		set next_val=`expr $val + $nth`
	endif
# give the scan number
	echo $val "\c"  >> fits
	if (!(-e $val'.inp')) then
	    echo $val'.inp' "does not exist"
	    @ val ++
	    continue
	endif

	if ( $VENDOR == intel || $VENDOR == suse) then
	    ~vaughan/bin/amarqmake $val - $low $high > /dev/null
	else
	    ~vaughan/bin/marqmake $val - $low $high  > /dev/null
	endif

	if ( $# > 5 && $6 == 1) then
	    if ( $VENDOR == intel || $VENDOR == suse) then
		add_pos2k $val
	    endif
	endif
	echo "treating scan   $val \r\c"
	@ val ++
end
echo "\007"

mv fits $1'_'$2'.fits'
if ( $# > 5 && $6 == 1) then
    mv zfits $1'_'$2'.zfits'
endif

if ( $VENDOR == intel || $VENDOR == suse) then
    axmgr -xydy  $1'_'$2'.fits' -param ~vaughan/bin/point.par >&/dev/null&
else
    xmgr -xydy  $1'_'$2'.fits'  -param ~vaughan/bin/point.par >&/dev/null&
endif
