/*********************************************************************

 File:		VpapP.c

 Project:	Device Servers

 Description:	private include file for the class of Vpap
                steppermotor controllers

 Author(s);	Timo Mettala

 Original:	January  1992

 Copyright (c) 1992 by European Synchrotron Radiation Facility,
                      Grenoble, France

	       All Rights Reversed

 *********************************************************************/

#ifndef _VpapP_h
#define _VpapP_h

/*
	as a subclass of the stepperMotorClass, include StepperMotorClass private
	definitions
*/

#include <StepperMotorP.h>

typedef struct _VpapPart {
	short           unitnum;
	int             filepath;
	short           channum;
	long            homeslewrate;
	long            last_cmd;
	long            blcorr;
	short           homeswitchpol;
	long            newpos;
	long            posoffset;
	time_t          starttime;
        char            *powerdriver;
	long            backlash;
	long            type;
	time_t          bltime;
	long		oscill;
}       VpapPart;

typedef struct _VpapClassRec {
	DevServerClassPart devserver_class;
}       VpapClassRec;

extern VpapClassRec vpapClassRec;

typedef struct _VpapRec {
	DevServerPart   devserver;
	StepperMotorPart steppermotor;
	VpapPart        vpap;
}       VpapRec;

#endif	/* _VpapP_h */


