/*static char RcsId[] = "$Header: SerialLineP.h,v 1.3 97/01/10 10:01:18 goetz Rel $";*/

/*********************************************************************
 *
 * File:	SerialLineP.h
 *
 * Project:	Serial Line
 *
 * Description:	This class is a general purpose serial line class. It
 *		provides low level and high level functionality for
 *		clients wanting to talk to devices connected by a
 *		serial line.
 *		
 *
 * Author(s):	Andy Gotz
 *
 * Original:	December 1993	
 *
 * $Log:	SerialLineP.h,v $
 * Revision 1.3  97/01/10  10:01:18  10:01:18  goetz (Andy Goetz)
 * moved buffer[] to static global area to save stack space
 * 
 * Revision 1.2  97/01/10  08:37:28  08:37:28  goetz (Andy Goetz)
 * cleaning up
 * 
 * Revision 1.1  93/12/10  14:26:32  14:26:32  goetz (Andy Goetz)
 * Initial revision
 * 
 * 
 *
 * Copyright (c) 1993 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Dec 10 14:25:44 1993).
 *
 *********************************************************************/

#ifndef _SERIALLINEP_H
#define _SERIALLINEP_H



typedef struct _SerialLineClassPart
{
		int	nada;
}	SerialLineClassPart;



typedef struct _SerialLinePart
{
		char	*serialline; /* serial line device descriptor */
		int	serialin; /* serial line file descriptor used for
				input */
		int	serialout; /* serial line file descriptor for output */
		short	timeout; /* timeout in milliseconds */
		short	parity; /* parity */
		short	charlength; /* character size */
		short	stopbits; /* number of stop bits */
		short	baudrate; /* baud rate */
		short	newline; /* new line character */
		short	xon; /* output resume character */
		short	xoff; /* output suspend character */
		short	upper; /* upper case only flag */
		short	erase; /* erase on backspace flag */
		short	echo; /* input characters echoed flag */
		short	linefeed; /* automatic linefeed flag */
		short	null; /* set null character count */
		short	backspace; /* backspace character */
		short	delete; /* delete character */
}	SerialLinePart;



typedef struct _SerialLineClassRec
{
		DevServerClassPart	devserver_class;
		SerialLineClassPart	serialline_class;
}	SerialLineClassRec;



extern SerialLineClassRec serialLineClassRec;


typedef struct _SerialLineRec
{
		DevServerPart 	devserver;
		SerialLinePart 	serialline;
}	SerialLineRec;



#endif /*_SERIALLINEP_H*/

