/*+*******************************************************************

 File:		RelayP.h

 Project:	Device Servers for Personnel Safety System relays

 Description:	Private include file for the Relay Class

 Author(s):	Petri Makijarvi

 Original:	September 1991

 Copyright (c) 1991 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/
 /*
  $Log:	RelayP.h,v $
  Revision 3.3  95/09/04  16:24:02  16:24:02  petri (Petri Makijarvi)
  Ultra-C'fied
  
  Revision 3.2  94/04/11  17:16:57  17:16:57  epaud
  no modifs
  
  Revision 3.1  93/02/02  12:30:59  12:30:59  petri (Petri Makijarvi)
  Migrating fro mars to libra
  
  Revision 3.0  92/03/31  15:29:58  15:29:58  meyer (Jens Meyer)
  New major library release (3.x).
  
  Revision 2.1  92/02/20  10:49:57  10:49:57  petri ()
  Moved from the development
  
  Revision 1.5  92/02/20  10:46:27  10:46:27  petri ()
  Relay class contains now the service name
  
  Revision 1.4  91/12/10  18:58:08  18:58:08  petri ()
  Added CardNumber, tested with AlarmRelay class
  
  Revision 1.3  91/10/09  17:03:00  17:03:00  petri ()
  Removed the ICV196 bit direction definitions: Fixed directions used.
  
  Revision 1.2  91/10/09  13:09:17  13:09:17  petri ()
  Heading to add changes from DSUG.037.2
  
  Revision 1.1  91/09/03  11:31:07  11:31:07  petri ()
  Initial revision
  */
 
#ifndef _RelayP_h
#define _RelayP_h

/*
  Definition of the Digital I/O Unit Types enumerated
 */
#define RE_IOTYPE_UNKNOWN    0
#define RE_IOTYPE_DIGI200    1
#define RE_IOTYPE_ICV196     2

/*
  Definition of the BitLogic enumerated for Exclusive OR operation
  with the Position when writing or reading the digital I/O device.
 */
#define RE_BITLOGIC_POSITIVE 0
#define RE_BITLOGIC_NEGATIVE 1
#define RE_BITLOGIC_UNKNOWN  2


/*
  Definition of the Digital I/O Direction enumerated
 */
#define RE_IODIR_UNKNOWN     0
#define RE_IODIR_INPUT       1
#define RE_IODIR_OUTPUT      2

/*
  Definition of the Relay Class Part structure
 */
typedef struct _RelayClassPart
               {
                 char    *local_svc_name;  /* Name of the service */
               }
               RelayClassPart;

/*
  Definition of the Relay Object Part structure
 */
typedef struct _RelayPart
               {
		 int   UnitType;         /* Digital I/O unit type */
		 int   UnitNumber;       /* Digital I/O unit path number */
		 int   CardNumber;       /* Digital I/O unit card number */
		 int   BitPosition;      /* I/O number to use */
		 int   BitLogic;         /* Bit-Logic to use */
                 int   Direction;        /* Input or Output */
                 int   Position;         /* Last known position of Relay */
               }
                RelayPart;

/*
  Definition of the Relay Class
 */
typedef struct _RelayClassRec
               { 
                 DevServerClassPart devserver_class;
		 RelayClassPart     relay_class;
               }
               RelayClassRec;

/*
  Introduction of the private Relay Class
 */
extern RelayClassRec relayClassRec;

/*
  Definition of the Relay Object
 */
typedef struct _RelayRec
               { 
                 DevServerPart devserver;
                 RelayPart     relay; 
               }
               RelayRec;

#endif /* _RelayP_h */

 /* end of $Source: /libra/users/d/dserver/classes/interlock/relay/include/RCS/RelayP.h,v $ */
