/*+*******************************************************************

 File:		PulsedRelayP.h

 Project:	Device Servers for Personnel Safety System relays

 Description:	Private include file for the PulsedRelay Class

 Author(s):	Petri Makijarvi

 Original:	September 1991

 Copyright (c) 1991 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/
 /*
  $Log:	PulsedRelayP.h,v $
   Revision 3.1  93/02/02  16:03:31  16:03:31  petri (Petri Makijarvi)
   Migrating from mars to libra
   
   Revision 3.0  92/03/31  15:30:05  15:30:05  meyer (Jens Meyer)
   New major library release (3.x).
   
   Revision 2.1  92/02/06  16:56:49  16:56:49  petri ()
   Ready for installation
   
   Revision 1.9  92/02/06  16:44:44  16:44:44  petri ()
   Moved from development
   
 * Revision 1.1  91/10/28  13:47:31  13:47:31  petri ()
 * Initial revision
 * 
  */
 
#ifndef _PulsedRelayP_h
#define _PulsedRelayP_h

#ifndef _RelayP_h
#include <RelayP.h>
#endif /* _RelayP_h */

/*
  Definition of the maximum number of Pulsed type of relays
  per PulsedRelay Device Server, defines the PulseTable size
 */
#define RE_MAX_PULSED 64

/*
  Definition of the OS-9 User's level signal number base used
  (to be added to PulseTable's object index)
 */
#define RE_SIG_BASE   300

/*
  Definition of the PulsedRelay Class Part structure
 */
typedef struct _PulsedRelayClassPart
               {
                 int nada;
               }
               PulsedRelayClassPart;

/*
  Definition of the PulsedRelay Object Part structure
 */
typedef struct _PulsedRelayPart
               {
		 int   RelayType;     /* Relay Type enumarated (Relay.h) */
		 int   RestPosition;  /* Initial/Rest position */
		 int   AlarmIndex;    /* Index number of pulsed object */
		 int   AlarmID;       /* OS-9 Alarm identification number */
               }
                PulsedRelayPart;

/*
  Definition of the PulsedRelay Class
 */
typedef struct _PulsedRelayClassRec
               { 
                 DevServerClassPart       devserver_class;
		 RelayClassPart           relay_class;
		 PulsedRelayClassPart     pulsedrelay_class;
               }
               PulsedRelayClassRec;

/*
  Introduction of the private PulsedRelay Class
 */
extern PulsedRelayClassRec pulsedRelayClassRec;

/*
  Definition of the PulsedRelay Object
 */
typedef struct _PulsedRelayRec
               { 
                 DevServerPart       devserver;
                 RelayRec           *relay;    /* ptr to Relay Object */
                 PulsedRelayPart     prelay;    
               }
               PulsedRelayRec;

#endif /* _PulsedRelayP_h */

 /* end of $Source: /users/d/dserver/classes/interlock/relay/pulsed/include/RCS/PulsedRelayP.h,v $ */
