/*+********************************************************************
 FILE:         MaxeP.h
 PROJECT:      Device Servers
 PURPOSE:      private include for the MaxeClass
 AUTHOR(s);    Timo Mettala
 ORIGINAL:     February 1992

Copyleft (c) 1991 by European Synchrotron Radiation Facility,
                      Grenoble, France


 ********************************************************************-*/

#ifndef _MAXEP_H
#define _MAXEP_H

#include <VpapaxeP.h>

/* defines Partial Class structure name */
typedef struct _MaxeClassPart
   {
   /* New fields that this subclass (MaxeClass) adds to its
      superclass(DserverClass) */
	char *local_svc_name;
   } MaxeClassPart;

/* defines Partial Device instance structure */
typedef struct _MaxePart 
   {
    /* New fields that this subclass instance (Maxe) adds to its
       superclass structure */
                int     number_of_motors;      
		Vpapaxe  axe_ptr[8];
   } MaxePart;

/* defines Complete class structure name */
typedef struct _MaxeClassRec
   {
   DevServerClassPart devserver_class;
   MaxeClassPart maxe_class;
   } MaxeClassRec;
   
 extern MaxeClassRec maxeClassRec;

/* defines Complete Device instance structure name */
typedef struct _MaxeRec
   {
   DevServerPart devserver;
   MaxePart maxe;
   } MaxeRec;

#endif /* _MAXEP_H */






