/*+********************************************************************

 File:		IcvAdcP.c

 Project:	Device Servers

 Description:	private include file for the class of icvAdc 

 Author(s);	Timo Mettala

 Original:	22nd July 1991


 Copyleft (c) 1991 by European Synchrotron Radiation Facility, 
                      Grenoble, France

	       All Rights Reversed

 *******************************************************************-**/

static char IcvAdcP[] ="$Header: IcvAdcP.h,v 3.16 94/10/25 10:24:02 mettala Exp $";

#ifndef _ICVADCP_h
#define _ICVADCP_h


/*
	as a subclass of the icvAdcClass, include IcvAdcClass private
	definitions
*/

/* Next definitions are anticipating the new release of ds-api library */
#ifndef DS_CAT_SHIFT
#define DS_CAT_SHIFT      12
#endif

#ifndef WarningError
#define WarningError      0x3f
#endif

#include <icv150.h>

typedef struct _IcvAdcPart
   {
        char *filename;
	int   filepath;
        int   maxhex;
        float minvalue;
        float maxvalue;   
	float chanminvalue[255];
	float chanmaxvalue[255];
	short channum;
	short scannum;
	short gain[255];
	short alarm[255];
	float lowalarm[255];
	float highalarm[255];
        short maxgain;
	char  *polarity;
	char  *mode;
   } IcvAdcPart;

typedef struct _IcvAdcClassRec
   {
   DevServerClassPart devserver_class;
   } IcvAdcClassRec;

extern IcvAdcClassRec icvAdcClassRec;

typedef struct _IcvAdcRec
   {
     DevServerPart    devserver;
     IcvAdcPart    icvAdc;
   } IcvAdcRec;

#endif /* _ICVADCP_h */





