/*static char RcsId[] = "$Header: SerialLine.h,v 1.4 97/01/10 10:01:34 goetz Rel $ ";*/
/*********************************************************************
 *
 * File:	SerialLine.h
 *
 * Project:	Serial Line
 *
 * Description:	This class is a general purpose serial line class. It
 *		provides low level and high level functionality for
 *		clients wanting to talk to devices connected by a
 *		serial line.
 *		
 *
 * Author(s):	Andy Gotz
 *
 * Original:	December 1993
 *
 * $Log:	SerialLine.h,v $
 * Revision 1.4  97/01/10  10:01:34  10:01:34  goetz (Andy Goetz)
 * moved buffer[] to static global area to save stack space
 * 
 * Revision 1.3  97/01/10  08:37:00  08:37:00  goetz (Andy Goetz)
 * cleaning up
 * 
 * Revision 1.2  94/01/05  09:36:35  09:36:35  goetz (Andy Goetz)
 * *** empty log message ***
 * 
 * Revision 1.1  93/12/10  14:26:36  14:26:36  goetz (Andy Goetz)
 * Initial revision
 * 
 *
 * Copyright(c) 1990 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Dec 10 14:25:44 1993).
 *
 *********************************************************************/

#ifndef _SERIALLINE_H
#define _SERIALLINE_H

#include <BlcDsNumbers.h>

/*
 * maximum string length supported to date
 */
#define SL_MAXSTRING 1024

/*
 * new commands
 */
#define DevSerWriteString DevSerBase+1
#define DevSerWriteChar DevSerBase+2
#define DevSerReadString DevSerBase+3
#define DevSerReadChar DevSerBase+4
#define DevSerSetParameter DevSerBase+5

/*
 * symbolic defines - used by server and client alike
 */
#define SL_RAW 0 /* raw read/write mode */
#define SL_NCHAR 1 /* character read/write mode */
#define SL_LINE 2 /* line read mode */

#define SL_NONE 0
#define SL_ODD 1
#define SL_EVEN 3

#define SL_DATA8 0
#define SL_DATA7 1
#define SL_DATA6 2
#define SL_DATA5 3

#define SL_STOP1 0
#define SL_STOP15 1
#define SL_STOP2 2

#define SL_TIMEOUT 3 /* timeout parameter */
#define SL_PARITY 4 /* number of parity bits parameter */
#define SL_CHARLENGTH 5 /* number of data bits parameter */
#define SL_STOPBITS 6 /* number of stop bits parameter */
#define SL_BAUDRATE 7 /* baud rate parameter */
#define SL_NEWLINE 8 /* new line character parameter */

typedef struct _SerialLineClassRec *SerialLineClass;
typedef struct _SerialLineRec *SerialLine;

extern SerialLineClass serialLineClass;
extern SerialLine serialLine;

#endif /*_SERIALLINE_H*/

