.ND "27 October, 1991"
.SA 1
.TL
Relay Device Server
.AF "pm/91 DSUG/037.5"
.AU "Petri MAKIJARVI"
.MT "USER'S GUIDE" "pm/91 DSUG/037.5"
.H 1 "Introduction"
A \fBRelay\fP is an electrical device that has a contactor or contactors
that can
be either OPEN (connectivity) or CLOSED (no connectivity). The definition in
parenthesis allows the device server to deal with the transistors, thyristors
and other semiconductor power devices.

The Relay is connected either to a VME digital I/O unit or to a G64 digital
I/O unit (card).

The Relay can be either OUTPUT type or INPUT type. The state of an OUTPUT
type of Relay can be changed. The state of an INPUT and OUTPUT types of
Relay can be read.
.H 1 "Description"

The Relay Device Server contains the basic operations of all Relay
sub-classes. Since the operations are simple, more devices can be
easily added to this Class.

The Relay Device Server access the Relay using a specific digital I/O
unit that it has to recognize. The digital I/O unit type is defined
in the resource file of the server. Currently, following digital I/O
units are supported:
.H 2 "Digital I/O units"
   Type/Name  OS-9 Device Driver
   =========  ==================
   DIGI-20x   digi200             64 Inputs, 32 Outputs
   ICV196     icv196              I/O 0..63 as Inputs,
                                  I/O 64..95 as Outputs
.H 1 "Class Name"
The name of the Relay class is "\fBRelayClass\fP".
.H 2 "Device Names"
.H 3 "Personnel Safety System"
The Relay Device names used in the Personnel Safety System are
\fBELIN/S-REL/1\fP to \fBELIN/S-REL/n\fP, where \fBn\fP is the number
of Relay Devices connected to one Digital I/O unit.
.H 1 "Startup"
If the Digital I/O unit used to acces the relays is located in the
VME crate the OS-9 Device Driver and the Device Descriptor
of the Digital I/O unit must have been loaded into the memory before
starting the Relay Device Server.
.P
At the startup the Digital I/O device is opened and the state of the INPUT
type of relays is read. Following chapter explains the initialization
of the OUTPUT type relays.
.H 2 "Initial state of OUTPUT type Relays"
The initial position of Relay contacts is depends of following three
initialization events:
.AL a 10
.LI
Hardware Initialization of the digital I/O unit. The "Reset"-signal on the
VME-bus usually sets the outputs of the digital I/O unit to a state
determined by the manufacturer. This may not be the case for eventual
G64 digital I/O units connected to the VME using the FieldBus.
.LI
If the digital I/O unit is supported by an OS-9 device driver, the
device driver will set the outputs according the initialization
values defined in the device descriptor of the device (by default these
values are the same as output values after the hardware reset).
When the digital I/O device is \fBopened\fP or
\fBinitialized\fP for the first time the device driver writes the
output initialization values to the device.

If modifications to the relay states after a reset is requested
then the initialization of the digital I/O device should be done already
at the startup of the VME crate. See corresponding Device Driver User's Guide
for further details.
.LI
If the digital I/O device is not initialized in the startup of the VME
crate then the first Relay object created on the digital I/O unit will
initialize \fBall\fP the outputs on that card to predefined states, as
explained above. When a Relay object is initialized the OUTPUT type of
Relay is set to the initial position defined in the data base.
.LE
.H 1 "Database support"
The Relay Device Server makes use of the static data base by retrieving
certain initial values from the data base, allowing the configuration
of each Relay Device created upon the Relay Device Server startup.
.H 1 "Relay resource file"
The configuration of a Relay is done by selecting from following options
in the Relay server's resource file: 
.VL 20
.LI \fBDeviceTitle\fP
Relay does not use the title string but it is suggested to write
here a meaningful string for the application programs using the Relay server.
.LI \fBRelayType\fP
Reserved use for applications using different relay servers. For
Relay server, string "RELAY" is mandatory.
.LI \fBBitPosition\fP
The Bit position in the I/O unit to use.
.VL 10
.LI \fBdigi200\fP
OUTPUT range is 0..31. INPUT range is 0..63. Interruptable INPUT range
is 0..7.
.LI \fBicv196\fP
In the Relay Server, the icv196's OUTPUT range is 64..95 (I/O lines 64..95).
INPUT range is 0..63 (I/O lines 0..63). Interruptable INPUT range is
is 0..15.
.LE
.LI \fBBitLogic\fP
Definition of the wiring logic between the Relay unit and the digital
I/O unit.
.VL 10
.LI \fBPOSITIVE\fP
When the TTL level of the I/O unit is \fB0\fP the Relay is OPEN.
When the TTL level of the I/O unit is \fB1\fP the Relay is CLOSED.
.LI \fBNEGATIVE\fP
When the TTL level of the I/O unit is \fB1\fP the Relay is OPEN.
When the TTL level of the I/O unit is \fB0\fP the Relay is CLOSED.
.LE
.LI \fBDirection\fP
.VL 10
.LI \fBINPUT\fP
The relay contacts are connected to an input line of the digital I/O unit.
.LI \fBOUTPUT\fP
The relay activation (solenoid, transistor, etc) is connected to an output
line of the digital I/O unit.
.LE
.LI \fBInitPosition\fP
If the Relay Direction is \fBOUTPUT\fP then the initial position of
it must be defined either OPEN or CLOSED. For INPUT type of Relay the
resource has no meaning.
.LE
All the Relays served by a Device Server must be connected to the same
Digital I/O unit. In the resource file the Digital I/O unit is defined
under the label \fBCLASS/RelayServer/xxx/yyy\fP where \fBxxx\fP is the
name of the service given when in the Relay server command line and
\fByyy\fP is the resource name as follows:
.VL 20
.LI \fBUnitType\fP
"digi200" or "icv196". The Digital I/O Unit type to use is the default value
for the Relay Devices. It can not be changed within a server,
i.e. all the Relay Devices within a Relay Server must use the same type of
Digital I/O Unit.
.LI \fBUnitNumber\fP
I/O Unit's number in the crate. Range 1..4. The Digital I/O Unit number to
use is the default value for the Relay Devices. It can not be changed within a
server, i.e. all the Relay Devices within a Relay Server must use the same
Digital I/O Unit.
.LE
.H 1 "State Machine"
A Relay can have three states:
.P
.B "DEVFAULT"
.P
No other commands than DevState are served in this state which indicates that
the Relay Device Server has failed to acces the Relay.
.P
.B "DEVOPEN and DEVCLOSE"
.P
The Relay is operational. All commands are allowed but the State Handler
will return an error if a command \fBDevOpen\fP or \fBDevClose\fP are
used on a Relay that is of INPUT type.
.H 1 "Commands"
The user of the Relay Device Server should use the following header files
to easily use the return arguments of the Relay Device Server:

       #include <DevServer.h>
       #include <DevServerXdr.h>
       #include <Relay.h>

In this document, macros defined in the header files mentioned above are
above are used to determine the status and other similar information.
.BL
.LI \fIDevReadValue\fP
.VL 10
.LI \fBaction\fP
Reads the position of an INPUT Relay contacts. In case of an OUTPUT Relay
reads the state of the device.
.LI \fBargin\fP
D_VOID_TYPE (null)
.LI \fBargout\fP
D_LONG_TYPE (DevLong)
.P
.VL 10
.LI \fBDEVFAULT\fP
The device can not be reached.
.LI \fBDEVOPEN\fP
The contactors of the Relay are open.
.LI \fBDEVCLOSE\fP
The contactors of the Relay are closed.
.LE
.LI \fIDevOpen\fP
.VL 10
.LI \fBaction\fP
Opens the contactors, or makes unconductive an OUTPUT type of Relay.
.LI \fBargin\fP
D_VOID_TYPE (null)
.LI \fBargout\fP
D_VOID_TYPE (null)
.LE
.LI \fIDevClose\fP
.VL 10
.LI \fBaction\fP
Closes the contactors, or makes conductive an OUTPUT type of Relay.
.LI \fBargin\fP
D_VOID_TYPE (null)
.LI \fBargout\fP
D_VOID_TYPE (null)
.LE
.LI \fIDevState\fP
.VL 10
.LI \fBaction\fP
Returns the Relay Device Server's state. See "State Machine" for
possible states.
.LI \fBargin\fP
NULL
.LI \fBargout\fP
D_SHORT_TYPE (DevShort)
.LI \fBerrors\fP
none
.LE
.LE
.H 1 "Known Defects"
Since Relay device server is developed for the OS-9 the maximum available
number of open paths in the OS-9 has caused a limitation to the Relay Devices
configuration. Each Relay Device served by the Relay Device Server must
be connected to the same Digital I/O Unit although the Device Server principle
would allow one server to serve all the relays connected to a VME crate.
.H 1 "Example Client Program"
An example of a Relay Device Server client can be found from the
directory:

  mars:/users/a/dserver/dev/interlock/relay/src/pssrelay.c

The program, which use HP-UX or OS-9 Curses is a general purpose Relay
Client that allows to sample and modify the states of relays served
by a Relay Device Server.
.H 1 "Conclusion"
The Relay Device Server allows an easy, configurable acces to slow-speed
electro-magnetic switching devices that are connected to an digital I/O
unit of the type known to the server.
.H 1 "See also"
\fBDevice Server User's Guide, , Pulsed  Relay Device Server User's Guide,
Alarm Relay Device Server User's Guide\fP

