.ND "28 October, 1991"
.SA 1
.TL
Pulsed Relay Device Server
.AF "pm/91 DSUG/042.2"
.AU "Petri MAKIJARVI"
.MT "USER'S GUIDE" "pm/91 DSUG/042.2"
.H 1 "Introduction"
A \fBPulsed Relay\fP is a subclass of the \fBRelay\fP class.
It inherits the commands of the Relay Device Server and provides user access
to them. Additionally it offers a command \fBDevReset\fP to momentarily open
or close the relay contacts.
.H 1 "Description"
Since Pulsed Relay inherits the I/O commands of the Relay Class, all the
limitations concerning the digital I/O units used apply to the Pulsed Relay
Class. 
.H 1 "Class Name"
The name of the Relay class is "\fBPulsedRelayClass\fP".
.H 2 "Device Names"
.H 3 "Personnel Safety System"
See Relay Class.
.H 1 "Startup"
See Relay Class.
.H 1 "Database support"
Again, the Pulsed Relay Device Server inherits the static data base
definitions from the Relay Device Server. Following resources have
special meaning in the Pulsed Relay Device Server:
.VL 20
.LI \fBRelayType\fP
Reserved use for applications using different relay servers. For
the Pulse Relay server, string "PULSED" is mandatory.
.LI \fBDirection\fP
Only "OUTPUT" type of relay is allowed.
.LI \fBInitPosition\fP
The initial position (OPEN or CLOSED) is also the rest position of the
relay. The opposite position is the pulsed position, i.e. that when the
relay contacts are in the opposite position of the initial position,
the PulsedRelay Device is in \fBDEVMOVING\fP-state.
.LE
.H 1 "State Machine"
A Pulsed Relay can have three states:
.P
.B "DEVFAULT"
.P
No other commands than DevState are served in this state which indicates that
the Relay Device Server has failed to access the Relay.
.B "DEVRUN"
.P
The PulsedRelay Device is operational. All the commands of the Relay
Device and \fBDevReset\fP-command are allowed.
.B "DEVMOVING"
.P
The PulsedRelay Device is active and only \fBDevReadValue\fP and
\fBDevState\fP-commands are allowed. It is not possible to force the
PulsedRelay Device to an other state when it is in this state.
.H 1 "Commands"
The user of the Pulsed Relay Device Server should use the following header
filesto easily use the return arguments of the Pulsed Relay Device Server:

       #include <DevServer.h>
       #include <DevServerXdr.h>
       #include <PulsedRelay.h>

In this document, macros defined in the header files mentioned above are
above are used to determine the status and other similar information.

.BL
.LI \fIDevReset\fP
.VL 10
.LI \fBaction\fP
Changes relay contact position momentarily to the opposite position from
the rest position (from the initial position). The command activates only
the action but returns immediately. The device is \fBbusy\fP while the
contacts are maintained in the active position.
.LI \fBargin\fP
D_LONG_TYPE (DevLong) Determines the required delay in 256ths of a second,
minimum value is 1, maximum value is 2147483647
(which equals to about three months...)
.LI \fBargout\fP
NULL
.LI \fBerrors\fP
Dev_ErrAttemptToViolateStateMachine occurs if the command is called before
previous command has returned the relay contacts to their rest position.
.LE
.LI \fIDevReadValue\fP
.VL 10
.LI \fBaction\fP
The position of the Relay Contacts can be read any time.
See Relay Device Server.
.LE
.LI \fIDevOpen\fP
.VL 10
.LI \fBaction\fP
Not available for the PulsedRelay Device. See Relay Device Server for action on
"RELAY" type of devices.
.LE
.LI \fIDevClose\fP
.VL 10
.LI \fBaction\fP
Not available for Pulsed Relay. See Relay Device Server for action on
"RELAY" type of devices.
.LE
.LI \fIDevState\fP
.VL 10
.LI \fBaction\fP
Returns the Pulsed Relay Device Server's state. See "State Machine" for
possible states. \fBNOTE\fP that the state returned for the Relay Devices
is different than for the PulsedRelay Devices.
.LI \fBargin\fP
NULL
.LI \fBargout\fP
D_SHORT_TYPE (DevShort)
.LI \fBerrors\fP
none
.LE
.LE
.H 1 "Known Defects"
If the user ask \fBvery\fP long delays that may be annoying since currently
the PulsedRelay Class does not contain a method to cancel the DEVMOVING
state, due to some timing problems with OS-9 alarms. Please be careful
when giving the delay values.

Inheritance means also that the (possible) defects of the Relay Class
are in the PulsedRelay Class, see the corresponding manual.
.H 1 "Example Client Program"
See Relay Class, same test program runs on PulsedRelay Class, too.
.H 1 "Conclusion"
The Pulsed Relay Device Server is an extension the Relay Device Server.
It should be used only if pulsed type of relays are in the configuration
since it makes the normal relay operations somewhat slower because the
Relay Class commands are called through the PulsedRelay Class.
.H 1 "See also"
\fBDevice Server User's Guide, Relay Device Server User's Guide, Alarm Relay
Device Server User's Guide.\fP

