/*static char RcsId[] = "$Header: startup.c,v 2.3 97/01/10 10:00:36 goetz Rel $";*/

/*********************************************************************
 *
 * File:	startup.c
 *
 * Project:	Serial Line
 *
 * Description:	Startup procedure for SerialLineClass. The
 *		startup procedure is the first procedure called
 *		from main() when the device server starts up.
 *		All toplevel devices to be created for the device 
 *		server should be done in startup(). The startup 
 *		should make use of the database to determine which 
 *		devices it should create. Initialisation of devices
 *		is normally done from startup().
 *
 * Author(s);	Andy Gotz 
 *
 * Original:	December 1993	
 *
 * $Log:	startup.c,v $
 * Revision 2.3  97/01/10  10:00:36  10:00:36  goetz (Andy Goetz)
 * moved buffer[] to static global area to save stack space
 * 
 * Revision 2.2  96/03/11  15:19:13  15:19:13  meyer (J.Meyer)
 * All C-files with the same version number.
 * 
 * Revision 2.0  95/11/10  18:14:44  18:14:44  beteva ()
 * recompiled with ucc
 * 
 * Revision 1.1  94/12/08  13:58:19  13:58:19  goetz (Andy Goetz)
 * Initial revision
 * 
 * 
 * 
 * Copyright (c) 1992 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Dec 10 14:26:07 1993).
 *
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>
#include <SerialLineP.h>
#include <SerialLine.h>


/************************************************************************

Function   :	long startup()

Description:	create, initialise and export all of the objects
		associated with this server

Arg(s) In  :	svc_name

Arg(s) Out :	error:      error return code

Return(s)  :	minus one on failure, zero otherwise

*************************************************************************/
long startup(svr_name, error)
char *svr_name;
long *error;
{

SerialLine	ds_list[512];
long		i,
		status,
		n_exported;
short		iret;
/*
 * pointer to list of devices returned by database.
 *
 */

 	char 		**dev_list;
   	unsigned int	n_devices;



   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
   	printf("startup(): db_getdevlist() failed, error %d\n",*error);
  	return(-1);
   }
   printf("following devices found in static database: \n\n");
   for (i=0;i<n_devices;i++)
   {
   	printf("\t%s\n",dev_list[i]);
   }




/*
 * create, initialise and export all devices served by this server
 *
 */
   
   for (i=0, n_exported = 0; i < n_devices; i++, n_exported++)
   {
   	printf("\t\tObject %s is\n",dev_list[i]);
   	fflush(stdout);

   	if (ds__create(dev_list[i], serialLineClass, &(ds_list[i]),error) != 0)
   	{
   		printf("create failed, ");
   		printf("%s", dev_error_str(*error));
		n_exported--;
   		continue;
   	}
   	else printf("\t\t- Created\n");

 		/* initialise the newly created serialLine */
  
   	if(ds__method_finder(ds_list[i],DevMethodInitialise)(ds_list[i],error)!= 0)
   	{
   		printf("initialise failed, ");
   		printf("%s", dev_error_str(*error));
   		continue;
   	}
   	else printf("\t\t- Initialised\n");

   	/*  now export it to the outside world */
 

   	if (ds__method_finder(ds_list[i],DevMethodDevExport)(dev_list[i],ds_list[i],error) != 0)
   	{
   		printf("export failed, ");
   		printf("%s", dev_error_str(*error));
   		continue;
   	}
   	else printf("\t\t- Exported\n\n");
   }

   switch(n_exported)
   {
   	case 0:	
   		printf("No devices exported - serialLine server exiting\n");
   		*error = 0;
   		iret = -1;
   		break;

   	case 1:	
   		printf("SerialLine server running with 1 device exported\n");
   		*error = 0;
   		iret = 0;
   		break;

   	default:
   		printf("SerialLine server running %d devices exported\n",
   								n_exported);
   		*error = 0;
   		iret = 0;
   }

return(iret);
}


