/*static char RcsId[] = "$Header: SerialLine_menu.c,v 2.3 97/01/10 10:01:17 goetz Rel $";*/

/*********************************************************************
 *
 * File:	SerialLine_menu.c
 *
 * Project:	Serial Line 
 *
 * Description:	An interactive main routine for test all the commands
 *		of the Device Server SerialLine.
 *
 * Author(s):	Andy Gotz 
 *
 * Original:	December 1993	
 *
 * $Log:	SerialLine_menu.c,v $
 * Revision 2.3  97/01/10  10:01:17  10:01:17  goetz (Andy Goetz)
 * moved buffer[] to static global area to save stack space
 * 
 * Revision 2.2  96/03/11  15:19:15  15:19:15  meyer (J.Meyer)
 * All C-files with the same version number.
 * 
 * Revision 2.0  95/11/10  18:15:12  18:15:12  beteva ()
 * recompiled with ucc
 * 
 * Revision 1.2  95/07/28  13:40:47  13:40:47  goetz (Andy Goetz)
 * checking in before I disappear into the African dust ...
 * 
 * Revision 1.1  94/12/08  13:58:32  13:58:32  goetz (Andy Goetz)
 * Initial revision
 * 
 *
 * Copyleft and Copyright (c) 1993 by European Synchrotron Radiation Facility, 
 *                                    Grenoble, France
 *
 * File Generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Dec 10 14:25:59 1993).
 *
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>

#include <SerialLine.h>

extern long debug_flag;

static long		readwrite = 0;
static char		cmd_string[80];
static char		string_buffer[1024];
static devserver 	ds;
static long 		error;
static int 		cmd;
static short		devstatus;

static DevShort		state_argout;
static DevString	status_argout;
static DevLong	 	readstring_argin;
static DevString 	readstring_argout;
static DevLong	 	readchar_argin;
static DevVarCharArray 	readchar_argout;
static DevString 	writestring_argin;
static DevLong		writestring_argout;
static DevVarCharArray 	writechar_argin;
static DevLong		writechar_argout;
static DevVarShortArray	setparameter_argin;

main(argc,argv)
unsigned 	int 	argc;
char 			**argv;
{
   static char write_string[1024];
   long charlength,stopbits,baudrate;
   short short_array[20];

   if (argc < 2)
   {
      printf("usage: %s device-name\n",argv[0]);
      exit(1);
   }

   devstatus = dev_import(argv[1],readwrite,&ds,&error);
   printf("\ndev_import(%s) returned %d\n\n",argv[1],devstatus);
   if(devstatus != 0)
   {
   	printf("Error message: %s\n",dev_error_str(error));
   	exit(1);
   }


   while (1)
   {
   	printf("\nSelect one of the following commands : \n\n");
   	printf("0.Quit \n\n");
   	printf("1.State \t");
   	printf("2.Status \n");
   	printf("3.ReadString  \t");
   	printf("4.ReadChar  \n");
   	printf("5.WriteString  \t");
   	printf("6.WriteChar  \n");
/*
 * 	printf("7.SetParameter\n");
 */
      	printf("cmd ? ");


/*
 * to get around the strange effects of scanf() wait for something read 
 *
 */
   
   	for( ; gets(cmd_string) == (char *)0 ; );
   	devstatus = sscanf(cmd_string,"%d",&cmd);

   	switch (cmd) 
      	{
   		case (0) : exit(1);
   		case (1) :
   		devstatus = dev_putget(ds, DevState,
   					NULL,
   					D_VOID_TYPE,
   					&state_argout,
   					D_SHORT_TYPE,
   					&error);
   		if(devstatus < 0)
		{
   			printf("\nDevState dev_putget() returned %d\n",devstatus);
   			printf("Error message: %s\n", dev_error_str(error));
		}
		else
		{
   			printf("state is %d\n", state_argout);
		}
   		break;

   		case (2) :
   		devstatus = dev_putget(ds, DevStatus,
   					NULL,
   					D_VOID_TYPE,
   					&status_argout,
   					D_STRING_TYPE,
   					&error);
   		if(devstatus < 0)
		{
   			printf("\nDevStatus dev_putget() returned %d\n",devstatus);
   			printf("Error message: %s\n", dev_error_str(error));
		}
		else
		{
   			printf("%s\n", status_argout);
		}

   		break;

   		case (3) : 
		readstring_argin = SL_RAW;
		readstring_argout = string_buffer;
   		devstatus = dev_putget(ds, DevSerReadString,
   					&readstring_argin,
   					D_LONG_TYPE,
   					&readstring_argout,
   					D_STRING_TYPE,
   					&error);
   		if(devstatus < 0)
		{
   			printf("\nDevSerReadString dev_putget() returned %d\n",devstatus);
   			printf("Error message: %s\n", dev_error_str(error)); 
		}
		else
		{
   			printf("\n%s\n",readstring_argout);
			free(readstring_argout);
		}
   		break;


/*
 * not used at present, can be reactivated to test the
 * command read n characters as a string
 *
   		case (4) : 
		printf("string length ? ");
   		for( ; gets(cmd_string) == (char *)0 ; );
   		devstatus = sscanf(cmd_string,"%d",&readnstring_argin);

   		devstatus = dev_putget(ds, DevSerReadNString,
   					&readnstring_argin,
   					D_LONG_TYPE,
   					&readnstring_argout,
   					D_STRING_TYPE,
   					&error);
   		if(devstatus < 0)
		{
   			printf("\nDevSerReadNString dev_putget() returned %d\n",devstatus);
   			printf("Error message: %s\n", dev_error_str(error)); 
		}
		else
		{
   			printf("\n%s\n",readnstring_argout);
			free(readnstring_argout);
		}

   		break;
 */


   		case (4) : 
                readchar_argin = SL_RAW;
		readchar_argout.length = 0;
		readchar_argout.sequence = 0;
   		devstatus = dev_putget(ds, DevSerReadChar,
   					&readchar_argin,
   					D_LONG_TYPE,
   					&readchar_argout,
   					D_VAR_CHARARR,
   					&error);
                if(devstatus < 0)
                {
                        printf("\nDevSerReadChar dev_putget() returned %d\n",devstatus);
                        printf("Error message: %s\n", dev_error_str(error));
                }
                else
                {
			if (readchar_argout.length > 0)
			{
                        	printf("\n%s\n",readchar_argout.sequence);
                        	free(readchar_argout.sequence);
			}
                }

   		break;


   		case (5) : 
                printf("string ? ");
                for( ; gets(cmd_string) == (char *)0 ; );
                devstatus = sscanf(cmd_string,"%s",write_string);

                writestring_argin = write_string;
   		devstatus = dev_putget(ds, DevSerWriteString,
   					&writestring_argin,
   					D_STRING_TYPE,
   					&writestring_argout,
   					D_LONG_TYPE,
   					&error);
                if(devstatus < 0)
                {
                        printf("\nDevSerWriteString dev_putget() returned %d\n",devstatus);
                        printf("Error message: %s\n", dev_error_str(error));
                }
                else
                {
                        printf("\n%d\n",writestring_argout);
                }

   		break;

                case (6) :
                printf("string ? ");
                for( ; gets(cmd_string) == (char *)0 ; );
                devstatus = sscanf(cmd_string,"%s",write_string);

                writechar_argin.length = strlen(write_string);
                writechar_argin.sequence = write_string;
                devstatus = dev_putget(ds, DevSerWriteChar,
                                        &writechar_argin,
                                        D_VAR_CHARARR,
                                        &writechar_argout,
                                        D_LONG_TYPE,
                                        &error);
                if(devstatus < 0)
                {
                        printf("\nDevSerWriteChar dev_putget() returned %d\n",devstatus);
                        printf("Error message: %s\n", dev_error_str(error));
                }
                else
                {
                        printf("\n%d\n",writestring_argout);
                }

                break;

/*
 * not implemented for the moment
 *
   		case (7) : 
 		printf("char length ? ");
   		for( ; gets(cmd_string) == (char *)0 ; );
   		devstatus = sscanf(cmd_string,"%d",&charlength);
                short_array[0] = SL_CHARLENGTH;
                short_array[1] = charlength;
		

   		devstatus = dev_putget(ds, DevSerSetParameter,
   					&setparameter_argin,
   					D_VAR_SHORTARR,
   					NULL,
   					D_VOID_TYPE,
   					&error);
   		printf("\nDevSetParameter dev_putget() returned %d\n ",devstatus);
   		if(devstatus < 0)
   			printf("Error message: %s\n", dev_error_str(error)); 

   		break;
 */

   		default : break;
      }
   }
}
