static char RcsId[] = "$Header: SerialLine.c,v 2.3 97/01/10 10:01:14 goetz Rel $";
/*********************************************************************
 *
 *File:		SerialLine.c
 *
 *Project:	Serial Line
 *
 *Description:	This class is a general purpose serial line class. It
 *		provides low level and high level functionality for
 *		clients wanting to talk to devices connected by a
 *		serial line.
 *		
 *
 *Author(s):	Andy Gotz
 *
 *Original:	December 1993
 *
 *$Log:	SerialLine.c,v $
 * Revision 2.3  97/01/10  10:01:14  10:01:14  goetz (Andy Goetz)
 * moved buffer[] to static global area to save stack space
 * 
 * Revision 2.2  96/03/11  15:19:14  15:19:14  meyer (J.Meyer)
 * All C-files with the same version number.
 * 
 * Revision 2.1  96/03/11  15:17:10  15:17:10  meyer (Jens Meyer)
 * Changed RCS header.
 * 
 * Revision 2.0  95/11/10  18:14:44  18:14:44  beteva ()
 * recompiled with ucc
 * 
 * Revision 1.7  95/07/28  13:41:21  13:41:21  goetz (Andy Goetz)
 * checking in before I disappear into the African dust ...
 * 
 * Revision 1.6  94/12/08  13:57:10  13:57:10  goetz (Andy Goetz)
 * fixed bug in ncharreadchar() with printf format; all printing is now
 * only done when the variable SL_DEBUG is defined.
 * 
 * Revision 1.5  94/02/25  18:30:45  18:30:45  goetz (Andy Goetz)
 * implemented dev_reset() command, but not tested
 * 
 * Revision 1.4  94/02/25  15:47:27  15:47:27  goetz (Andy Goetz)
 * first released version, checking in before adding dev_reset()
 * 
 * Revision 1.3  94/01/05  13:37:40  13:37:40  goetz (Andy Goetz)
 * going to undertake major changes which will incorporate the preferences
 * expressed by jorg
 * 
 * Revision 1.2  93/12/10  16:28:00  16:28:00  goetz (Andy Goetz)
 * *** empty log message ***
 * 
 * Revision 1.1  93/12/10  14:28:50  14:28:50  goetz (Andy Goetz)
 * Initial revision
 * 
 *
 *Copyright(c) 1993 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Dec 10 14:25:56 1993)
 *
 *********************************************************************/

/*#include <types.h>*/
#include <errno.h>
#include <sgstat.h>
#include <scf.h>
#include <modes.h>

#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Admin.h>

#include <DevServerP.h>
#include <SerialLineP.h>
#include <SerialLine.h>

/*
 * public methods
 */

static	long	class_initialise();
static	long	object_create();
static	long	object_initialise();
static	long	state_handler();

static	DevMethodListEntry methods_list[] = {
   	{DevMethodClassInitialise,	class_initialise},
   	{DevMethodInitialise,		object_initialise},
  	{DevMethodCreate,		object_create},
   	{DevMethodStateHandler,		state_handler},
   };


SerialLineClassRec serialLineClassRec = {
   /* n_methods */        sizeof(methods_list)/sizeof(DevMethodListEntry),
   /* methods_list */     methods_list,
   };

SerialLineClass serialLineClass = (SerialLineClass)&serialLineClassRec;

/*
 * public commands
 */

static	long	dev_serwritestring();
static	long	dev_serwritechar();
static	long	dev_serreadstring();
static	long	dev_serreadchar();
static	long	dev_sersetparameter();
static	long	dev_reset();
static	long	dev_status();
static  long    dev_state();

/*
 * local functions
 */
static	long	dev_rawreadstring();
static	long	dev_rawreadnchar();
static	long	dev_rawreadchar();
static	long	dev_ncharreadstring();
static	long	dev_ncharreadnchar();
static  long    dev_ncharreadchar();
static	long	dev_linereadstring();
static	long	dev_linereadnchar();
static	long	dev_linereadchar();

static	DevCommandListEntry commands_list[] = {
   	{DevSerWriteString, dev_serwritestring, D_STRING_TYPE, D_LONG_TYPE},
   	{DevSerWriteChar, dev_serwritechar, D_VAR_CHARARR, D_LONG_TYPE},
   	{DevSerReadString, dev_serreadstring, D_LONG_TYPE, D_STRING_TYPE},
   	{DevSerReadChar, dev_serreadchar, D_LONG_TYPE, D_VAR_CHARARR},
   	{DevSerSetParameter, dev_sersetparameter, D_VAR_SHORTARR, D_VOID_TYPE},
   	{DevReset, dev_reset, D_VOID_TYPE, D_VOID_TYPE},
   	{DevState, dev_state, D_VOID_TYPE, D_SHORT_TYPE},
   	{DevStatus, dev_status, D_VOID_TYPE, D_STRING_TYPE}
};

static long n_commands = sizeof(commands_list)/sizeof(DevCommandListEntry);

/*
 * reserve space for a default copy of the serialLine object
 */

static SerialLineRec serialLineRec;
SerialLine serialLine = (SerialLine)&serialLineRec;

/*
 * SerialLine resource tables used to access the static database
 *
 */

static	db_resource res_object[] = {
   {"serialline",	D_STRING_TYPE, NULL},
   {"timeout",	D_SHORT_TYPE, NULL},
   {"parity",	D_STRING_TYPE, NULL},
   {"charlength",	D_SHORT_TYPE, NULL},
   {"stopbits",	D_SHORT_TYPE, NULL},
   {"baudrate",	D_SHORT_TYPE, NULL},
   {"newline",	D_SHORT_TYPE, NULL},
   	};

static	int res_object_size = sizeof(res_object)/sizeof(db_resource);

/*
 * in order to save space on the stack declare the buffer used as
 * temporary storage by all input/output commands as static global 
 *
 * - andy 10/1/97
 */
static char buffer[SL_MAXSTRING];

/*======================================================================
 Function:      static long class_initialise()

 Description:	routine to be called the first time a device is 
 		created which belongs to this class (or is a subclass
		thereof. This routine will be called only once.

 Arg(s) In:	none

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long class_initialise(error)
long *error;
{
   register int ires;
   char *parity_string;
   short charlength, stopbits;

/*
 * SerialLineClass is a subclass of the DevServerClass
 */

   serialLineClass->devserver_class.superclass = devServerClass;
   serialLineClass->devserver_class.class_name = (char*)malloc(sizeof("SerialLineClass")+1);
   sprintf(serialLineClass->devserver_class.class_name,"SerialLineClass");
   serialLineClass->devserver_class.class_inited = 1;
   serialLineClass->devserver_class.n_commands = n_commands;
   serialLineClass->devserver_class.commands_list = commands_list;

/*
 * initialise serialLine with default values. these will be used
 * for every SerialLine object created.
 */

   serialLine->devserver.class_pointer = (DevServerClass)serialLineClass;

   serialLineClass->serialline_class.nada	= 0;

   serialLine->devserver.state = DEVON;
/*
 * program defaults for this class - these have been judiciously chosen by me
 */

/*
 * default serial line is "/i1" 
 */
   serialLine->serialline.serialline = "i1";
   serialLine->serialline.serialin = 0;
   serialLine->serialline.serialout = 0;
   serialLine->serialline.timeout = 25;
   serialLine->serialline.parity = SL_NONE;
   serialLine->serialline.charlength = SL_DATA8;
   serialLine->serialline.stopbits 	= SL_STOP1;
   serialLine->serialline.baudrate 	= 9600;
   serialLine->serialline.newline 	= 13;
   serialLine->serialline.xon 	= 0;
   serialLine->serialline.xoff 	= 0;
   serialLine->serialline.upper = 0;
   serialLine->serialline.erase = 0;
   serialLine->serialline.echo 	= 0;
   serialLine->serialline.linefeed = 0;
   serialLine->serialline.null 	= 0;
   serialLine->serialline.backspace = 0;
   serialLine->serialline.delete = 0;

/*
 * interrogate the static database for the class default values
 * and put them into the default object
 */

   ires = 0;
   res_object[ires].resource_adr	= &(serialLine->serialline.serialline);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.timeout);
   ires++;
   parity_string = NULL;
   res_object[ires].resource_adr	= &parity_string;
   ires++;
   charlength = -1;
   res_object[ires].resource_adr	= &charlength;
   ires++;
   stopbits = -1;
   res_object[ires].resource_adr	= &stopbits;
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.baudrate);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.newline);
   ires++;
/*
 * to be implemented at a later date
 *
   res_object[ires].resource_adr	= &(serialLine->serialline.xon);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.xoff);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.upper);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.erase);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.echo);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.linefeed);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.null);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.backspace);
   ires++;
   res_object[ires].resource_adr	= &(serialLine->serialline.delete);
 */

   if(db_getresource("CLASS/SerialLine/DEFAULT", res_object, res_object_size, error))
   {
   	return(DS_NOTOK);
   }
/*
 * if parity specified then convert it to an integer
 */
   if (parity_string != NULL)
   {
      if (strcmp(parity_string,"even") == 0)
      {
         serialLine->serialline.parity = SL_EVEN;
      }
      else
      {
         if (strcmp(parity_string,"odd") == 0)
         {
             serialLine->serialline.parity = SL_ODD;
         }
         else
         {
             serialLine->serialline.parity = SL_NONE;
         }
      }
   }
/*
 * do the same for the number of data bits
 */
   if (charlength > 0)
   {
      if (charlength == 5)
      {
         serialLine->serialline.charlength = SL_DATA5;
      }
      else
      {
         if (charlength == 6)
         {
            serialLine->serialline.charlength = SL_DATA6;
         }
         else
         {
            if (charlength == 7)
            {
               serialLine->serialline.charlength = SL_DATA7;
            }
            else
            {
               serialLine->serialline.charlength = SL_DATA8;
            }
         }
      }
   }
/*
 * do the same for the number of stop bits, note 1.5 stopbits
 * are not supported via the database !
 */
   if (stopbits > 0)
   {
      if (stopbits == 0)
      {
         serialLine->serialline.stopbits = SL_STOP1;
      }
      else
      {
         serialLine->serialline.stopbits = SL_STOP2;
      }
   }

      
   return(DS_OK);
}

/*======================================================================
 Function:	static long object_create()

 Description:	routine to be called on creation of a device object

 Arg(s) In:	char *name - name to be given to device

 Arg(s) Out:	DevServer *ds_ptr - pointer to created device
		long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long object_create(name, ds_ptr, error)
char *name;
DevServer *ds_ptr;
long *error;
{
   SerialLine ds;

   ds = (SerialLine)malloc(sizeof(SerialLineRec));

/*
 * initialise device with default object
 */

   *(SerialLineRec*)ds = *(SerialLineRec*)serialLine;

/*
 * finally initialise the non-default values
 */

   ds->devserver.name = (char*)malloc(strlen(name)+1);
   sprintf(ds->devserver.name,"%s",name);

   *ds_ptr = (DevServer)ds;

   return(DS_OK);
}

/*============================================================================

Function:	static long object_initialise()

Description:	routine to be called on initialisation of a device object

Arg(s) In:	SerialLine ds	- object to initialise

Arg(s) Out:

		long *error     - pointer to error code, in case routine fails
=============================================================================*/
static long object_initialise(ds, error)
SerialLine ds;
long  *error;
{
   register int ires;
   char dd_name[8];
   short short_array[20];
   DevVarShortArray dargin_varsharr;
   char *parity_string;
   short charlength,stopbits;

   ires=0;
   res_object[ires].resource_adr = &(ds->serialline.serialline);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.timeout);
   ires++;
   parity_string = NULL;
   res_object[ires].resource_adr	= &parity_string;
   ires++;
   charlength = -1;
   res_object[ires].resource_adr	= &charlength;
   ires++;
   stopbits = -1;
   res_object[ires].resource_adr	= &stopbits;
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.baudrate);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.newline);
   ires++;
/*
 * NOT implemented for the moment to be added at a later date - andy 5/1/94
 *
   res_object[ires].resource_adr = &(ds->serialline.xon);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.xoff);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.upper);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.erase);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.echo);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.linefeed);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.null);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.backspace);
   ires++;
   res_object[ires].resource_adr = &(ds->serialline.delete);
 */
   
   if(db_getresource(ds->devserver.name, res_object, res_object_size, error))
   {
   	return(DS_NOTOK);
   }
/*
 * if parity specified then convert it to an integer
 */
   if (parity_string != NULL)
   {
      if (strcmp(parity_string,"even") == 0)
      {
         ds->serialline.parity = SL_EVEN;
      }
      else
      {
         if (strcmp(parity_string,"odd") == 0)
         {
             ds->serialline.parity = SL_ODD;
         }
         else
         {
             ds->serialline.parity = SL_NONE;
         }
      }
   }
/*
 * do the same for the number of data bits
 */
   if (charlength > 0)
   {
      if (charlength == 5)
      {
         ds->serialline.charlength = SL_DATA5;
      }
      else
      {
         if (charlength == 6)
         {
            ds->serialline.charlength = SL_DATA6;
         }
         else
         {
            if (charlength == 7)
            {
               ds->serialline.charlength = SL_DATA7;
            }
            else
            {
               ds->serialline.charlength = SL_DATA8;
            }
         }
      }
   }
/*
 * do the same for the number of stop bits, note 1.5 stopbits
 * are not supported via the database !
 */
   if (stopbits > 0)
   {
      if (stopbits == 2)
      {
         ds->serialline.stopbits = SL_STOP2;
      }
      else
      {
         ds->serialline.stopbits = SL_STOP1;
      }
   }

   printf("object_initialise(): serial line to be opened /%s\n",ds->serialline.serialline);
/*
 * create the associated device descriptor filename
 */
   sprintf(dd_name,"/%s",ds->serialline.serialline);
/*
 * open the serial line once for reading
 */
   if ((ds->serialline.serialin = open(dd_name,S_IREAD)) == 0)
   {
      return(DS_NOTOK);
   }
/*
 * open the serial line once for writing
 */
   if ((ds->serialline.serialout = open(dd_name,S_IWRITE)) == 0)
   {
      return(DS_NOTOK);
   }
/*
 * setup input serial line with device's default values
 */
   short_array[0] = SL_TIMEOUT;
   short_array[1] = ds->serialline.timeout;
   
   short_array[2] = SL_PARITY;
   short_array[3] = ds->serialline.parity;
   
   short_array[4] = SL_CHARLENGTH;
   short_array[5] = ds->serialline.charlength;

   short_array[6] = SL_STOPBITS;
   short_array[7] = ds->serialline.stopbits;

   short_array[8] = SL_BAUDRATE;
   short_array[9] = ds->serialline.baudrate;

   short_array[10] = SL_NEWLINE;
   short_array[11] = ds->serialline.newline;

   dargin_varsharr.length = 12;
   dargin_varsharr.sequence = short_array;

   if (dev_sersetparameter(ds,&dargin_varsharr,NULL,error) != DS_OK)
   {
      printf("object_initialise(): problems setting input parameters, error %d\n",
             *error);
   }

   return(DS_OK);
}


/*======================================================================
 Function:      static long state_handler()

 Description:	this routine is reserved for checking wether the command
		requested can be executed in the present state.

 Arg(s) In:	SerialLine ds - device on which command is to executed
		DevCommand cmd - command to be executed

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long state_handler( ds, cmd, error)
SerialLine ds;
DevCommand cmd;
long *error;
{
   long int p_state, n_state;
   long iret = DS_OK;

   p_state = ds->devserver.state;

/*
 * Before checking out the state machine assume that the state doesn't
 * change i.e. new state == old state
 *
 */

   n_state = p_state;

   switch (p_state)
   {
    
   	case (DEVON) :	/* device ON and everything OK */
   	{
   		switch (cmd)
   		{
   			/* Allowed Command(s) */

   			case (DevStatus):	break;
   			case (DevState):	break;
   		}
   	}
   	break;

   	case (DEVFAULT) :	/* device FAULT detected, need to reset */
   	{
   		switch (cmd)
   		{
   			/* Allowed Command(s) */

   			case (DevReset):	n_state = DEVON;break;
   			case (DevStatus):	break;
   			case (DevState):	break;
   		}
   	}
   	break;

   	default:
   		*error = DevErr_UnrecognisedState;
   		iret = DS_NOTOK;
   		break;
   }
   ds->devserver.n_state = n_state;

   return(iret);
}

/*============================================================================
 Function:      static long dev_serwritestring()

 Description:	write a string of characters to a serial line  and 
		return the number of characters written
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevString *argin  - string to write
   				  
 Arg(s) Out:	DevLong *argout - no. of characters written
		long *error - pointer to error code, in case
 			      routine fails. possible error code(s)

 ============================================================================*/

static long  dev_serwritestring(ds, argin, argout, error)
SerialLine ds;
DevString *argin;
DevLong *argout;
long *error;
{
   int nchar;

#ifdef SL_DEBUG
   printf("dev_serwritestring(): %s\n",*argin);
#endif

   if((nchar = write(ds->serialline.serialout,*argin,strlen(*argin))) < 0)
   {
      *error = DevErr_DeviceWrite;
      return(DS_NOTOK);
   }

   *argout = nchar;
   return(DS_OK);
}


/*============================================================================
 Function:      static long dev_serwritechar()

 Description:	write N characters to a serial line and return the
		number of characters written
   	
 Arg(s) In:	SerialLine ds 	- 
		DevVarCharArray *argin  - characters to write
   				  
 Arg(s) Out:	DevLong *argout - no. of characters written
		long *error - pointer to error code, in case
		 	      routine fails; possible error code(s) are

 ============================================================================*/

static long  dev_serwritechar(ds, argin, argout, error)
SerialLine ds;
DevVarCharArray *argin;
DevLong *argout;
long *error;
{
   register int i;
   int nchar;

#ifdef SL_DEBUG
   printf("dev_serwritechar(): %d %s\n",argin->length,argin->sequence);
#endif

/*
 * I don't need this (I think), I can write straight from the input
 * argument
 *
 * for (i=0; i<argin->length; i++)
 * {
 *    buffer[i] = argin->sequence[i];
 * }
 */

   if((nchar = write(ds->serialline.serialout,argin->sequence,argin->length)) < 0)
   {
      *error = DevErr_DeviceWrite;
      return(DS_NOTOK);
   }

   *argout = nchar;

   return(DS_OK);
}


/*============================================================================
 Function:      static long dev_serreadstring()

 Description:	read a string of character, the type of read is specified
		in the input parameter, it can be one of SL_RAW, SL_LINE
		or SL_NCHAR
   	
 Arg(s) In:	SerialLine ds 	- 
	   	long *argin  - type of read
   				  
 Arg(s) Out:	*argout - string read
		long *error - pointer to error code, in case
	 	              routine fails; possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_serreadstring(ds, argin, argout, error)
SerialLine ds;
DevLong	*argin;
DevString *argout;
long *error;
{
   register i;
   long read_type, nchar;

   read_type = *argin & 0x000f;

   switch (read_type) {
 
      case SL_RAW :   if (dev_rawreadstring(ds,NULL,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      case SL_NCHAR : nchar = *argin >> 8;
                      if (dev_ncharreadstring(ds,&nchar,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      case SL_LINE :  if (dev_linereadstring(ds,NULL,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      default : *error = DevErr_UnknownInputParameter;

                return(DS_NOTOK);
   }

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_serreadchar()

 Description:	read an array of characters, the type of read is specified
		in the input parameter, it can be one of SL_RAW, SL_LINE
		or SL_NCHAR
   	
 Arg(s) In:	SerialLine ds 	- serial line device
	   	long *argin  - type of read
   				  
 Arg(s) Out:	DevVarCharArray *argout - array of characters read
		long *error - pointer to error code, in case
	 	              routine fails; possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_serreadchar(ds, argin, argout, error)
SerialLine ds;
DevLong	*argin;
DevVarCharArray *argout;
long *error;
{
   register i;
   long read_type, nchar;

   read_type = *argin & 0x000f;

   switch (read_type) {
 
      case SL_RAW :   if (dev_rawreadchar(ds,NULL,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      case SL_NCHAR : nchar = *argin >> 8;
                      if (dev_ncharreadchar(ds,&nchar,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      case SL_LINE :  if (dev_linereadchar(ds,NULL,argout,error) != DS_OK)
                      {
                         return(DS_NOTOK);
                      }
               
                      break;

      default : *error = DevErr_UnknownInputParameter;

                return(DS_NOTOK);
   }

   return(DS_OK);
}
/*============================================================================
 Function:      static long dev_rawreadstring()

 Description:	read a string of characters from the serial line
		if there are no characters to be read return an
		empty string.
   	
 Arg(s) In:	SerialLine ds - serial line device
		*argin  - none
   				  
 Arg(s) Out:	*argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_rawreadstring(ds, argin, argout, error)
SerialLine ds;
DevVoid *argin;
DevString *argout;
long *error;
{
   register int i;
   /*static char buffer[SL_MAXSTRING+1];*/
   int nchar;
/*
 * first "empty" buffer by null terminating it
 */ 
   buffer[0] = 0;

/*
 * only read what is in the buffer (if there is anything)
 */
   if ((nchar = _gs_rdy(ds->serialline.serialin)) > 0)
     {
       if (nchar > SL_MAXSTRING)
	 {
	   nchar = SL_MAXSTRING;
	 }
       if ((nchar = read(ds->serialline.serialin,buffer,nchar)) < 0)
	 {
	   /*
	    * more complicated error treatment will go here (if need be)
	    */
	   *error = DevErr_DeviceRead;
	   return(DS_NOTOK);
	 }
       else
	 {
	   buffer[nchar] = 0;
	 }
     }
      
#ifdef SL_DEBUG
   printf("readstring(): nchar %d buffer %s\n",nchar,buffer);
#endif
   
   *argout = buffer;

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_ncharreadstring()

 Description:	read a string of N characters from the serial line
		if there are no characters to be read return an
		empty string.
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevLong *argin  - number of characters to read
   				  
 Arg(s) Out:	DevString *argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_ncharreadstring(ds, argin, argout, error)
SerialLine ds;
DevLong *argin;
DevString *argout;
long *error;
{
   register int i;
   int nchar;
   /*static char buffer[SL_MAXSTRING+1];*/

/*
 * "empty" buffer first by null terminating it before reading
 */ 
   buffer[0] = 0;
/*
 * only read N characters , if there is a timeout before then return
 * an error
 */
   if (*argin > SL_MAXSTRING)
   {
      *argin = SL_MAXSTRING;
   }

   if ((nchar = read(ds->serialline.serialin,buffer,*argin)) < 0)
   {
      *error = DevErr_DeviceRead;
      return(DS_NOTOK);
/*
 * more complicated error treatment will go here (if need be)
 */
   }
   else
   {
      buffer[nchar] = 0;
   }
      
#ifdef SL_DEBUG
   printf("dev_ncharreadstring(): nchar %d buffer %s\n",nchar,buffer);
#endif
   
   *argout = buffer;

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_linereadstring()

 Description:	read a string of N characters from the serial line
		up and including the next newline 
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevVoid *argin  - none
   				  
 Arg(s) Out:	DevString *argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_linereadstring(ds, argin, argout, error)
SerialLine ds;
DevVoid *argin;
DevString *argout;
long *error;
{
   register int i;
   int nchar;
   /*static char buffer[SL_MAXSTRING];*/

/*
 * "empty" buffer first by null terminating it before reading
 */ 
   buffer[0] = 0;

/*
 * if there is a timeout or other error before then return an error
 */

   if ((nchar = readln(ds->serialline.serialin,buffer,SL_MAXSTRING)) < 0)
   {
      *error = DevErr_DeviceRead;
      return(DS_NOTOK);
/*
 * more complicated error treatment will go here (if need be)
 */
   }
   else
   {
      buffer[nchar] = 0;
   }
      
#ifdef SL_DEBUG
   printf("dev_linereadstring(): buffer %s\n",buffer);
#endif
   
   *argout = buffer;

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_rawreadchar()

 Description:	read an array of characters from the serial line
		if there are no characters to be read return an
		empty array.
   	
 Arg(s) In:	SerialLine ds - serial line device
		*argin  - none
   				  
 Arg(s) Out:	*argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_rawreadchar(ds, argin, argout, error)
SerialLine ds;
DevVoid *argin;
DevVarCharArray *argout;
long *error;
{
   register int i;
   int nchar;
   /*static char buffer[SL_MAXSTRING];*/

/*
 * "empty" buffer first by null terminating it before reading
 */ 
   buffer[0] = 0;
   nchar = 0;

/*
 * only read what is in the buffer (if there is anything)
 */
   if ((nchar = _gs_rdy(ds->serialline.serialin)) > 0)
   {
      if (nchar > SL_MAXSTRING)
      {
         nchar = SL_MAXSTRING;
      }
      if ((nchar = read(ds->serialline.serialin,buffer,nchar)) < 0)
      {
/*
 * more complicated error treatment will go here (if need be)
 */
         *error = DevErr_DeviceRead;
         return(DS_NOTOK);
      }
      else
      {
         buffer[nchar] = 0;
      }
   }
   else
   {
      nchar = 0;
   }
      
#ifdef SL_DEBUG
   printf("dev_rawreadchar(): nchar %d buffer %s\n",nchar,buffer);
#endif

   argout->length = nchar;
   argout->sequence = buffer;

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_ncharreadchar()

 Description:	read an array of N characters from the serial line
		if there are no characters to be read return an
		empty array.
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevLong *argin  - number of characters to read
   				  
 Arg(s) Out:	DevString *argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_ncharreadchar(ds, argin, argout, error)
SerialLine ds;
DevLong *argin;
DevVarCharArray *argout;
long *error;
{
   register int i;
   int nchar, status;
   /*static char buffer[SL_MAXSTRING+1];*/

/*
 * "empty" buffer first by null terminating it before reading
 */ 
   buffer[0] = 0;
   nchar = *argin;

/*
 * only read N characters , if there is a timeout before then return
 * an error
 */
   if (nchar > SL_MAXSTRING)
   {
      nchar = SL_MAXSTRING;
   }

#ifdef SL_DEBUG
   printf("dev_ncharreadchar(): nchar %d characters to read\n",nchar);
#endif

   if ((nchar = read(ds->serialline.serialin,buffer,nchar)) < 0)
   {
      *error = DevErr_DeviceRead;
      return(DS_NOTOK);
   }
   else
   {
      buffer[nchar] = 0;
   }

#ifdef SL_DEBUG
   printf("dev_ncharreadchar(): nchar %d buffer %s\n",nchar,buffer);
#endif
   
/*
 * more complicated error treatment will go here (if need be)
 */
   argout->length = nchar;
   argout->sequence = buffer;

   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_linereadchar()

 Description:	read an array of N characters from the serial line
		up and including the next newline 
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevVoid *argin  - none
   				  
 Arg(s) Out:	DevString *argout - string read
		long *error - pointer to error code, in case
		  	      routine fails. possible error code(s)
                              are DevErr_DeviceTimeout
 ============================================================================*/

static long  dev_linereadchar(ds, argin, argout, error)
SerialLine ds;
DevVoid *argin;
DevVarCharArray *argout;
long *error;
{
   register int i;
   int nchar;
   /*static char buffer[SL_MAXSTRING];*/

/*
 * "empty" buffer first by null terminating it before reading
 */ 
   buffer[0] = 0;

/*
 * if there is a timeout or error before then return an error
 */

   if ((nchar = readln(ds->serialline.serialin,buffer,SL_MAXSTRING)) < 0)
   {
/*
 * more complicated error treatment will go here (if need be)
 */
      *error = DevErr_DeviceRead;
      return(DS_NOTOK);
   }
   else
   {
      buffer[nchar] = 0;
   }
      
#ifdef SL_DEBUG
   printf("dev_linereadstring(): buffer %s\n",buffer);
#endif
   
   argout->length = nchar;
   argout->sequence = buffer;

   return(DS_OK);
}


/*============================================================================
 Function:      static long dev_sersetparameter()

 Description:	set serial line parameters
   	
 Arg(s) In:	SerialLine ds 	- serial line device
		DevVarShortArray *argin  - device parameters, in pairs
   				  
 Arg(s) Out:	*argout - none
		long *error - pointer to error code, in case
		 	      routine fails. possible error code(s):

 ============================================================================*/

static long  dev_sersetparameter(ds, argin, argout, error)
SerialLine ds;
DevVarShortArray *argin;
DevVoid *argout;
long *error;
{
   register int i,j;
   unsigned char parity, charlength, stopbits;
   unsigned short baudrate, baudcode;
   union scf_opts { struct sgbuf buf;
		    struct scf_opt opt;
                  } scfin, scfout;

/*
 * first get the existing serial line setup from the file descriptors opened
 * for input and for output
 */

   if (_gs_opt(ds->serialline.serialin, &scfin) < 0)
   {
      *error =  DevErr_SerialLineInitFailed;
      return(DS_NOTOK); 
   }
   if (_gs_opt(ds->serialline.serialout, &scfout) < 0)
   {
      *error =  DevErr_SerialLineInitFailed;
      return(DS_NOTOK); 
   }
   
   for (i=0; i<argin->length; i=i+2)
   {
      switch (argin->sequence[i]) 
      {
      
         case SL_TIMEOUT :        
/*
 * setup the serial line for timeouts if timeout > 0
 * this uses a routine written by Petri and works only
 * for the IBAM driver at the ESRF !
 * 
 * only modifies the timeout for the file descriptor opened
 * for input
 *
 * the units of this timeout are in 1/256th of a second fixed
 * by Petri.
 */
              if (argin->sequence[i+1] > 0)
              {
                 _ss_timeout(ds->serialline.serialin,argin->sequence[i+1]);
                 ds->serialline.timeout = argin->sequence[i+1];
              }

              break;

         case SL_PARITY :
/*
 * setup up parity according to input parameter, first AND off old
 * parity and then OR in new parity
 */
              parity = argin->sequence[i+1] & 0x03;     
              scfin.opt.pd_par = scfin.opt.pd_par & 0xfc;
              scfout.opt.pd_par = scfin.opt.pd_par & 0xfc;
              scfin.opt.pd_par = scfin.opt.pd_par | parity;
              scfout.opt.pd_par = scfout.opt.pd_par | parity;

              printf("sersetparameter(): parity %02x scfin %02x scfout %02x\n",
                     parity,scfin.opt.pd_par,scfout.opt.pd_par);

              break;

         case SL_CHARLENGTH :
/*
 * setup up no. of data bits per character according to input parameter, 
 * first AND off old charlength and then OR in new charlength
 */
              charlength = argin->sequence[i+1] & 0x03;     
              scfin.opt.pd_par = scfin.opt.pd_par & 0xf3;
              scfout.opt.pd_par = scfout.opt.pd_par & 0xf3;
              scfin.opt.pd_par = scfin.opt.pd_par | (charlength<<2);
              scfout.opt.pd_par = scfout.opt.pd_par | (charlength<<2);

              printf("sersetparameter(): charlength %02x scfin %02x scfout %02x\n",
                     charlength,scfin.opt.pd_par,scfout.opt.pd_par);

              break;

         case SL_STOPBITS :
/*
 * setup up no. of stop bits per character according to input parameter, 
 * first AND off old stopbits and then OR in new stopbits
 */
              stopbits = argin->sequence[i+1] & 0x03;     
              scfin.opt.pd_par = scfin.opt.pd_par & 0xcf;
              scfout.opt.pd_par = scfin.opt.pd_par & 0xcf;
              scfin.opt.pd_par = scfin.opt.pd_par | (stopbits<<4);
              scfout.opt.pd_par = scfout.opt.pd_par | (stopbits<<4);

              printf("sersetparameter(): stopbits %02x scfin %02x scfout %02x\n",
                     stopbits,scfin.opt.pd_par,scfout.opt.pd_par);


              break;

         case SL_BAUDRATE :
/*
 * convert BAUDRATE from short to a one-byte code (understood
 * by the SCF driver) use a post-office function to do so
 * 
 */
              baudrate = argin->sequence[i+1];
              switch (baudrate) 
              {
                 case 19200 : baudcode = 15; break;
                 case 9600  : baudcode = 14; break;
                 case 7200  : baudcode = 13; break;
                 case 4800  : baudcode = 12; break;
                 case 3600  : baudcode = 11; break;
                 case 2400  : baudcode = 10; break;
                 case 2000  : baudcode =  9; break;
                 case 1800  : baudcode =  8; break;
                 case 1200  : baudcode =  7; break;
                 case 600   : baudcode =  6; break;
                 case 300   : baudcode =  5; break;
                 case 150   : baudcode =  4; break;
                 case 135   : baudcode =  3; break;
                 case 110   : baudcode =  2; break;
                 case 75    : baudcode =  1; break;
                 case 50    : baudcode =  0; break;

                 default    : baudcode = 14; break;
              }

              scfin.opt.pd_bau = baudcode;
              scfout.opt.pd_bau = baudcode;
              printf("sersetparameter(): baud rate %d code %02x (scfin %02x scfout %02x)\n",
                     baudrate,baudcode,scfin.opt.pd_bau,scfout.opt.pd_bau);
              break;

         case SL_NEWLINE :
/*
 * setup new NEWLINE character
 */
              scfin.opt.pd_eor = argin->sequence[i+1];
              scfout.opt.pd_eor = argin->sequence[i+1];

              printf("sersetparameter(): newline %02x scfin %02x scfout %02x\n",
                     argin->sequence[i+1],scfin.opt.pd_eor,scfout.opt.pd_eor);

              break;

         default :

              break;
      }
   }
/*
 * the following serial line parameters are not accessible from the
 * client. they are therefore forced to predefined values here. if
 * this poses a problem for any client they can be made accessible.
 * the parameters referred to are the socalled editing functions
 * available under the OS9 SCF (sequential character filemanager) driver
 *
 */

   scfin.opt.pd_upc = 0; /* DO NOT CONVERT LOWERCASE TO UPPERCASE */
   scfout.opt.pd_upc = 0;
   scfin.opt.pd_bso = 0; /* DO NOT ECHO BACKSPACE TWICE */
   scfout.opt.pd_bso = 0;
   scfin.opt.pd_dlo = 0; /* DELETE BY BACKSPACE ERASING OVER LINE */
   scfout.opt.pd_dlo = 0;
   scfin.opt.pd_eko = 0; /* DO NOT ECHO */
   scfout.opt.pd_eko = 0;
   scfin.opt.pd_alf = 0; /* DO NOT AUTOMATIC LINEFEED AFTER CR */
   scfout.opt.pd_alf = 0;
   scfin.opt.pd_nul = 0; /* DO NOT SEND NULL BYTES AS PADDING AFTER CR */
   scfout.opt.pd_nul = 0;
   scfin.opt.pd_pau = 0; /* DO NOT PAUSE AFTER A PAGE OF OUTPUT */
   scfout.opt.pd_pau = 0;
   scfin.opt.pd_bsp = 0; /* INPUT BACKSPACE CHARACTER FORCED TO ZERO */
   scfout.opt.pd_bsp = 0;
   scfin.opt.pd_del = 0; /* INPUT DELETE CHARACTER FORCED TO ZERO */
   scfout.opt.pd_del = 0;
   scfin.opt.pd_eof = 0; /* END OF FILE CHARACTER SET TO ZERO */
   scfout.opt.pd_eof = 0;
   scfin.opt.pd_rpr = 0; /* REPRINT LINE CHARACTER SET TO ZERO */
   scfout.opt.pd_rpr = 0;
   scfin.opt.pd_dup = 0; /* DUPLICATE LAST LINE CHARACTER SET TO ZERO */
   scfout.opt.pd_dup = 0;
   scfin.opt.pd_psc = 0; /* INPUT PAUSE CHARACTER SET TO ZERO */
   scfout.opt.pd_psc = 0;
   scfin.opt.pd_int = 0; /* INPUT INTERRUPT CHARACTER SET TO ZERO */
   scfout.opt.pd_int = 0;
   scfin.opt.pd_qut = 0; /* INPUT QUIT CHARACTER SET TO ZERO */
   scfout.opt.pd_qut = 0;
   scfin.opt.pd_bse = 0; /* BACKSPACE OUTPUT CHARACTER SET TO ZERO */
   scfout.opt.pd_bse = 0;
   scfin.opt.pd_ovf = 0; /* LINE OVERFLOW CHARACTER SET TO ZERO */
   scfout.opt.pd_ovf = 0;
/*
   scfin.opt.pd_xon = 17; * XON CHARACTER SET TO ^Q *
   scfout.opt.pd_xon = 17;
 */
   scfin.opt.pd_xon = 0; /* XON CHARACTER SET TO ZERO , SWITCHED OFF ! */
   scfout.opt.pd_xon = 0;
/*
   scfin.opt.pd_xoff = 19; * XOFF CHARACTER SET TO ^S *
   scfout.opt.pd_xoff = 19;
 */
   scfin.opt.pd_xoff = 0; /* XOFF CHARACTER SET TO ZERO , SWITCHED OFF ! */
   scfout.opt.pd_xoff = 0;
   scfin.opt.pd_Tab = 0; /* TAB CHARACTER  SET TO ZERO */
   scfout.opt.pd_Tab = 0;
   scfin.opt.pd_Tabs = 0; /* TAB FIELD SIZE SET TO ZERO */
   scfout.opt.pd_Tabs = 0;
/*
 * now do it ! i.e. modify the open device descriptor
 */
   if (_ss_opt(ds->serialline.serialin,&scfin) < 0)
   {
      printf("sersetparameter(): problem with _ss_opt(scfin), error %d\n",errno);
      *error =  DevErr_SerialLineInitFailed;
      return(DS_NOTOK);
   }
   if (_ss_opt(ds->serialline.serialout,&scfout) < 0)
   {
      printf("sersetparameter(): problem with _ss_opt(scfout), error %d\n",errno);
      *error =  DevErr_SerialLineInitFailed;
      return(DS_NOTOK);
   }

   return(DS_OK);
}


/*============================================================================
 Function:      static long dev_reset()

 Description:	routine to reset the serial line by closing it and
		then reopening and reinitialising it.

 Arg(s) In:	SerialLine 	ds 	- 
		DevVoid	*argin  - none
   				  
 Arg(s) Out:	DevVoid	*argout - none
============================================================================*/

static long dev_reset(ds, argin, argout, error)
SerialLine        ds;
DevVoid         *argin;
DevVoid	*argout;
long		*error;
{

/*
 * close files opened for reading and writing
 */

   close(ds->serialline.serialin);
   close(ds->serialline.serialout);

/*
 * reopen the files and reinitialise by calling the initialise method
 */
   if (object_initialise(ds,error) != DS_OK)
   {
      return(DS_NOTOK);
   }

   return (DS_OK);
}



/*============================================================================
 Function:      static long dev_state()

 Description:	routine to read state of serialLine

 Arg(s) In:	SerialLine 	ds 	- 
		DevVoid  	*argin  - none
   				  
 Arg(s) Out:	DevShort	*argout - returned state 
		long *error - 	pointer to error code, in case routine fails

============================================================================*/

static long dev_state(ds, argin, argout, error)
SerialLine	ds;
DevVoid		*argin;
DevShort	*argout;
long		*error;
{

   *argout	= ds->devserver.state;

   return(DS_OK);
}



/*============================================================================
 Function:      static long dev_status()

 Description:	routine to return state as an ASCII string

 Arg(s) In:	SerialLine 	ds 	- 
		DevVoid  	*argin  - none
   				  
 Arg(s) Out:	DevString	*argout - contains string 
============================================================================*/

static long dev_status(ds, argin, argout, error)
SerialLine        ds;
DevVoid         *argin;
DevString	*argout;
long		*error;
{

   static	char	str[80];


   sprintf(str,"The serial line is :%s\n", DEVSTATES[ds->devserver.state]);
   *argout = str;

   return (DS_OK);
}
