static char RcsId[] = "$Header: /segfs/dserver/classes++/serial/line/src/RCS/startup.cpp,v 1.10 2000/02/11 16:19:47 perez Exp $";

//+**********************************************************************
//
// File:	startup.C
//
// Project:	Device Servers in C++
//
// Description:	Startup file for the Serial class implemented in C++
//		
//
// Author(s):	Manuel Perez
//
// Original:	January 1997 by Emmanuel Taurel, Andy Gotz
//
// $Log: startup.cpp,v $
// Revision 1.10  2000/02/11 16:19:47  perez
// debug levels 0/1/2 with class resource + change sselect() error
//
// Revision 1.8  1999/11/26 13:44:38  perez
// delete most of the debug printed messages
//
// Revision 1.7  1999/06/22 11:49:38  perez
// serialds: full path serialline device descriptor
//
// Revision 1.6  1999/06/22 11:15:29  perez
// serialds: add CLASS resource for debug messages
//
// Revision 1.5  1999/06/21 13:58:17  perez
// First Release
//
// Revision 1.4  1999/04/09 15:30:17  perez
// Ok, with board init in driveur
//
// Revision 1.3  1999/04/06 11:36:48  perez
// Add miniterm and bridge tools
//
// Revision 1.2  1999/03/25 16:18:01  perez
// Works with standard driver (one IRQ per port)
//
// Revision 1.1  1999/03/02 09:53:28  perez
// Suppress Class resources
//
// Revision 1.0  1999/02/23 18:38:56  perez
// Initial Revision
//
//
//
//+**********************************************************************
		
#include <API.h>
#include <DevSignal.h>

#include <DevServer.h> /* will include Device.H */
#include <Serial.h>

// extern void catchSig(int);

Serial *device_ds[MAX_DEVICES];
unsigned int n_devices;

long startup(char *svr_name, long *error)
{
   char **dev_list;
   unsigned int i;
   long status;

   printf ("startup++() called (server name = %s)\n",svr_name);
   int l = strlen(RcsId); /* necessary for Ultra C++ to include RcsId */

//
// install signal handler
//

//   ds__signal(SIGINT,catchSig,error);
//   ds__signal(SIGQUIT,catchSig,error);
//   ds__signal(SIGHUP,catchSig,error);

//
// get the list of device name to be served from the static database
//

   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
        printf("startup(): db_getdevlist() failed, error %d\n",*error);
        return(DS_NOTOK);
   }
   printf("following devices found in static database: \n");
   for (i=0;i<n_devices;i++)
   {
       	printf("\t%s\n",dev_list[i]);
   }

//
// now loop round creating and exporting the devices
//

   for (i=0; i<n_devices; i++)
   {
      	device_ds[i] = new Serial(dev_list[i],error);
	if ((device_ds[i] == 0) || (*error != 0))
	{
		printf("Error when trying to create %s device\n",dev_list[i]);
		return(DS_NOTOK);
	}

//
// export the device onto the network
//

      	status = dev_export((char*)device_ds[i]->name,(Device*)device_ds[i],(long*)error);

      	printf("startup++() dev_export() returned %d (error = %d)\n",status,*error);
   }

   printf("leaving startup++() and all's OK\n");

   return(DS_OK);
}
