/*static char RcsId[] = "$Header:$";*/

/*********************************************************************
 *
 * File:	startup.c
 *
 * Project:	Test
 *
 * Description:	Startup procedure for TestclassClass. The
 *		startup procedure is the first procedure called
 *		from main() when the device server starts up.
 *		All toplevel devices to be created for the device 
 *		server should be done in startup(). The startup 
 *		should make use of the database to determine which 
 *		devices it should create. Initialisation of devices
 *		is normally done from startup().
 *
 * Author(s);	MARTIN olivier 
 *
 * Original:	November 25 1998	
 *
 * $Log:$
 * 
 * Copyright (c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Nov 27 11:16:01 1998).
 *
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>
#include <TestclassP.h>
#include <Testclass.h>


/*
 * pointer to list of devices returned by database.
 *
 */
static char 			**dev_list;
static unsigned int	n_devices;
static Testclass		*ds_list;
/************************************************************************

Function   :	long startup()

Description:	create, initialise and export all of the objects
		associated with this server

Arg(s) In  :	svc_name

Arg(s) Out :	error:      error return code

Return(s)  :	minus one on failure, zero otherwise

*************************************************************************/
long startup(svr_name, error)
char *svr_name;
long *error;
{
   long		i,	status, n_exported;
   short		iret;

   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
      printf("startup(): db_getdevlist() failed: %s\n",dev_error_str(*error));
      return(-1);
   }
   printf("following devices found in static database: \n\n");
   for (i=0;i<n_devices;i++)
   {
      printf("\t%s\n",dev_list[i]);
   }

/*
 * create, initialise and export all devices served by this server
 ******************************************************************
 */
   ds_list=(Testclass *)malloc(n_devices*sizeof(Testclass*));
   if(ds_list==0)
   {
   	printf("can't allocate memory for object structures --> exit\n");
   	return(DS_NOTOK);
   }
   
   for (i=0, n_exported = 0; i < n_devices; i++, n_exported++)
   {
      printf("\t\tObject %s is\n",dev_list[i]);
      fflush(stdout);

      if (ds__create(dev_list[i], testclassClass, &(ds_list[i]),error) != 0)
      {
   	  printf("create failed: %s\n", dev_error_str(*error));
   	  continue;
      }
      else printf("\t\t- Created\n");

      /* initialise the newly created testclass
       *******************************************
       */
  
      if(ds__method_finder(ds_list[i],DevMethodInitialise)
			  (ds_list[i],error)!= 0)
      {
      	   printf("initialise failed: %s\n", dev_error_str(*error));
   	   continue;
      }
      else printf("\t\t- Initialised\n");

      /*  now export it to the outside world 
       *******************************************
       */
 
      if (ds__method_finder(ds_list[i],DevMethodDevExport)
			   (dev_list[i],ds_list[i],error) != 0)
      {
   	   printf("export failed: %s\n", dev_error_str(*error));
   	   continue;
      }
      else printf("\t\t- Exported\n\n");
   }

   switch(n_exported)
   {
      case 0:	
   	   printf("No devices exported - testclass server exiting\n");
   	   *error = 0;
   	   iret = -1;
   	   break;

      case 1:	
   	   printf("Testclass server running with 1 device exported\n");
   	   *error = 0;
   	   iret = 0;
   	   break;

      default:
   	   printf("Testclass server running %d devices exported\n",n_exported);
   	   *error = 0;
   	   iret = 0;
   }
   return(iret);
}
