

/*********************************************************************
 *
 * File:   Testclass_menu.c
 *
 * Project:   Test 
 *
 * Description:   An interactive main routine for test all the commands
 *      of the Device Server Testclass.
 *
 * Author(s):   MARTIN olivier 
 *
 * Original:   November 25 1998   
 *
 * $Log:$
 *
 * Copyleft (c) 1992 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File Generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Nov 27 11:15:54 1998).
 *
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Testclass.h>

extern long debug_flag;

static long		readwrite = 0;
static char		cmd_string[80];
static devserver	ds;
static long		error;
static int		cmd;
static short		ret;
static long		retour;

static DevShort		state;
static DevString	status;
static DevFloat 	on_argout;
static DevFloat 	off_argout;
static DevVarStringArray 	readvalue_argout;
static DevVarFloatArray		sigvalues_argout;
static DevString 	write_argin;
static DevString 	read_argout;



main(argc,argv)
unsigned int 	   argc;
char      	   **argv;
{

   int	setvalue, ret, i, j=-1;
   char x[100];
   char *saisie=NULL;

   if (argc < 2)
   {
      printf("usage: %s device-name\n",argv[0]);
      exit(1);
   }

   ret = dev_import(argv[1],readwrite,&ds,&error);
   if(ret != 0)
   {
      printf("can't import %s: %s\n",argv[1],dev_error_str(error));
      exit(1);
   }

   while (1)
   {
     ret = dev_putget(ds, DevStatus,
                  NULL, D_VOID_TYPE,
                  &status, D_STRING_TYPE, &error);
      printf("test_menu for %s (%s)\n",argv[1],ds->device_class);
      printf("____________________________________\n\n");
     if(ret < 0)
        printf("can't read status: %s\n", dev_error_str(error));
     else printf("%s\n", status);
      printf("____________________________________\n\n");
      printf("1.State \t");
      printf("2.Status \n");
   	printf("3.On  \t");
   	printf("4.Off  \t");
   	printf("5.ReadValue\n");
   	printf("6.Write  \t");
   	printf("7.Read \n");
   	printf("8.ReadSignalValues\n");
   	printf("9.UpdateSignalValues\n");
      printf("Select one commands (0 to quit) : ? ");

      fgets(cmd_string, 3, stdin);
      rewind(stdin);
      ret = sscanf(cmd_string,"%d",&cmd);

      switch (cmd) 
      {
         case (0) : exit(1);
         case (1) :
            ret = dev_putget(ds, DevState,
                  NULL, D_VOID_TYPE,
                  &state, D_SHORT_TYPE, &error);
            if(ret < 0)
               printf("can't read state: %s\n", dev_error_str(error));
            else printf("The state is %s (%d)\n",DEVSTATES[state],
						 state);
         break;

         case (2) :
          break;

         case (3) :
         /* Insert here your code to read the input argument(s), see the 
	  * routines below. Exemple:
	  * ReadIntValue(0, 100, &setvalue);
	  */
            ret = dev_putget(ds, DevOn,
                  NULL, D_VOID_TYPE,
                  &on_argout, D_FLOAT_TYPE, &error);
            if(ret < 0)
               printf("Can't execute DevOn: %s\n", dev_error_str(error)); 

         /* Insert here your code for the command DevOn */

         break;

         case (4) :
         /* Insert here your code to read the input argument(s), see the 
	  * routines below. Exemple:
	  * ReadIntValue(0, 100, &setvalue);
	  */
            ret = dev_putget(ds, DevOff,
                  NULL, D_VOID_TYPE,
                  &off_argout, D_FLOAT_TYPE, &error);
            if(ret < 0)
               printf("Can't execute DevOff: %s\n", dev_error_str(error)); 

         /* Insert here your code for the command DevOff */

         break;

         case (5) :
         /* Insert here your code to read the input argument(s), see the 
	  * routines below. Exemple:
	  * ReadIntValue(0, 100, &setvalue);
	  */
         
             
            
            readvalue_argout.length=0;
            readvalue_argout.sequence=NULL;
            
            ret = dev_putget(ds,DevGetSigConfig , 
                  NULL, D_VOID_TYPE,
                  &readvalue_argout, D_VAR_STRINGARR, &error);
            if(ret < 0)
               printf("Can't execute DevReadValue: %s\n", dev_error_str(error)); 

         /* Insert here your code for the command DevReadValue */
         
         if(readvalue_argout.length>0){
         	for(i=0;i<=readvalue_argout.length;i++){
         		printf(" \n%s ",readvalue_argout.sequence[i]);
         	}
	 }
         else{
         	printf(" Length = %d ",readvalue_argout.length);
         }
         
         
         
 	 /* Free the memory */
          
          	
          	retour = dev_xdrfree(D_VAR_FLOATARR, &readvalue_argout , &error);			
           	if(retour != 0){
           		printf("Can't execute dev_xdrfree:");
           	}
           	printf("\n The memory is free ");
           
         break;

         case (6) :
         /* Insert here your code to read the input argument(s), see the 
	  * routines below. Exemple:
	  * ReadIntValue(0, 100, &setvalue);
	  */
	  printf("\n Write your caracters string.");
	  gets(x);
	  
	  saisie=&(x[0]);
	  /*j=strlen(saisie)+1;*/
	  printf(" %s ",*saisie);
	  
	  
	 	/* write_argin.length=j;*/
		  write_argin = saisie;
		  printf(" %s ",*saisie);
		 
		 /* printf(" %s ",*(write_argin.sequence));*/
	  
          	  ret = dev_putget(ds, DevWrite,
                  &write_argin, D_STRING_TYPE,
                  NULL, D_VOID_TYPE, &error);
            	if(ret < 0)
	               	printf("Can't execute DevWrite: %s\n", dev_error_str(error)); 

	         /* Insert here your code for the command DevWrite */
	
         break;

         case (7) :
         /* Insert here your code to read the input argument(s), see the 
	  * routines below. Exemple:
	  * ReadIntValue(0, 100, &setvalue);
	  */
            read_argout=NULL;        

            ret = dev_putget(ds, DevRead,
                  NULL, D_VOID_TYPE,
                  &read_argout, D_STRING_TYPE, &error);
            if(ret < 0)
               printf("Can't execute DevRead: %s\n", dev_error_str(error)); 

         /* Insert here your code for the command DevRead */
	  
	  	printf(" \n %s ",read_argout);
	 
          	
          	retour = dev_xdrfree(D_STRING_TYPE, &read_argout , &error);			
           	if(retour != 0){
           		printf("Can't execute dev_xdrfree:");
           	}
           	printf("\n The memory is free ");
            
	  	
         break;
	 
	 case (8) :
         	sigvalues_argout.length=0;
         	sigvalues_argout.sequence=NULL;
         
        	 ret = dev_putget(ds, DevReadSigValues,
                  NULL, D_VOID_TYPE,
                  &sigvalues_argout, D_VAR_FLOATARR, &error);
            if(ret < 0)
               printf("Can't execute DevReadSigValues: %s\n", dev_error_str(error)); 
        
             if(sigvalues_argout.length>0){
         	for(i=0;i<=(sigvalues_argout.length-1);i++){
         		printf(" %f ",sigvalues_argout.sequence[i]);
         	}
	 }
         else{
         	printf(" Length = %d ",sigvalues_argout.length);
         }
         
         retour = dev_xdrfree(D_STRING_TYPE, &sigvalues_argout , &error);			
           	if(retour != 0){
           		printf("Can't execute dev_xdrfree:");
           	}
           	printf("\n The memory is free ");
         
         break;
        
         case (9) :
         	
         
        	 ret = dev_putget(ds, DevUpdateSigConfig,
                  NULL, D_VOID_TYPE,
                  NULL, D_VOID_TYPE, &error);
            if(ret < 0){
               printf("Can't execute DevUpdateSigConfig: %s\n", dev_error_str(error)); 
            }
            else{
            	 printf(" Update Signals Config	");
          
            }
          break;
        
        
         default : break;
      }
   }
}
/**************************************************************************/
int ReadIntValue(lv,uv,par)
/*+************************************************************************
 Purpose:	Reads user input that should be integer
 Returns:	OK/NOK
*************************************************************************-*/ 
int lv;                               /* lower limit            */
int uv;                               /* upper limit            */
int *par; 				/* Return parameter       */ 
{
    char cmd_string[80];
  
    fgets(cmd_string, 80, stdin);
    rewind(stdin);
    if (((cmd_string[0]<'0') || (cmd_string[0]>'9')) && (cmd_string[0] !='-'))
    	return(DS_NOTOK);
    
    /* Convert string value into numeric value */
    sscanf(cmd_string,"%d",par);
    if ((*par<lv) || (*par>uv)) 
    	return(DS_NOTOK); 
    else return(DS_OK);
}

/**************************************************************************/
int ReadCharValue(lv,uv,par)
/*+************************************************************************
 Purpose:	Reads user input that should be short
 Returns:	OK/NOK
*************************************************************************-*/ 
char lv;                                        /* lower limit            */
char uv;                                        /* upper limit            */
char  *par; 					/* Return parameter       */ 
{
    char cmd_string[80];
    long rr;
  
    fgets(cmd_string, 80, stdin);
    rewind(stdin);
    
    if ((cmd_string[0]<'a') || (cmd_string[0]>'z')) 
    return(DS_NOTOK);
    /* Convert string value into numeric value */
    *par = cmd_string[0];
    if ((*par<lv) || (*par>uv)) 
    return(DS_NOTOK); 
    else return(DS_OK);
}

/**************************************************************************/
int ReadShortValue(lv,uv,par)
/*+************************************************************************
 Purpose:	Reads user input that should be short
 Returns:	OK/NOK
*************************************************************************-*/ 
short lv;                               /* lower limit            */
short uv;                               /* upper limit            */
short *par;				/* Return parameter       */ 
{
char cmd_string[80];
int rr;  
  fgets(cmd_string, 80, stdin);
  rewind(stdin);
  if (((cmd_string[0]<'0') || (cmd_string[0]>'9')) && (cmd_string[0] !='-') )
     return(DS_NOTOK);
  /* Convert string value into numeric value */
  sscanf(cmd_string,"%d",&rr);
  *par=(short)rr;
  if ((*par<lv) || (*par>uv)) 
     return(DS_NOTOK); 
  else return(DS_OK);
}

