/*static char RcsId[] = "$Header: Testclass.c,v 1.5 96/12/18 09:43:01 fladmark Exp $";*/
/*********************************************************************
 *
 *File:		Testclass.c
 *
 *Project:	Test
 *
 *Description:	Test
 *
 *Author(s):	MARTIN olivier
 *
 *Original:	November 25 1998
 *
 *$Log:	Testclass.c,v $
 * Revision 1.5  96/12/18  09:43:01  09:43:01  fladmark (I.Fladmark)
 * *** empty log message ***
 * 
 * Revision 1.3  96/03/15  02:30:22  02:30:22  fladmark ()
 * Updated with prototyping.
 * 
 *
 *Copyright(c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Nov 27 11:15:51 1998)
 *
 *********************************************************************/

#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Admin.h>

#include <DevServerP.h>
#include <TestclassP.h>
#include <Testclass.h>

/*
 * public methods
 */

static long class_initialise(long *error);
static long object_create(char *name,DevServer *ds_ptr,long *error);
static long object_initialise(Testclass ds,long *error);
static long state_handler(Testclass ds,DevCommand cmd,long *error);

static	DevMethodListEntry methods_list[] = {
   	{DevMethodClassInitialise,	class_initialise},
   	{DevMethodInitialise,		object_initialise},
  	{DevMethodCreate,		object_create},
   	{DevMethodStateHandler,		state_handler},
   };


TestclassClassRec testclassClassRec = {
   /* n_methods */        sizeof(methods_list)/sizeof(DevMethodListEntry),
   /* methods_list */     methods_list,
   };

TestclassClass testclassClass = (TestclassClass)&testclassClassRec;

/*
 * public commands
 */

static	long	dev_on();
static	long	dev_off();
static	long	dev_readvalue();
static	long	dev_write();
static	long	dev_read();
/*static long     dev_signal_config(Testclass	ds,DevVoid
*argin,DevVarStringArray *argout, long *error);*/
static  long    dev_read_sig_values(Testclass ds, DevVoid *argin, DevVarFloatArray *argout, long *error);
static  long    dev_update_config(Testclass ds, DevVoid *argin, DevVoid *argout, long *error);

static long dev_status(Testclass ds,DevVoid * argin,DevString *argout,long *error);
static long dev_state(Testclass ds,DevVoid *argin,DevShort *argout,long *error);


static	DevCommandListEntry commands_list[] = {
   	{DevOn, dev_on, D_VOID_TYPE, D_FLOAT_TYPE},
   	{DevOff, dev_off, D_VOID_TYPE, D_FLOAT_TYPE},
   	{DevGetSigConfig, dev_readvalue, D_VOID_TYPE, D_VAR_STRINGARR},
   	{DevWrite, dev_write, D_STRING_TYPE, D_VOID_TYPE},
   	{DevRead, dev_read, D_VOID_TYPE, D_STRING_TYPE},
   	{DevState, dev_state, D_VOID_TYPE, D_SHORT_TYPE},
   	{DevStatus, dev_status, D_VOID_TYPE, D_STRING_TYPE},
	{DevUpdateSigConfig, dev_update_config, D_VOID_TYPE, D_VOID_TYPE, WRITE_ACCESS},
   	{DevReadSigValues, dev_read_sig_values,D_VOID_TYPE,D_VAR_FLOATARR,READ_ACCESS},
   	/*{DevGetSigConfig, dev_signal_config, D_VOID_TYPE,D_VAR_STRINGARR,
	READ_ACCESS}*/
};

static long n_commands = sizeof(commands_list)/sizeof(DevCommandListEntry);

/*
 * reserve space for a default copy of the testclass object
 */

static TestclassRec testclassRec;
static Testclass testclass = (Testclass)&testclassRec;

/*
 * Testclass resource tables used to access the static database
 *
 */

db_resource res_object[] = {
   {"pressure_value",	D_FLOAT_TYPE, NULL},
   {"values",	D_VAR_FLOATARR, NULL},
   {"chaine",	D_STRING_TYPE, NULL},
   	};
int res_object_size = sizeof(res_object)/sizeof(db_resource);


db_resource res_class[] = {
   {"state",       D_LONG_TYPE, NULL},
   {"serialLine",   D_STRING_TYPE, NULL},
   	};
int res_class_size = sizeof(res_class)/sizeof(db_resource);


/*======================================================================
 Function:      static long class_initialise()

 Description:	routine to be called the first time a device is 
 		created which belongs to this class (or is a subclass
		thereof. This routine will be called only once.

 Arg(s) In:	none

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long class_initialise(long *error)
{

/*
 * TestclassClass is a subclass of the DevServerClass
 */

   testclassClass->devserver_class.superclass = devServerClass;
   testclassClass->devserver_class.class_name = (char*)malloc(sizeof("rgaclass")+1);
   sprintf(testclassClass->devserver_class.class_name,"rgaclass");
   testclassClass->devserver_class.class_inited = 1;
   testclassClass->devserver_class.n_commands = n_commands;
   testclassClass->devserver_class.commands_list = commands_list;

/*
 * initialise testclass with default values. these will be used
 * for every Testclass object created.
 */

   testclass->devserver.class_pointer = (DevServerClass)testclassClass;

   testclassClass->testclass_class.serialLine	= "0";

   testclass->devserver.state = DEVON;

/*
 * Interrogate the static database for default values
 *
 */

   res_class[0].resource_adr	= &(testclass->devserver.n_state);
   res_class[1].resource_adr	= &(testclassClass->testclass_class.serialLine);

   if(db_getresource("CLASS/Testclass/DEFAULT", res_class, res_class_size, error))
   {
      return(DS_NOTOK);
   }

   return(DS_OK);
}

/*======================================================================
 Function:	static long object_create()

 Description:	routine to be called on creation of a device object

 Arg(s) In:	char *name - name to be given to device

 Arg(s) Out:	DevServer *ds_ptr - pointer to created device
		long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long object_create(char *name,DevServer *ds_ptr,long *error)
{
   Testclass ds;

   ds = (Testclass)malloc(sizeof(TestclassRec));

/*
 * initialise device with default object
 */

   *(TestclassRec*)ds = *(TestclassRec*)testclass;

/*
 * finally initialise the non-default values
 */

   ds->devserver.name = (char*)malloc(strlen(name)+1);
   sprintf(ds->devserver.name,"%s",name);

   *ds_ptr = (DevServer)ds;

   return(DS_OK);
}

/*============================================================================

Function:	static long object_initialise()

Description:	routine to be called on initialisation of a device object

Arg(s) In:	Testclass ds	- object to initialise

Arg(s) Out:

		long *error     - pointer to error code, in case routine fails
=============================================================================*/
static long object_initialise(Testclass ds,long *error)
{
   int i,l;
   static float tab[3]={ 4.1 , 5.2 , 6.3 };
   static char text[]={"nothing write in "};
   char *s=&(text[0]);
   
   
   ds->testclass.pressure_value 	= 0.0;
   
   
   ds->testclass.chaine = s;
   

   ds->testclass.values.length = 0;
   ds->testclass.values.sequence=&(tab[0]);
   for(i=0;i<=2;i++){
   	
   	ds->testclass.values.sequence[i]=tab[i];
   	ds->testclass.values.length=ds->testclass.values.length +1;
   }
   
 




   res_object[0].resource_adr        = &(ds->testclass.pressure_value);
   res_object[1].resource_adr        = &(ds->testclass.values);
   res_object[2].resource_adr        = &(ds->testclass.chaine);
   
   if(db_getresource(ds->devserver.name, res_object, res_object_size, error))
   {
   	return(DS_NOTOK);
   }
   
   /* Create the multisignal object */
   
   ds->testclass.msignal_obj=NULL;
   
   
   if( ds__create (ds->devserver.name , mDSSignalClass,
                         &ds->testclass.msignal_obj, error) == DS_NOTOK){
   
  
   	return (DS_NOTOK);
   
   }
   
   if( ds__method_finder (ds->testclass.msignal_obj,
   			  DevMethodInitialise)
   			  (ds->testclass.msignal_obj,testclassClass->devserver_class.class_name,error) == DS_NOTOK ){
   	return (DS_NOTOK);
   }
   
   
   
   return(DS_OK);
}

/*======================================================================
 Function:      static long state_handler()

 Description:	this routine is reserved for checking wether the command
		requested can be executed in the present state.

 Arg(s) In:	Testclass ds - device on which command is to executed
		DevCommand cmd - command to be executed

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long state_handler(Testclass ds,DevCommand cmd,long *error)
{
   long int p_state, n_state;
   long iret = DS_OK;
/*
 * Get here the real state of the physical device
 *
 *  example:
 *  ds->devserver.state=get_state();
 */
   p_state = ds->devserver.state;

/*
 * Before checking out the state machine assume that the state doesn't
 * change i.e. new state == old state
 *
 */

   n_state = p_state;

   switch (p_state)
   {
    
   	case (DEVON) :	/* On */
   	{
   		switch (cmd)
   		{
   			/* Allowed Command(s) */

   			case (DevOff):	n_state = DEVOFF;break;
   			case (DevStatus):	break;
   			case (DevState):	break;

   			/* Forbidden command(s) */

   			case (DevOn):
   				*error = DevErr_AttemptToViolateStateMachine;
   				iret = DS_NOTOK;
   		}
   	}
   	break;
   	case (DEVOFF) :	/* Off */
   	{
   		switch (cmd)
   		{
   			/* Allowed Command(s) */

   			case (DevOn):	n_state = DEVON;break;
   			case (DevStatus):	break;
   			case (DevState):	break;

   			/* Forbidden command(s) */

   			case (DevOff):
   				*error = DevErr_AttemptToViolateStateMachine;
   				iret = DS_NOTOK;
   		}
   	}
   	break;
   	case (DEVALARM) :
   	{
   	}
   	break;
   	
   	default:
   		*error = DevErr_UnrecognisedState;
   		iret = DS_NOTOK;
   		break;
   }
   ds->devserver.n_state = n_state;

   return(iret);
}

/*============================================================================
 Function:      static long dev_on()

 Description:	 Switch on
   	
 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevFloat	*argout - Description
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):

 ============================================================================*/

static long  dev_on(Testclass ds,DevVoid *argin,DevFloat *argout,long *error)
{

#ifdef PRINT
   printf("Testclass, dev_on(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
 */

   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_off()

 Description:	 switch off
   	
 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevFloat	*argout - description
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):

 ============================================================================*/

static long  dev_off(Testclass ds,DevVoid *argin,DevFloat *argout,long *error)
{

#ifdef PRINT
   printf("Testclass, dev_off(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
 */

   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_readvalue()

 Description:	 Read an array
   	
 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevVarFloatArray	*argout - Array
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):

 ============================================================================*/

static long  dev_readvalue(Testclass ds,DevVoid *argin,DevVarStringArray *argout,long *error)
{

#ifdef PRINT
   printf("Testclass, dev_readvalue(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
 */
  /* argout->length=ds->testclass.values.length;*/
   /*	argout->sequence=ds->testclass.values.sequence;	*/
   /*argout->sequence=ds->testclass.values.sequence;*/
   
   
    if (ds__method_finder(ds->testclass.msignal_obj,
						   DevMethodReadProperties)
						   (ds->testclass.msignal_obj,
						   argout, error) == DS_NOTOK)
     {
       return(DS_NOTOK);
     }
   
   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_write()

 Description:	 Write in the chaine
   	
 Arg(s) In:	 Testclass 	ds 	- 
		 DevVarCharArray  	*argin  - wrtite the chaine
   				  
 Arg(s) Out:	 DevVoid	*argout - none
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):

 ============================================================================*/

static long  dev_write(Testclass ds,DevString *argin,DevVoid *argout,long *error)
{

#ifdef PRINT
   printf("Testclass, dev_write(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
		 
 */
   /*ds->testclass.chaine.length =argin->length;*/
   /*ds->testclass.chaine.sequence = argin->sequence;*/
   ds->testclass.chaine = *argin;
   
   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_read()

 Description:	 Read the chaines
   	
 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevVarCharArray	*argout - Read the chaines
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):

 ============================================================================*/

static long  dev_read(Testclass ds,DevVoid *argin,DevString *argout,long *error)
{

#ifdef PRINT
   printf("Testclass, dev_read(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
 */
   /*argout->length=ds->testclass.chaine.length;*/
   /*argout->sequence=ds->testclass.chaine.sequence;*/
   *argout=ds->testclass.chaine;
   
   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}
/**/
/*======================================================================
 Function:      static long dev_signal_config()

 Description:	Read the properties of all signals specified 
		for the Dosemeter.

 Arg(s) In:		Testclass ds : pointer to object
				void  *argin : no input arguments

 Arg(s) Out:	DevVarStringArray  *argout : Array of signal properties.
		long *error : pointer to error code, in case routine fails
 =======================================================================*/
/*static long dev_signal_config (Testclass ds,DevVoid *argin,DevVarStringArray *argout,long *error)
{
	*error = 0;

#ifdef PRINT
   printf("Testclass, dev_signal_config(), entered\n");
#endif

     if (ds__method_finder(ds->testclass.msignal_obj,
						   DevMethodReadProperties)
						   (ds->testclass.msignal_obj,
						   argout, error) == DS_NOTOK)
     {
       return(DS_NOTOK);
     }

  return (DS_OK);
}

*/


/*======================================================================
 Function:      static long dev_read_sig_values()

 Description:	Read the measurement and setpoint values
				for this device.
				
		[0] : pressure
		
 Arg(s) In:		Pgbalzers ds : pointer to object
				void  *argin : no input arguments

 Arg(s) Out:	DevVarFloatArray *argout : Array of device parameters.
				long *error : pointer to error code, in case routine fails
 =======================================================================*/
static long dev_read_sig_values (Testclass ds, DevVoid *argin, 
				 DevVarFloatArray  *argout, long *error)
{
	static float argout_values[]={ 1.2 , 3.4 ,  5.6 };
	long status = 0;
	char	comment[1024] ;
	int i;
	DevVarDoubleArray       read_values;
        double                  values[3];
        long                    ret;
        DevVarShortArray        alarm_state;
        DevVarStringArray       alarm_msg = {0, NULL};
	
	
	*error = 0;

#ifdef PRINT
	printf("testclass, dev_read_sig_values(), entered\n");
#endif 
	
	
	
	/* Store the value */
	/*argout_values[0] = ds->testclass.msignal_obj;*/
	/*argout_values[1] = ds->devserver.state;*/
	
	
	
	values[0] = argout_values[0];
	values[1] = argout_values[1];
	values[2] = argout_values[2];
	
	
        read_values.length   = 3;
        read_values.sequence = values;

	
	/*
	* Check for alarms on all defined signals.
	*/
	printf("Check for alarms on all defined signals.\n");

        ret = (ds__method_finder (ds->testclass.msignal_obj,
                                          DevMethodCheckAlarms)
                                          (ds->testclass.msignal_obj, 
					   &read_values,
                                           &alarm_state, error));
         if (ret == DS_NOTOK )
                   {
                   ds->devserver.state = DEVUNKNOWN;
                   return (DS_NOTOK);
                   }

        if ( ret == True )
                   {
                   ds->devserver.state = DEVALARM;
		}
                   
	
    
	
	
	/* Set the argout parameters */
	argout->length = 3;
	
	argout->sequence = &(argout_values[0]);
	
#ifdef PRINT
	printf("testclass, dev_read_sig_values(), exited\n");
#endif 

	return (DS_OK);	
	
}


/*======================================================================
 Function:      static long dev_update_config()

 Description:	Reinitialises signal resources.

 Arg(s) In:		Testclass ds : pointer to object
				void  *argin : no input arguments

 Arg(s) Out:	void  *argout : no outgoing arguments
				long *error   : pointer to error code, in case routine fails
 =======================================================================*/
static long dev_update_config(Testclass ds,DevVoid *argin,DevVoid *argout,long *error)
{
	
#ifdef PRINT
   printf("testclass, dev_update_config(), entered\n");
#endif 

   *error = 0;

  /*
   * 	Reset all signals in order to reinitialize their resources.
   */
	
	
  		 if (ds__method_finder(ds->testclass.msignal_obj,
			 			 DevMethodSignalsReset)
						 (ds->testclass.msignal_obj,
			 			 error) == DS_NOTOK)
   		{
    			 return(DS_NOTOK);
  		 }
	
   return(DS_OK);
}




/*============================================================================
 Function:      static long dev_state()

 Description:	return the state of the device

 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevShort	*argout - returned state 
		 long *error - 	pointer to error code, in case routine fails

============================================================================*/

static long dev_state(Testclass ds,DevVoid *argin,DevShort *argout,long *error)
{
   	static float sig_values[]={ 1.2 , 3.4 ,  5.6 };
	long status = 0;
	char	comment[1024] ;
	int i;
	DevVarDoubleArray       read_values;
        double                  values[3];
        long                    ret;
        DevVarShortArray        alarm_state;
        DevVarStringArray       alarm_msg = {0, NULL};
	
 
	values[0] = sig_values[0];
	values[1] = sig_values[1];
	values[2] = sig_values[2];
	
	
	read_values.length   = 3;
        read_values.sequence = values;
	/*
	* Check for alarms on all defined signals.
	*/
	printf("Check for alarms on all defined signals.\n");

        ret = (ds__method_finder (ds->testclass.msignal_obj,
                                          DevMethodCheckAlarms)
                                          (ds->testclass.msignal_obj, 
					   &read_values,
                                           &alarm_state, error));
         if (ret == DS_NOTOK )
                   {
                   ds->devserver.state = DEVUNKNOWN;
                   return (DS_NOTOK);
                   }

        if ( ret == True )
                   {
                   ds->devserver.state = DEVALARM;
		}
                   
	 

   
   *argout	= ds->devserver.state;
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_status()

 Description:	return state of the device as an ASCII string

 Arg(s) In:	 Testclass 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevString	*argout - contains string 
============================================================================*/

static long dev_status(Testclass ds,DevVoid * argin,DevString *argout,long *error)
{
   static	char	str[300];
   DevVarStringArray       alarm_msg = {0, NULL};		    
   int i;
   		    
	if(ds->devserver.state = DEVALARM){
	
		    /*
                    * read the alarm texts on signals
                    */
		   printf("Read alarms on all defined signals in Status.\n");
     		   if ( ds__method_finder(ds->testclass.msignal_obj,
				          DevMethodReadAlarms)
                                         (ds->testclass.msignal_obj, 
				          &alarm_msg, error)
                                         == DS_NOTOK )
         		{
              			return (DS_NOTOK);
         		}
	
	
        	  if ( alarm_msg.length != 0 ){
         
             		 for (i=0; i<alarm_msg.length; i++) {
             
                     		strcat (str, "Alarm : ");
                     		strcat (str, alarm_msg.sequence[i]);
              		 }
              		 
         	}
   }
   sprintf(str,"The device is :%s\n", DEVSTATES[ds->devserver.state]);
   *argout = str;
   return (DS_OK);
}

