static char RcsId[] = "$Header: /segfs/dserver/classes/vacuum/rga/src/RCS/startup.c,v 1.15 2004/06/14 12:55:41 goetz Exp $" ;
/*********************************************************************
 *
 * File:       startup.c
 *
 * Project:    Residual Gas Analizer (RGA) Device Server
 *
 * Purpose :   Startup file for the RGA device server
 *
 * Author(s):  Pablo Fajardo
 *   
 * $Date: 2004/06/14 12:55:41 $
 *
 * Copyright (c) 1992 European Synchrotron Radiation Facility,
 *                    Grenoble, France
 *
 *                   All Rights Reserved
 *
 **********************************************************************/
/*
 * $Log: startup.c,v $
 * Revision 1.15  2004/06/14 12:55:41  goetz
 * port to linux
 *
 * Revision 1.14  2001/05/29 12:55:42  chaize
 * *** empty log message ***
 *
 * Revision 1.13  99/01/18  13:33:12  13:33:12  chaize (Jm.Chaize)
 * Modify state handler for DevReadSigValues command.
 * 
 * Revision 1.12  99/01/18  13:28:59  13:28:59  chaize (Jm.Chaize)
 * correct
 * 
 * Revision 1.11  99/01/04  11:24:34  11:24:34  olivier (Olivier Martin)
 * Multi Signal Implemented
 * 
 * Revision 1.5  97/10/13  14:05:18  14:05:18  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.4  97/07/04  13:16:46  13:16:46  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.3  97/04/25  10:05:56  10:05:56  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.2  96/08/29  17:30:03  17:30:03  chaize (Jm.Chaize)
 * new commands and automatic restart implemented
 * 
 * Revision 1.1  1992/08/19  10:57:38  rey
 * Initial revision
 *
 */

/*
 */
#define DEBUG_LVL1
#define DEBUG_LVL2
#define MAX_NO_OF_DEVICES 10


#include <API.h>
#include <DevErrors.h>
#include <DevServer.h>
#include <DevServerP.h>
#ifdef __cplusplus
#include <Device.H>
#include <OICDevice.H>
#include <Serial.h>
#endif /* __cplusplus */
#include <Rga.h>
#include <RgaP.h>

#define CLASS_PREFIX "Class/"

/***********************************
 * DevMethodStartup  ( startup() )
 **************************************************************/
/*
 * Purpose: Creates, initialises and exports the devices.
 *
 * Remarks: This rutine reads from the resource file the list of
 *          all the devices that have to be exported for network
 *          access.
 *          Any other work that has to be only done once and is
 *          necessary for the startup is executed here too.
 *
 * Returns:  DS_OK      If no error
 *           DS_NOTOK   If error
 *
 * Error Codes:
 *              DevErr_InsufficientMemory
 *              DevErr_DeviceOpen
 *              DevErr_DriverNotFound
 *
 *            + errors returned by db_getdevlist() and ds_create()
 *
 **************************************************************/
long
startup(char *svc_name, long *error)
{
    char **dev_list;
    int    i, n_exported;
    unsigned int    dev_no;
#ifndef __cplusplus
    Rga    *rga_list;
    SerialLine   *ds_sl;
#else /* __cplusplus */
    OICDevice **rga_list;
    Serial **ds_sl;
#endif /* __cplusplus */
    char *parg;
    char 	svrname[80]; 
    char 	**sl_list;
    unsigned int n_sl;
    
    
    printf("[RGA startup] -> %s\n",svc_name);


    *error = 0;

/*
 * Modification with the Serial Line Class
 */


/*#ifdef _UCC*/

   parg=(char *)index(svc_name,'/');
   if(parg==NULL)
   {
      printf("can't extract personal name\n");
      *error = DevErr_UnknownInputParameter;
      return(DS_NOTOK);
   }

/*
 * create, initialise and export all serial line devices served with the same
 * personal name
 ************************************************************************
 */
   sprintf(svrname,"SerialLineds%s",parg);
   if (db_getdevlist(svrname,&sl_list,&n_sl,error))
   {
      printf("startup(): db_getdevlist() failed: %s\n",dev_error_str(*error));
      return(DS_NOTOK);
   }
   printf("following devices found in static database: \n\n");
   for (i=0;i<n_sl;i++)
   {
      printf("\t%s\n",sl_list[i]);
   }  
#ifndef __cplusplus
   ds_sl=(SerialLine *)malloc(n_sl*sizeof(SerialLine*));
#else /* __cplusplus */
   ds_sl=(Serial**)malloc(n_sl*sizeof(Serial*));
#endif /* __cplusplus */
   if(ds_sl==0)
   {
   	printf("can't allocate memory for object structures --> exit\n");
	*error = DevErr_InsufficientMemory;
   	return(DS_NOTOK);
   }
   
   for (i=0, n_exported = 0; i < n_sl; i++, n_exported++)
   {
      printf("\t\tObject %s is\n",sl_list[i]);

#ifndef __cplusplus
      if (ds__create(sl_list[i], serialLineClass, &(ds_sl[i]),error) != 0)
#else /* __cplusplus */
      ds_sl[i] = new Serial(sl_list[i], error);
      if (*error != 0)
#endif /* __cplusplus */
      {
   	  	printf("create Serial line failed: %s\n", dev_error_str(*error));
   	  	continue;
      }
      else printf("\t\t- Created\n");

      /* initialise the newly created serial lines
       *******************************************
       */
  
#ifndef __cplusplus
      if(ds__method_finder(ds_sl[i],DevMethodInitialise)
			  (ds_sl[i],error)!= 0)
      {
	  	printf("Warning !!! initialise failed : %s\n", dev_error_str(*error));
		continue;   	   
      }
	  else printf("\t\t- Initialised\n");
#endif /* __cplusplus */

      /*  now export it to the outside world 
       *******************************************
       */
 
#ifndef __cplusplus 
      if (ds__method_finder(ds_sl[i],DevMethodDevExport)
			   (sl_list[i],ds_sl[i],error) != 0)
#else /* __cplusplus */
         if (dev_export(sl_list[i],(Device*)ds_sl[i],error) != DS_OK)
#endif /* __cplusplus */
      {
   	   	printf("export failed: %s\n", dev_error_str(*error));
   	   	continue;
      }
      else printf("\t\t- Exported\n\n");
   }
/*#endif*/
/*
 * End Of Modification
 */

    if ( (rgaClass->rga_class.class_svc_name = (char *)
            malloc( strlen(svc_name) + sizeof(CLASS_PREFIX) + 1)) == 0 ){
        *error = DevErr_InsufficientMemory;
        return (DS_NOTOK);
    }
    sprintf(rgaClass->rga_class.class_svc_name, "%s%s", CLASS_PREFIX, svc_name);

    /*
     * Reads the device names
     */
   if (db_getdevlist (svc_name, &dev_list, &dev_no, error))
      return (DS_NOTOK);

#ifdef DEBUG_LVL1 
    printf (" - %d devices found:\n", dev_no);
    for ( i = 0 ; i < dev_no ; i++)
        printf("\t\t\t\t%s\n", dev_list[i]); 
#endif
#ifndef __cplusplus
   rga_list=(Rga *)malloc(sizeof(Rga *)*dev_no);
#else /* __cplusplus */
   rga_list=(OICDevice **)malloc(dev_no*sizeof(OICDevice*));
#endif /* __cplusplus */

    for (i=0; i < dev_no; i++) {
   
        /*
         * Create the object,
         */
#ifndef __cplusplus
        if (ds__create(dev_list[i], rgaClass, &(rga_list[i]),error) != 0)
#else /* __cplusplus */
        rga_list[i] = new OICDevice(dev_list[i], (DevServerClass)rgaClass, error);
        if (*error != 0)
#endif /* __cplusplus */
      {
          printf("create failed: %s\n", dev_error_str(*error));
          continue;
      }


#ifdef DEBUG_LVL2
        printf(" - object %s created\n", dev_list[i]);
#endif


        /*
         * initialise it,
         */
#ifndef __cplusplus
        if(ds__method_finder(rga_list[i],DevMethodInitialise)
                          (rga_list[i],error)!= 0)
#else
        if((rga_list[i]->MethodFinder(DevMethodInitialise))(rga_list[i]->get_ds(),error) != DS_OK)
#endif /* __cplusplus */

            printf("cannot initialise\n");

#ifdef DEBUG_LVL2
        printf(" - object %s initialised\n", dev_list[i]);
#endif

        /*
         * and export it to the outside world.
         */
#ifndef __cplusplus
        if (ds__method_finder(rga_list[i],DevMethodDevExport)
                             (dev_list[i],rga_list[i],error) != DS_OK)
#else /* __cplusplus */
        if (dev_export(dev_list[i], (Device*)rga_list[i], error) != DS_OK)
#endif /* __cplusplus */

            return(DS_NOTOK);
      
#ifdef DEBUG_LVL2
        printf(" - object %s exported\n", dev_list[i]);
#endif

    }
#ifdef DEBUG_LVL1
    printf("[RGA startup completed]\n");
#endif
}

