static char RcsId[] = "$Header: /seg/dserver/classes/vacuum/rga/src/RCS/rga_menu.c,v 1.13 2001/05/29 12:50:47 chaize Rel chaize $" ;
/*********************************************************************
 *
 * File:       rga_menu.c
 *
 * Project:    Residual Gas Analizer (RGA) Device Server
 *
 * Purpose :   Test client for the RGA Device Server
 *
 * Author(s):  Vicente Rey Bakaikoa
 *
 * $Date: 2001/05/29 12:50:47 $
 *
 * Copyright (c) 1994 European Synchrotron Radiation Facility,
 *         Grenoble, France
 *
 *           All Rights Reserved
 *
 **********************************************************************/
/*
 * $Log: rga_menu.c,v $
 * Revision 1.13  2001/05/29 12:50:47  chaize
 * add ceiling under max_noise resource
 *
 * Revision 1.12  2001/03/08  14:15:05  14:15:05  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.11  99/01/04  11:24:37  11:24:37  olivier (Olivier Martin)
 * Multi Signal Implemented
 * 
 * Revision 1.4  98/12/22  14:54:16  14:54:16  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.3  98/01/30  15:44:48  15:44:48  cardonne ()
 * *** empty log message ***
 * 
 * Revision 1.2  97/10/13  14:05:20  14:05:20  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.1  97/07/04  13:16:48  13:16:48  chaize (Jm.Chaize)
 * Initial revision
 * 
 * Revision 1.2  97/04/25  10:05:58  10:05:58  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.1  96/08/29  17:30:53  17:30:53  chaize (Jm.Chaize)
 * Initial revision
 * 
 */

#define DEBUG_LVL1
#define DEBUG_LVL2
#define REFRESH_PERIOD 1
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <DevRgaCmds.h>   
#include <DevRgaErrors.h> 
#include <Rga.h>

static void  ReadIntValue();
static void  ReadString();
static void  printerror();
static short showmenu();
static long showmenu2();

void  printoperationmode();
void  printchannelparameters();
void  printchvalues();
void  printstatus();
void  printspectrum();
void  updatespectrum(int sig);
void  printactivchan();

devserver ds;
static int first_spectrum, first_peakjmp;
DevRgaOpMode         *mode;
DevRgaChannParam     *channparam;
DevVarShortArray    shoutarr;
typedef struct  {
       long     value;
       long     cmd;
       char    *label;
} _LabelList;

typedef struct  {
       long           size;
       _LabelList    *list;
} LabelList;

_LabelList DevAuxGaugeOptionList[] = {
       {AUX_GAUGE_RESET_TO_DEFAULTS,0, "Reset to Default"},
       {AUX_GAUGE_GET_CHECK_FLAG,0,    "Get Check Flag"},
       {AUX_GAUGE_ENABLE_CHECK, 0,     "Enable Check"},
       {AUX_GAUGE_DISABLE_CHECK,0,     "Disable Check"},
       {AUX_GAUGE_READ_PRESSURE,0,     "Read Actual Pressure"},
       {AUX_GAUGE_CHECK_PRESSURE,0,    "Check Actual Pressure"},
       {AUX_GAUGE_GET_MAX_PRESSURE,0,  "Get Max. Pressure"}
};

_LabelList PeakJumpCmdList[] = {
       {1,DevFilamentState   ,"Get filament state"},
       {2,DevReadNChannels ,"Read Peak jump spectra"},
       {3,DevReadValues   ,"Switch to analog mode"},
       {4,DevGetChannelParameters   ,"Read channels parameters"},
       {5,DevSetChannel   ,"Set channels parameters"},
       {6,DevFilamentOn   ,"Switch the filament ON"},
       {7,DevFilamentOff  ,"Switch the filament OFF"},
       {8,DevReset        ,"Reset the RGA"},
};
_LabelList AnalogCmdList[] = {
       {1,DevFilamentState   ,"Get filament state"},
       {2,DevReadValues   ,"Read analog spectra"},
       {3,DevReadNChannels ,"switch to Peak jump mode"},
       {4,DevSetParam   ,"Set parameters"},
       {5,DevFilamentOn   ,"Swich the filament ON"},
       {6,DevFilamentOff  ,"Swich the filament OFF"},
       {7,DevReset        ,"Reset the RGA"},
};
LabelList devAuxGaugeOptionList[] =
       {sizeof(DevAuxGaugeOptionList)/sizeof(_LabelList),DevAuxGaugeOptionList};

static short  n_options = sizeof(DevAuxGaugeOptionList) /
                         sizeof(_LabelList);
static short  n_PeakJumpCmd = sizeof(PeakJumpCmdList) /
                         sizeof(_LabelList);
static short  n_AnalogCmd = sizeof(AnalogCmdList) /
                         sizeof(_LabelList);


_LabelList StatusList[] = {
        {DEVUNKNOWN,0,"UNKNOWN"},
        {DEVOFF,0,    "FILAMENT OFF"},
        {DEVON, 0,    "FILAMENT ON"},
        {DEVTRIPPED,0,"FILAMENT TRIP"},
        {DEVFAULT,0,  "FILAMENT FAULT"}
};

LabelList statusList[] =
       {sizeof(StatusList)/sizeof(_LabelList),StatusList};

static char *modelist[] = {
        "SCANNING OFF",
        "Leak Check",
        "Bar Chart",
        "Peak Jump",
        "Analog Peak",
        "Single Peak",
        "Fast Scan",
        "Degas"
};
static char *chanparamlist[] = {
        "None",
        "Multiplier state",
        "Channel state",
        "Channel Mass",
        "Channel Range",
        "Autorange state",
        "High alarm",
        "Low alarm"
};
static char *chanparamform[] = {
        "None",
        "Off(0) or On(1)",
        "Disable(0) or Enable(1)",
        "Mass",
        "5 to 12",
        "Off(0) or On(1)",
        "setting (0 to 99)",
        "setting (0 to 99)"
};
static char *filament_status[] = {
        "Off",
        "On",
        "Failed",
        "Externally tripped",
        "Tripped for total pressure",
        "Tripped for partial pressure",
};
static char *paramlist[] = {
        "None",
        "Multiplier state",
        "Total pressure measurement",
        "Accuracy/Speed",
        "First Mass",
        "Mass Zoom",
        "Range",
        "Auto Range"
};
static char *paramform[] = {
        "None",
        "Off(0) or On(1)",
        "Disable(0) or Enable(1)",
        "0 (very fast) to 5 (very slow)",
        "Mass",
        "8,16,32 or 64",
        "5 to 12",
        "Off(0) or On(1)"
};
static char *is_auto[] = {
        "manual",
        "Auto range"
        };
static char *is_onoff[] = {
        "Off",
        "On"
        };
static short  n_status = sizeof(StatusList) / sizeof(_LabelList);
static short  last_command = 2;

/******************
 * MAIN
 ******************/
main(argc, argv)
int   argc;
char  **argv;
{
    long            error,imported,s_index;
    short           ncmd;
    short           nopt;
    char            buffer[100];
    char            string[2048];
    char           *buf;
    FILE	    *fp;
    short           shortarray[90],i;

    DevCommand           cmd;

    DevString            stin,   stout, description;
    DevShort             shin,   shout;
    DevLong              loin,   loout;
    DevFloat             flin,   flout, masse,masse_zoom,first_mass;
    DevVarShortArray    paramarr;
    DevVarShortArray     shinarr;
    DevVarFloatArray     spectra;

    static struct timeval timeout = {15, 0};

    DevVarCmdArray        varcmdarr;
    DevArgument           argin, argout;

    /*
     * Initialize variable array arguments.
     */
    buf    = (char *)malloc(100 * sizeof(char));
    stin   = stout = string;

    shinarr.length = shoutarr.length = 0;
    shinarr.sequence = shortarray;
    shoutarr.sequence = shortarray;
    paramarr.sequence = NULL;
    first_spectrum = True;
    first_peakjmp = True;
    /*
     * Check the input command line arguments
     */
    if(argc != 2)   {
        printf("usage: %s device-name\n", argv[0]);
        exit(1);
    }

    printf("\n\n");
    printf("\t\t----------------------------------------------------\n");
    printf("\t\t  And now at your fingertips the full power of ...  \n");
    printf("\t\t               S A T E L L I T E\n");
    printf("\t\t               \"RGA  controller\"\n");
    printf("\t\t----------------------------------------------------\n");

    /*
     * Import the device
     */
    if ( dev_import(argv[1], 0, &ds, &error) !=0 ){
        printf("Can't import \"%s\"",argv[1]);
        printerror(error);
        exit(1);
    }

    if (dev_rpc_timeout (ds, CLSET_TIMEOUT, &timeout, &error) < 0)
          return(-1);
    shin=1;
    if (dev_putget(ds, DevGetDescription, &shin, D_SHORT_TYPE,
                                   &description, D_STRING_TYPE, &error) != DS_OK)
                    printerror(error);
                else
     signal(SIGALRM,updatespectrum);
     signal(SIGINT,updatespectrum);

    /*
     * Go in the main loop
     */
    while (1)   {
     signal(SIGALRM,updatespectrum);
     signal(SIGINT,updatespectrum);

     argin  = NULL;
     argout = (DevArgument) &shoutarr;
     if (dev_putget(ds, DevGetOperationMode, argin, D_VOID_TYPE,
                                  argout, D_VAR_SHORTARR, &error) != DS_OK)
                   printerror(error);
     else
     {
           mode = (DevRgaOpMode *) (shoutarr.sequence);
           printoperationmode((DevRgaOpMode *)mode);
     };
        printf("\n\t\tResidual gaz analyser %s",description);
        printf("\n\t\t--------------------------------------\n");
        switch(mode->ScanMode)
        {
           case (3):
                cmd = showmenu2(PeakJumpCmdList,n_PeakJumpCmd ,"Command: ");
                break;
           case (4):
                cmd = showmenu2(AnalogCmdList,n_AnalogCmd ,"Command: ");
                break;
           default:
                cmd = showmenu2(AnalogCmdList,n_AnalogCmd ,"Command: ");
                break;
        }
        if (cmd == 0)
        {
                alarm(0);
                dev_free(ds, &error);
                do
                {
                   printf("\tType return to quit or\n");
                   ReadString("\tenter a new device name : ", argv[1]);
                   if(*argv[1]==0)
                   {
                      printf("Bye \n");
                      exit(0);
                   }
                   imported = dev_import(argv[1], 0, &ds, &error);
                   if(imported != DS_OK)
                   {
                      printf("Can't import \"%s\"",argv[1]);
                      printerror(error);
                   }
                }
                while(imported != DS_OK);

       if (dev_rpc_timeout (ds, CLSET_TIMEOUT, &timeout, &error) < 0)
          return(-1);
       shin=1;
          if (dev_putget(ds, DevGetDescription, &shin, D_SHORT_TYPE,
                                   &description, D_STRING_TYPE, &error) != DS_OK)
                    printerror(error);
                continue;
        }
  
        /*
         * Interpret the command and call the dev_putget function
         *
         * printf("\n\t%s:\n", varcmdarr.sequence[ncmd-1].cmd_name);
         */
         printf("\n\t\t--------------------------------------\n");
 
        switch(cmd) {

            case DevGetDescription:
                printf("\t\tEnter Description Type (%d, %d or %d): ",
                 RGA_CLASS_DESCRIPTION, RGA_DEVICE_DESCRIPTION, RGA_MAX_MASS);
                ReadIntValue("", &shin);
                argin  = (DevArgument) &shin;
                argout = (DevArgument) &stout;
                if (dev_putget(ds, cmd, argin, D_SHORT_TYPE,
                                   argout, D_STRING_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tDescription = \"%s\"",stout);
                break;

            case DevState:
                argin  = NULL;
                argout = (DevArgument) &loout;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                   argout, D_LONG_TYPE, &error) != DS_OK){
                    printerror(error);
                    loout = DEVUNKNOWN;
                }
                printstatus(loout);
                break;

             case DevFilamentState:
                argin  = NULL;
                argout = (DevArgument) &shoutarr;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                  argout, D_VAR_SHORTARR, &error) != DS_OK)
                    printerror(error);
                else
                printf("\t\tFilament %d is %s\n",shoutarr.sequence[0]
                                            ,DEVSTATES[shoutarr.sequence[1]]);
                
                break;

           case DevReset:
                alarm(0);
                argin  = NULL;
                argout = NULL;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tDevice Reset\n");
                break;

            case DevSendCommand:
                stin = buffer;
                ReadString("\t\tEnter Command = ", stin);
                argin  = (DevArgument) &stin;
                argout = (DevArgument) &stout;
                if (dev_putget(ds, cmd, argin, D_STRING_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tCommand Ok\n");
                break;

            case DevSendRequest:
                stin = buffer;
                ReadString("\t\tEnter Request = ", stin);
                argin  = (DevArgument) &stin;
                argout = (DevArgument) &stout;
                if (dev_putget(ds, cmd, argin, D_STRING_TYPE,
                                  argout, D_STRING_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tAnswer = \"%s\"", stout);
                break;

            case DevGetOperationMode:
                argin  = NULL;
                argout = (DevArgument) &shoutarr;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                  argout, D_VAR_SHORTARR, &error) != DS_OK)
                    printerror(error);
                else
                {
                    mode = (DevRgaOpMode *) (shoutarr.sequence);
                    printoperationmode((DevRgaOpMode *)mode);
                }
                break;

            case DevGetChannelParameters:
                argin  = NULL;
                argout = (DevArgument) &paramarr;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                              argout, D_VAR_SHORTARR, &error) != DS_OK)
                    printerror(error);
                else
                {
                    channparam = (DevRgaChannParam *) (paramarr.sequence);
                    printchannelparameters((DevRgaChannParam *)channparam);
                }
                break;

            case DevOn:
                argin  = NULL;
                argout = NULL;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tFilament switched on\n");
                break;
             case DevFilamentOn:
                ReadIntValue("\t\tEnter Filament Number: ", &shin);
                argin  = (DevArgument) &shin;
                argout = NULL;
                if (dev_putget(ds, cmd, argin, D_SHORT_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tFilament %d switched on\n", shin);
                break;

            case DevOff:
            case DevFilamentOff:
                alarm(0);
                argin  = NULL;
                argout = NULL;
                if (dev_putget(ds, cmd, argin, D_VOID_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tFilament switched off\n");
                break;

            case DevAuxGaugeName:
                stin = buffer;
                ReadString("\t\tNew Aux. Gauge = ", stin);
                argin  = (DevArgument) &stin;
                argout = (DevArgument) &stout;
                if (dev_putget(ds, cmd, argin, D_STRING_TYPE,
                                  argout, D_STRING_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tAux. Gauge Name = \"%s\"", stout);
                break;
            case DevReadNChannels:
                if(mode->ScanMode!=3)
                {
                   alarm(0);
                   shin = 3;
                   argin  = (DevArgument) &shin;
                   argout = NULL;
                   if (dev_putget(ds, DevSetMode, argin, D_SHORT_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                       printerror(error);
                   else
                      printf("\t\tMode %s selected\n", modelist[shin]);
                }
                argin  = NULL;
                argout = (DevArgument) &paramarr;
                if (dev_putget(ds, DevGetChannelParameters, argin, D_VOID_TYPE,
                              argout, D_VAR_SHORTARR, &error) != DS_OK)
                    printerror(error);
                else
                {
                    channparam = (DevRgaChannParam *) (paramarr.sequence);
                }
                spectra.sequence=NULL;
                if (dev_putget(ds, cmd, NULL, D_VOID_TYPE,
                                  &spectra, D_VAR_FLOATARR, &error) != DS_OK)
                    printerror(error);
                  if (dev_putget(ds, DevIndicator, NULL, D_VOID_TYPE,
                                  &s_index, D_SHORT_TYPE, &error) != DS_OK)
                    printerror(error);
               else
                {
                    printactivchan(channparam,s_index,&spectra);
                    dev_xdrfree(D_VAR_FLOATARR,&spectra,&error);
                    alarm(REFRESH_PERIOD);
                }
                break;
            case DevReadValues:
                if(mode->ScanMode!=4)
                {
                   alarm(0);
                   shin = 4;
                   argin  = (DevArgument) &shin;
                   argout = NULL;
                   if (dev_putget(ds, DevSetMode, argin, D_SHORT_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                       printerror(error);
                   else
                      printf("\t\tMode %s selected\n", modelist[shin]);
                }
                spectra.sequence=NULL;
                if (dev_putget(ds, cmd, NULL, D_VOID_TYPE,
                                  &spectra, D_VAR_FLOATARR, &error) != DS_OK)
                    printerror(error);
                 if (dev_putget(ds, DevIndicator, NULL, D_VOID_TYPE,
                                  &s_index, D_SHORT_TYPE, &error) != DS_OK)
                    printerror(error);
               else
                {
                    printspectrum(spectra,s_index,mode);
                   dev_xdrfree(D_VAR_FLOATARR,&spectra,&error);
                }
                alarm(REFRESH_PERIOD);
                break;
            case DevSetMode:
		printf("\n");
		for(i=0;i<8;i++)
		  printf("\t\t%d - %s\n",i,modelist[i]);
                ReadIntValue("\n\t\tEnter mode Number: ", &shin);
                argin  = (DevArgument) &shin;
                argout = NULL;
                if (dev_putget(ds, cmd, argin, D_SHORT_TYPE,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                    printf("\t\tMode %s selected\n", modelist[shin]);
               break;


            case DevSetParam:
		for(i=1;i<8;i++)
		  printf("\t\t%d - %s\n",i,paramlist[i]);
                 ReadIntValue("\t\tEnter parameter Number: ", &shortarray[0]);
                 printf("\t\tEnter %s (%s)",paramlist[shortarray[0]],
                                          paramform[shortarray[0]]);
                 ReadIntValue(": ", &shortarray[1]);
                shinarr.sequence=shortarray;
                shinarr.length=2;
                argout = NULL;
                if (dev_putget(ds, cmd, &shinarr, D_VAR_SHORTARR,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                else
                   printf("\t\t%s set to %d (%s)\n",
                                                       paramlist[shortarray[0]],
                                                       shortarray[1],
                                                       paramform[shortarray[0]]);
                break;
            case DevSetChannel:
                ReadIntValue("\t\tEnter channel Number (1 to 12): ", &shortarray[1]);
		printf("\n");
		for(i=1;i<7;i++)
		 printf("\t\t%d - %s\n",i,chanparamlist[i]);
                ReadIntValue("\t\tEnter parameter Number: ", &shortarray[0]);
		printf("\n\t\t Enter %s : (%s)",
			       chanparamlist[shortarray[0]],
			       chanparamform[shortarray[0]]);
                ReadIntValue(" ? : ", &shortarray[2]);
                shinarr.sequence=shortarray;
                shinarr.length=3;
                argout = NULL;
                if (dev_putget(ds, cmd, &shinarr, D_VAR_SHORTARR,
                                    argout, D_VOID_TYPE, &error) != DS_OK)
                    printerror(error);
                
                    printf("\t\tparameter %d channel %d set to %d\n",
                                                       shortarray[0],
                                                       shortarray[1],
                                                       shortarray[2]);
                break;

            case DevAuxGaugeControl:
                printf("\n\n\t\t\t Auxiliary Gauge Actions");
                printf("\n\t\t\t-------------------------\n");
 
                if ((nopt = showmenu2(DevAuxGaugeOptionList, n_options, "Option")) == 0)
                    break;

                shin = DevAuxGaugeOptionList[nopt - 1].value;

                argin  = (DevArgument) &shin;
                argout = (DevArgument) &flout;

                if (dev_putget(ds, cmd, argin, D_SHORT_TYPE,
                                   argout, D_FLOAT_TYPE, &error) != DS_OK)
                    printerror(error);
                else{
                    switch(shin){
                        case AUX_GAUGE_GET_CHECK_FLAG:
                            printf("\t\tCheck Flag = %d", (int) flout);
                            break;
                        case AUX_GAUGE_READ_PRESSURE:
                            printf("\t\tPressure = %G", flout);
                            break;
                        case AUX_GAUGE_GET_MAX_PRESSURE:
                            printf("\t\tMax. Pressure = %G", flout);
                            break;
                        default:
                            printf("\t\tOK");
                    }
                }
                break;

            default:
                printf("%s: internal error cmd = %d\n",argv[0],cmd);
                return(1);
       }
    }
}

/********************************
 * Read a parameter of type short
 ********************************/
static void
ReadIntValue(prompt, param)

char  *prompt;
short *param;
{
    static char line[80];
    char *ptline;
    int value;
    ptline = line;
    do {
        ReadString(prompt, ptline);
    } while (strlen(line) == 0);
     value = atoi(line);
    *param = (short)value; 
}

/********************************
 * Read a parameter of type string
 ********************************/
static void
ReadString(prompt, param)

char  *prompt;
char  *param;
{
    char *ret;
    printf("%s", prompt);
/*    while((ret=gets(param))==NULL); */
      fgets(param, 3, stdin);
      rewind(stdin);
}

/************************
 * Print an error message
 ************************/
static void
printerror(error)
long     error;
{
    char *err_msg,
         *err_str;

    if ((err_str = dev_error_str(error)) == NULL)
        err_msg = "<no error description>";
    else
        err_msg = err_str;

    printf("\t\t\t%s\n", err_msg);

    if (err_str != NULL)
        free(err_str);

}

/************************
 * Print status description
 ************************/
void
printstatus(status)

long     status;
{
    short i;

    for(i=0 ; i < n_status ; i++){
        if(status == StatusList[i].value){
            printf("\n\t\tStatus %d: %s\n",status,StatusList[i].label);
       return;
   }
    }
    printf("\t\tStatus raro\n");
}

/*****************
 * Show menu
 *****************/
static long
showmenu2(list, n, prompt)
_LabelList  *list;
long        n;
char       *prompt;
{
    short   i, j;

    for (i = 1 ; i <= (n + 1)/2 ; i++){
        printf("\t %2d) %-24s", i, list[i-1].label);
        if ((j = i + (n + 1)/2) <= n)
            printf("\t %2d) %-24s", j, list[j-1].label);
        printf("\n");
    }
    printf("\n\t\t\t   0) QUIT or change controller\n");

    i=(-1);
    while( i < 0 || i > n ){
    printf("\n\t\t%s -> ", prompt);
        ReadIntValue( "", &i);
    }
    if(i==0) return(0);
    return(list[i-1].cmd);
}

/*****************
 * Show menu
 *****************/
static short
showmenu(array, prompt)
DevVarCmdArray  *array;
char     *prompt;
{
    short   com;
    short   i, j, n;

    n = array->length;

    for (i = 1 ; i <= (n + 1)/2 ; i++){
        printf("\t %2d) %-24s", i, array->sequence[i-1].cmd_name);
        if ((j = i + (n + 1)/2) <= n)
            printf("\t %2d) %-24s", j, array->sequence[j-1].cmd_name);
        printf("\n");
    }
    printf("\n\t\t\t   0) QUIT\n");

    com = last_command;
    do {
        printf("\n\t\t%s", prompt);
        ReadIntValue( "", &com);
    } while( com < 0 || com > n );
    return(last_command = com);
}
/*****************
 * Print Spectrum
 *****************/
void
printspectrum(spectrum,s_index,pt)
DevVarFloatArray spectrum;
short s_index;
DevRgaOpMode  *pt;
{
    float masse, first_mass, mass_zoom;
    FILE *fp;
    short i;
    long scan;
    printf("Pressure  :");
    fp=fopen("/tmp/rga_spectrum","w");
    switch(pt->ScanMode)
    {
     case 4:
        first_mass = pt->Parameter.Analog.FirstMass;
        mass_zoom = pt->Parameter.Analog.MassZoom;
        for(i=0;i<spectrum.length;i++)
        {
                    printf("%.1e  ",i,spectrum.sequence[i]);
                    masse = first_mass - 0.5 +(float)( i * mass_zoom )/256;
                    if(s_index == i) scan = 1;
                    else scan = 0;
                    if(fp != NULL) fprintf(fp,"%.2f	%.2e	%d\n",masse
                                                                     ,spectrum.sequence[i]
                                                                     ,scan);
        }
        break;
     default:
        for(i=0;i<spectrum.length;i++)
        {
                    printf("%.1e  ",i,spectrum.sequence[i]);
                    if(s_index == i) scan = 1;
                    else scan = 0;
                   if(fp != NULL) fprintf(fp,"%.2f	%.2e	%d\n",(float)i
                                                                     , spectrum.sequence[i]
                                                                     , scan);
        }
        break;
  	;
    }
    fclose(fp);
    if(first_spectrum)
    {
       system("dadi -file /tmp/rga_spectrum -dim 2 -nc 2 -y2 2 -header \"Residual gaz analyser spectrum\">/dev/null 2>/dev/null&");
       first_spectrum=False;
    }
    printf("\n");
    fflush(stdout);
}
/*****************
 * Update Spectrum in file
 *****************/
void updatespectrum(int sig)
{
    float masse, first_mass, mass_zoom;
    static DevVarFloatArray spectrum;
    DevVarShortArray modearr;
    static short modearray[20], divider;
    static float floattab[255];
    long error,scan;
    short nchan;
    FILE *fp;
    short i, s_index;
    spectrum.sequence=floattab;
    modearr.sequence=modearray;
    if(divider > 10) divider = 0;
    if (dev_putget(ds, DevGetOperationMode, NULL, D_VOID_TYPE,
                                  &modearr, D_VAR_SHORTARR, &error) != DS_OK)
          printerror(error);
    else
    {
          mode = (DevRgaOpMode *) (modearr.sequence);
    }
    if (dev_putget(ds, DevIndicator, NULL, D_VOID_TYPE,
                                  &s_index, D_SHORT_TYPE, &error) != DS_OK)
                    printerror(error);
    switch(mode->ScanMode)
    {
     case 4:
        if(divider == 0)
        {
        if (dev_putget(ds, DevReadValues, NULL, D_VOID_TYPE,
                                  &spectrum, D_VAR_FLOATARR, &error) != DS_OK)
        {
	       for(i=0;i<spectrum.length;i++)
               {
               spectrum.sequence[i] = 0.1 * (float)pow(10.0,-(double)(mode->Parameter.Analog.Range));
               }
               divider--;
         }
        }
        first_mass = mode->Parameter.Analog.FirstMass;
        mass_zoom = mode->Parameter.Analog.MassZoom;
        fp=fopen("/tmp/rga_spectrum","w");
        for(i=0;i<spectrum.length;i++)
        {
                     if(s_index == i) scan = 1;
                    else scan = 0;
                   masse = first_mass - 0.5 +(float)( i * mass_zoom )/256;
                    if(fp != NULL) fprintf(fp,"%.2f	%.2e	%d\n",masse,spectrum.sequence[i]
                                                                      ,scan);
        }
       fclose(fp);
        break;
     case 3:
        if(divider == 0)
        {
        if (dev_putget(ds, DevReadNChannels, NULL, D_VOID_TYPE,
                                  &spectrum, D_VAR_FLOATARR, &error) != DS_OK)
         {
	       for(i=0;i<spectrum.length;i++)
               {
               spectrum.sequence[i] = 0.1 * (float)pow(10.0,-(double)(mode->Parameter.Analog.Range));
               }
               divider--;
        }
       }
        fp=fopen("/tmp/rga_spectrum","w");

        for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
        {
                    if(s_index == nchan) scan = 1;
                    else scan = 0;
	     if(channparam->Channel[nchan].Parameter.number[1]==True)
	     {
             if(fp != NULL) fprintf(fp,"%5d	%.2e	%d\n",channparam->Channel[nchan].Parameter.number[2],
                                                        spectrum.sequence[nchan],scan);
	     }
	}
        fclose(fp);
        break;
     default:
        break;
  	;
    }
    divider++;
/*    dev_xdrfree(D_VAR_FLOATARR,&spectrum,&error); */
    signal(SIGALRM,updatespectrum);
    alarm(REFRESH_PERIOD);
}
/*****************
 * Print Operation Mode
 *****************/
void
printoperationmode(pt)
DevRgaOpMode  *pt;
{
    int   p;

    printf("\n\t\t  %s mode\n", modelist[pt->ScanMode]);
    printf("\t\t  Multiplier Gain      = %d\n", pt->MultiplierGain);
    printf("\t\t  Total Pressure Trip:  %s ,", is_onoff[pt->TotalPressureTrip]);
    printf("\tPartial Pressure Trip: %s\n", is_onoff[pt->PartialPressureTrip]);

    switch(pt->ScanMode){
        case 1:
            printf("\t\t  Multiplier = %d\n", pt->Parameter.LeakCheck.Multiplier);
            printf("\t\t  Speed      = %d\n", pt->Parameter.LeakCheck.Speed);
            printf("\t\t  Mass       = %d\n", pt->Parameter.LeakCheck.Mass);
            printf("\t\t  MassTune   = %d\n", pt->Parameter.LeakCheck.MassTune);
            printf("\t\t  Range      = %d\n", pt->Parameter.LeakCheck.Range);
            printf("\t\t  AutoRange  = %d\n", pt->Parameter.LeakCheck.AutoRange);
            printf("\t\t  Range      = %d (%s)\n", pt->Parameter.LeakCheck.Range,
            					is_auto[pt->Parameter.LeakCheck.AutoRange]);
            printf("\t\t  High Alarm = %d\n", pt->Parameter.LeakCheck.HighAlarm);
            printf("\t\t  Low Alarm  = %d\n", pt->Parameter.LeakCheck.LowAlarm);
            printf("\t\t  Audio      = %d\n", pt->Parameter.LeakCheck.Audio);
            break;

        case 2:
            printf("\t\t  Multiplier     = %d\n", pt->Parameter.BarChart.Multiplier);
            printf("\t\t  Total Pressure = %d\n", pt->Parameter.BarChart.TotalPressure);
            printf("\t\t  Speed          = %d\n", pt->Parameter.BarChart.Speed);
            printf("\t\t  First Mass     = %d\n", pt->Parameter.BarChart.FirstMass);
            printf("\t\t  Last Mass      = %d\n", pt->Parameter.BarChart.LastMass);
            printf("\t\t  Range          = %d (%s)\n", pt->Parameter.BarChart.Range,
            					is_auto[pt->Parameter.BarChart.AutoRange]);
           break;

        case 3:
            printf("\t\t  Total Pressure %s\n", is_onoff[pt->Parameter.PeakJump.TotalPressure]);
            printf("\t\t  Speed          = %d\n", pt->Parameter.PeakJump.Speed);
            break;

        case 4:
            printf("\t\t  Multiplier     %s\n", is_onoff[pt->Parameter.Analog.Multiplier]);
            printf("\t\t  Total Pressure %s\n", is_onoff[pt->Parameter.Analog.TotalPressure]);
            printf("\t\t  Speed          = %d\n", pt->Parameter.Analog.Speed);
            printf("\t\t  FirstMass      = %d\n", pt->Parameter.Analog.FirstMass);
            printf("\t\t  MassZoom       = %d\n", pt->Parameter.Analog.MassZoom);
            printf("\t\t  Range          = %d (%s)\n", pt->Parameter.Analog.Range,
            					is_auto[pt->Parameter.Analog.AutoRange]);
            break;

        case 0: case 5: case 6: case 7:
        default:
   ;
    }
}

/*****************
 * Print Channel Parameters
 *****************/
void
printchannelparameters(pt)
DevRgaChannParam  *pt;
{
    short   nchan;

/*    printf("\n%-10s:", "Channel No");
   for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
         printf("%6d", nchan + 1);
    printf("\n");
*/

    printf("%-10s:", "Alarm Stat");
    for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
        printf("%6d", pt->Channel[nchan].AlarmStatus);
    printf("\n");

    printchvalues("Enable", 1, pt);
    printchvalues("Multipl.", 0, pt);
    printchvalues("Mass", 2, pt);
    printchvalues("Range", 3, pt);
    printchvalues("AutoRange", 4, pt);
/*    printf("(Mass Offset)\n"); */
    printchvalues("High Alarm", 5, pt);
/*    printf("(Dwell Time)\n"); */
    printchvalues("Low Alarm", 6, pt);
/*    printf("(Settle Time)\n");*/
}

/*****************
 * Print Ch Values
 *****************/
void
printchvalues(msg, npar, pt)

char  *msg;
short  npar;
DevRgaChannParam  *pt;
{
    short nchan;

    printf("%-10s:", msg);
        for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
             printf("%6d", pt->Channel[nchan].Parameter.number[npar]);
    printf("\n");
}
/*****************
 * Print activ channel
 *****************/
void
printactivchan(pt,s_index,pressure)
DevRgaChannParam  *pt;
short s_index;
DevVarFloatArray *pressure;
{
    short nchan;
    long scan;
    FILE *fp;
    fp=fopen("/tmp/rga_spectrum","w");

    printf("%-10s:", "mass");
        for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
	     if(pt->Channel[nchan].Parameter.number[1]==True)
	     {
             printf("%5d    ", pt->Channel[nchan].Parameter.number[2]);
	     }
    printf("\n");
    printf("%-10s:", "pressure");
        for (nchan = 0 ; nchan < RGA_NUM_OF_CHANNELS-1 ; nchan++)
        {
             if(nchan == s_index) scan = 1;
             else scan = 0;
	     if(pt->Channel[nchan].Parameter.number[1]==True)
	     {
             printf(" %.1e ", pressure->sequence[nchan]);
             if(fp != NULL) fprintf(fp,"%5d	%.2e	%d\n",pt->Channel[nchan].Parameter.number[2],
                                                        pressure->sequence[nchan],scan);
	     }
	}
    fclose(fp);
    if(first_spectrum)
    {
       system("dadi -file /tmp/rga_spectrum -dim 2 -nc 2 -y2 2  -header \"Residual gaz analyser spectrum\">/dev/null 2>/dev/null&");
       first_spectrum=False;
    }
    printf("\n");
}
