/* $Header: /segfs/dserver/classes/vacuum/rga/include/RCS/RgaP.h,v 1.18 2004/06/14 12:56:54 goetz Exp $ */
/*********************************************************************
 *
 * File:       RgaP.h
 *
 * Project:    Residual Gas Analizer (RGA) Device Server
 *
 * Purpose :   Private include file for the RGA device server.
 *
 * Author(s):  Pablo Fajardo
 *   
 * $Date: 2004/06/14 12:56:54 $
 *
 * Copyright (c) 1992 European Synchrotron Radiation Facility,
 *                    Grenoble, France
 *
 *                   All Rights Reserved
 *
 **********************************************************************/
/*
 * $Log: RgaP.h,v $
 * Revision 1.18  2004/06/14 12:56:54  goetz
 * port to linux
 *
 * Revision 1.17  2001/05/29 12:50:54  chaize
 * add ceiling under max_noise resource
 *
 * Revision 1.16  2001/03/08  14:15:10  14:15:10  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.15  00/12/01  11:46:17  11:46:17  pons ()
 * *** empty log message ***
 * 
 * Revision 1.14  2000/09/28  13:53:52  13:53:52  olivier (Olivier Martin)
 * *** empty log message ***
 * 
 * Revision 1.13  99/01/18  13:33:17  13:33:17  chaize (Jm.Chaize)
 * Modify state handler for DevReadSigValues command.
 * 
 * Revision 1.12  99/01/18  13:29:00  13:29:00  chaize (Jm.Chaize)
 * correct
 * 
 * Revision 1.11  99/01/04  11:24:38  11:24:38  olivier (Olivier Martin)
 * Multi Signal Implemented
 * 
 * Revision 1.6  98/12/23  15:14:42  15:14:42  olivier (Olivier Martin)
 * *** empty log message ***
 * 
 * Revision 1.5  97/10/13  14:05:21  14:05:21  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.4  97/07/04  13:16:48  13:16:48  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.3  97/04/25  10:05:58  10:05:58  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.2  96/08/29  17:31:07  17:31:07  chaize (Jm.Chaize)
 * new commands and automatic restart implemented
 * 
 * Revision 1.1  95/10/25  14:28:19  14:28:19  chaize (Jean Michel Chaize)
 * Initial revision
 * 
 * Revision 1.1  1992/08/19  10:57:57  rey
 * Initial revision
 *
 */

#ifndef _RGAP_h
#define _RGAP_h

#include <DSSignalP.h>
#include<MDSSignal.h>
#include<MDSSignalP.h>
#ifndef __cplusplus
#include <SerialLine.h>
#include <SerialLineP.h>
#endif /* __cplusplus */

/*
 * As a subclass of the rgaClass, include RgaClass private definitions
 */

typedef struct _RgaClassPart {
            DevString  description;
            DevFloat   aux_max_pressure;
            char      *class_svc_name;
        } RgaClassPart;

typedef struct _RgaClassRec {
            DevServerClassPart devserver_class;
            RgaClassPart       rga_class;
        } RgaClassRec;


typedef struct _RgaPart {
            DevString           description;
            DevString           serial_driver_name;
	    devserver		serial_line_handle; /* Handle to the serial line device */
            DevShort            max_mass;
            DevFloat            max_noise;
            DevString           default_aux_vacuum_gauge;
            DevBoolean          default_aux_gauge_check;
            char               *actual_aux_vacuum_gauge;
            char                actual_aux_gauge_check;
            devserver           aux_PG_dserver;
            char                aux_dserver_flag;
            double              aux_pressure;
            /*int                 serial_path;/**/
            DevRgaOpMode        OpMode;
            DevRgaChannParam    ChParam;
            DevShort            FilamentUsed;
            DevShort		Multiplier;
            DevShort		MultiplierGain;
            DevShort		MultiplierVolt;
	    DevShort		MultiplierBase;
            DevShort		TotalPressure;
            DevShort		Accuracy;
            DevShort		FirstMass;
            DevShort		MassZoom;
            DevShort		Range;
            DevShort		AutoRange;
            DevShort            AutoScanMode;
            DevVarShortArray    ChanMasses;
            DevVarShortArray    ChanAutoRange;
            DevVarShortArray    ChanMultiplier;
            time_t 		when_last_cmd;
            short		reset_timeout;
            short		new_scan;
	    short		ppas_flag;
	    MDSSignal		msignal_obj;
	    
        } RgaPart;

typedef struct _RgaRec
   {
     DevServerPart    devserver;
     RgaPart          rga;
   } RgaRec;

extern RgaClassRec rgaClassRec;

#endif



