/* $Header: /segfs/dserver/classes/vacuum/rga/include/RCS/Rga.h,v 1.18 2004/06/14 12:56:54 goetz Exp $ */
/*********************************************************************
 *
 * File:       Rga.h
 *
 * Project:    Residual Gas Analizer (RGA) Device Server
 *
 * Purpose :   Public include file for the RGA device server.
 *
 * Author(s):  Vicente Rey Bakaikoa 
 *   
 * $Date: 2004/06/14 12:56:54 $
 *
 * Copyright (c) 1992 European Synchrotron Radiation Facility,
 *                    Grenoble, France
 *
 *                   All Rights Reserved
 *
 **********************************************************************/
/*
 * $Log: Rga.h,v $
 * Revision 1.18  2004/06/14 12:56:54  goetz
 * port to linux
 *
 * Revision 1.17  2001/05/29 12:51:39  chaize
 * add ceiling under max_noise resource
 *
 * Revision 1.16  2001/03/08  14:15:12  14:15:12  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.15  00/12/01  11:46:11  11:46:11  pons ()
 * *** empty log message ***
 * 
 * Revision 1.14  2000/09/28  13:53:50  13:53:50  olivier (Olivier Martin)
 * *** empty log message ***
 * 
 * Revision 1.13  99/01/18  13:33:22  13:33:22  chaize (Jm.Chaize)
 * Modify state handler for DevReadSigValues command.
 * 
 * Revision 1.12  99/01/18  13:29:01  13:29:01  chaize (Jm.Chaize)
 * correct
 * 
 * Revision 1.11  99/01/04  11:24:39  11:24:39  olivier (Olivier Martin)
 * Multi Signal Implemented
 * 
 * Revision 1.5  97/10/13  14:05:22  14:05:22  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.4  97/07/04  13:16:49  13:16:49  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.3  97/04/25  10:05:59  10:05:59  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.2  96/08/29  17:31:27  17:31:27  chaize (Jm.Chaize)
 * new commands and automatic restart implemented
 * 
 * Revision 1.1  95/10/25  14:28:19  14:28:19  chaize (Jean Michel Chaize)
 * Initial revision
 * 
 */
#ifndef _RGA_h
#define _RGA_h

#define RGA_CLASS_NAME "RgaClass"

/*
 * Scan modes.
 */
#define NO_SCAN_MODE     0
#define LEAK_CHECK_MODE  1
#define BAR_CHART_MODE   2
#define PEAK_JUMP_MODE   3
#define ANALOG_MODE      4
#define SINGLE_PEAK_MODE 5
#define FAST_SCAN_MODE   6
#define DEGAS_MODE       7
#define CONTROL_MODE	 9
/*
 * Parameters Meaning.
 */
#define CHAN_MULTIPLIER 1
#define CHAN_ENABLED    2
#define CHAN_MASS       3
#define CHAN_RANGE      4
#define CHAN_AUTORANGE  5
#define CHAN_HIGHALARM  6
#define CHAN_LOWALARM   7

/*
 * Allowed commands and requests.
 */
#define RGA_COMMANDS "CGMPSTVR"               /* Allowed commands */
#define RGA_REQUESTS "aBcCdefgimopstv"         /* Allowed requests */

/*
 * For DevGetDescription
 */
#define RGA_CLASS_DESCRIPTION   0
#define RGA_DEVICE_DESCRIPTION  1
#define RGA_MAX_MASS            2

/*
 * Options for gauge control
 */
#define AUX_GAUGE_RESET_TO_DEFAULTS  1
#define AUX_GAUGE_GET_CHECK_FLAG     2
#define AUX_GAUGE_ENABLE_CHECK       3
#define AUX_GAUGE_DISABLE_CHECK      4
#define AUX_GAUGE_READ_PRESSURE      5
#define AUX_GAUGE_CHECK_PRESSURE     6
#define AUX_GAUGE_GET_MAX_PRESSURE   7

/*
 * Definition and variable types for Rga.
 */
#define RGA_NUM_OF_MODE_PARAMETERS    11
#define RGA_NUM_OF_CHANNELS           12
#define RGA_NUM_OF_CHANNEL_PARAMETERS  7

typedef struct DevRgaOpMode {
	short ScanMode;
	short MultiplierGain;
	short TotalPressureTrip;
	short PartialPressureTrip;
	union {
		struct {
			short Multiplier;
			short _not_used;
			short Speed;
			short Mass;
			short MassTune;
			short Range;
			short AutoRange;
			short HighAlarm;
			short LowAlarm;
			short Audio;
		} LeakCheck;
		struct {
			short Multiplier;
			short TotalPressure;
			short Speed;
			short FirstMass;
			short LastMass;
			short Range;
			short AutoRange;
		} BarChart;
		struct {
			short _not_used;
			short TotalPressure;
			short Speed;
		} PeakJump;
		struct {
			short Multiplier;
			short TotalPressure;
			short Speed;
			short FirstMass;
			short MassZoom;
			short Range;
			short AutoRange;
		} Analog;
		short number[RGA_NUM_OF_MODE_PARAMETERS];
	} Parameter;
} DevRgaOpMode;

typedef struct DevRgaChannParam {
	struct {
		short AlarmStatus;
		union {
			struct {
				short Multiplier;
				short Enable;
				short Mass;
				short Range;
				short AutoRange;
				short HighAlarm;
				short LowAlarm;
			} PeakJump;
			struct {
				short Multiplier;
				short Enable;
				short Mass;
				short Range;
				short MassOffset;
				short DwellTime;
				short SettleTime;
			} FastScan;
			short number[RGA_NUM_OF_CHANNEL_PARAMETERS];
		} Parameter;
	} Channel[RGA_NUM_OF_CHANNELS];
} DevRgaChannParam;

typedef struct _RgaClassRec *RgaClass;
typedef struct _RgaRec      *Rga;

extern   RgaClass     rgaClass;
/*
extern   Rga          rga;
 */

#endif 

