/*static char RcsId[] = "$Header:" */ 
/*********************************************************************
 *
 * File:         DevRgaErrors.h
 *
 * Project:      Rga Device Server
 *
 * Description:  Error definitions for the  Rga Device Server
 *    
 * Author(s):    Vicente Rey Bakaikoa & Pablo Fajardo
 *
 * Original:     October 5 1993
 *
 * Copyright(c) 1993 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * $Log:	DevRgaErrors.h,v $
 * Revision 1.12  00/12/01  11:46:06  11:46:06  pons (Jean-Luc Pons)
 * *** empty log message ***
 * 
 * Revision 1.11  99/01/04  11:24:40  11:24:40  olivier (Olivier Martin)
 * Multi Signal Implemented
 * 
 * Revision 1.4  98/12/23  15:49:21  15:49:21  olivier (Olivier Martin)
 * *** empty log message ***
 * 
 * Revision 1.3  97/10/13  14:05:23  14:05:23  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 1.2  96/08/29  17:31:30  17:31:30  chaize (Jm.Chaize)
 * new commands and automatic restart implemented
 * 
 * Revision 1.1  95/10/25  14:28:18  14:28:18  chaize (Jean Michel Chaize)
 * Initial revision
 * 
 * Revision 1.1  1994/01/28  13:20:22  rey
 * Initial revision
 *
 *********************************************************************/

#ifndef _RGAERRORS_H
#define _RGAERRORS_H

#ifndef DevRgaBase
#include <ExpDsNumbers.h>                /* Expg dserver base numbers */
#endif

/*
 * General errors:
 */
#define DevErr_RgaNoError                 DevRgaBase
#define DevErr_DriverNotFound             DevRgaBase +  1
#define DevErr_FilamentStateError         DevRgaBase +  2
#define DevErr_NotAcknowledged            DevRgaBase +  3
#define DevErr_AcknowledgementFailed      DevRgaBase +  4
#define DevErr_StringTooLong              DevRgaBase +  5
#define DevErr_AuxiliaryGaugeOff          DevRgaBase +  6
#define DevErr_AuxPressureTooHigh         DevRgaBase +  7
#define DevErr_AuxiliaryDeviceNotValid    DevRgaBase +  8

#endif 

