static char RcsId[] = "$Header: /segfs/dserver/classes++/motor/oregon/src/RCS/startup.cpp,v 1.3 2000/03/16 23:04:52 goetz Exp $";

//+**********************************************************************
//
// File:	startup.C
//
// Project:	Device Servers in C++
//
// Description:	Startup file for the OregonMaxe class implemented in C++
//		
//
// Author(s):	Emmanuel Taurel, Andy Gotz
//
// Original:	January 1997
//
// $Revision: 1.3 $
//
// $Date: 2000/03/16 23:04:52 $
//
// $Author: goetz $
//
// $Log: startup.cpp,v $
// Revision 1.3  2000/03/16 23:04:52  goetz
// *** empty log message ***
//
// Revision 1.2  1999/05/19 15:13:04  goetz
// replaced MAX_DEVICES with 8
//
// Revision 1.1  1999/04/13 19:27:44  goetz
// Initial revision
//
// Revision 1.1  1998/07/23  14:13:08  goetz
// Initial revision
//
//
//+**********************************************************************
		
#include <API.h>
#include <DevSignal.h>

#include <DevServer.h> /* will include Device.H */
#include <Oms.h>
#include <OregonMaxe.h>

OregonMaxe *device_ds[8];
unsigned int n_devices;

extern long debug_flag;

long startup(char *svr_name, long *error)
{
   char **dev_list;
   unsigned int i;
   long status;

   /*debug_flag = 0xffffffff;*/

   printf ("startup() program for OregonMaxe++ (server name = %s)\n",svr_name);
//
// install signal handler
//

//   ds__signal(SIGINT,catchSig,error);
//   ds__signal(SIGQUIT,catchSig,error);
//   ds__signal(SIGHUP,catchSig,error);

//
// get the list of device name to be served from the static database
//

   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
        printf("startup(): db_getdevlist() failed, error %d\n",*error);
        return(DS_NOTOK);
   }
   printf("following devices found in static database: \n\n");
   for (i=0;i<n_devices;i++)
   {
       	printf("\t%s\n",dev_list[i]);
   }

//
// now loop round creating and exporting the devices
//

   for (i=0; i<n_devices; i++)
   {
      	device_ds[i] = new OregonMaxe(dev_list[i],error);
	if ((device_ds[i] == 0) || (*error != 0))
	{
		printf("Error when trying to create %s device\n",dev_list[i]);
	}

//
// export the device onto the network
//

      	status = dev_export((char*)device_ds[i]->name,(Device*)device_ds[i],(long*)error);

      	printf("startup() dev_export() returned %d (error = %d)\n",status,*error);
   }

   printf("leaving startup and all's OK\n");

   return(DS_OK);
}
