static char RcsId[] = "@(#)$Header$";
/*+*******************************************************************

 File       :   motor_bench.c

 Project    :   StepperMotor Device Servers

 Description:   A simple program to bench the motor device servers commands
		used by SPEC. 

 Author(s)  :   Andy Goetz

 Original   :   September 1999

 $Revision$
 $Date$

 $Author$

 $Log$

 *-*******************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevStates.h>
#include <Maxe.h>
#include <maxe_xdr.h>

/*+**********************************************************************
 Function   :   main()

 Description:   main to bench motor device servers.

***********************************************************************-*/


int main(unsigned int argc,char **argv)
{

	devserver ps[3];
	char dev_name[3][32];
	char cmd_string[80];
	long imported[3];
	long readwrite = 0, error, motor=0, idev=0;
	long cmd, status, iasynch, i, j, k, ndev, total;
	struct timeval first, second, lapsed, tout;
        struct timezone tzp;
	float flapsed;
	long mul_pos_in[8], mot_state[8];
	float mul_pos_out[8];
	DevVarLongArray mul_pos_vla, mot_state_vla;
	DevVarFloatArray mul_pos_vfa;
	DevMulMove mul_move;
	DevMotorLong mot_long;
	DevMotorFloat mot_float;
  
        /*debug_flag = (DEBUG_ON_OFF | DBG_ASYNCH); */

	switch (argc)	{
		case 1:
			printf("enter device name [\"exp/oms/1\"]? ");
			if(NULL==gets(dev_name[0]) || '\0'==dev_name[0][0])
				strcpy(dev_name[0],"sr/agps/1");
			ndev = 1;
			break;
		case 2:
			strcpy(dev_name[0],argv[1]);
			ndev = 1;
			break;

		case 3:
			strcpy(dev_name[0],argv[1]);
			sscanf(argv[2],"%d",&motor);
			ndev = 1;
			
			break;

		case 4:
			strcpy(dev_name[0],argv[1]);
			strcpy(dev_name[1], argv[2]);
			strcpy(dev_name[2], argv[3]);
			ndev = 3;

			break;

		default:
			printf("usage: asynch_menu [device name]\n");
			exit(1);
	}

	for (k=0; k<ndev; k++)
	{
		imported[k] = dev_import(dev_name[k],readwrite,&ps[k],&error);

		printf("dev_import(%s) returned %d\n",dev_name[k],imported[k]);

		if (imported[k] != 0) 
		{
			printf("%s",dev_error_str(error));
			exit(1);
		}
	}

	while (1)
	{
	   printf("Select one of the following asynchronous commands : \n\n");
	   printf("0. Quit\n");
	   printf("1. ReadState   2. ReadPosition 3. Move\n");

	   printf("cmd ? ");
/*
 * to get around the strange effects of scanf() wait for something read 
 */
	   for( ; gets(cmd_string) == (char *)0 ; );
	   status = sscanf(cmd_string,"%d",&cmd);

	   switch (cmd) {

	   case (1) : 
		      flapsed = 0.0;
		      for (i=0;i<100;i++) {
		      gettimeofday(&first,&tzp);
		      mot_state_vla.length = 2;
		      mot_state_vla.sequence = mot_state;
	              status = dev_putget(ps[idev],DevReadState,
	                                       &motor,D_LONG_TYPE,
	                                       &mot_state_vla,D_VAR_LONGARR,
	                                       &error);
		      gettimeofday(&second,&tzp);
	              if (status < 0) dev_printerror_no(SEND,NULL,error); 
                      if (first.tv_usec > second.tv_usec)
                      {
                         second.tv_usec += 1000000;
                         second.tv_sec--;
                      }
                      lapsed.tv_usec = second.tv_usec - first.tv_usec;
                      lapsed.tv_sec = second.tv_sec - first.tv_sec;
		      flapsed += (float)lapsed.tv_sec + (float)lapsed.tv_usec/1000000.0;
		      }
		      printf("DevReadState(%d) state[0] %d state[1] %d\n",motor, mot_state[0], mot_state[1]);
	              printf("DevReadState returned %d , average elapsed time  %6.6f ms\n",
	                        status,flapsed*10.);
	              break;


	   case (2) : 
		      flapsed = 0.0;
		      for (i=0;i<100;i++) {
                      gettimeofday(&first,&tzp);
		      for (j=0; j<8; j++) mul_pos_in[j] = j;
		      mul_pos_vla.length = (u_int)8;
		      mul_pos_vla.sequence = mul_pos_in;
		      mul_pos_vfa.length = (u_int)8;
		      mul_pos_vfa.sequence = mul_pos_out;
                      status = dev_putget(ps[idev],DevReadMulPos,
                                               &mul_pos_vla,D_VAR_LONGARR,
                                               &mul_pos_vfa,D_VAR_FLOATARR,
                                               &error);
                      gettimeofday(&second,&tzp);
		      if (status < 0) dev_printerror_no(SEND,NULL,error);
                      if (first.tv_usec > second.tv_usec)                                             {
                         second.tv_usec += 1000000;
                         second.tv_sec--;
                      }
                      lapsed.tv_usec = second.tv_usec - first.tv_usec;
                      lapsed.tv_sec = second.tv_sec - first.tv_sec;
                      flapsed += (float)lapsed.tv_sec + (float)lapsed.tv_usec/1000000.0;
		      }
		      printf("DevReadMulPos(%d) position %6.0f \n",
			      motor,mul_pos_out[motor]);
                      printf("DevReadMulPos returned %d , average elapsed time  %6.6f ms\n",
                                status,flapsed*10.); 
                      break;


	   case (3) : 
		      flapsed = 0.0;
		      for (i=0;i<100;i++) {
                      gettimeofday(&first,&tzp);
/*
 * set all motors to NO ACTION
 */
		      for (j=0; j<8; j++) {
			mul_move.action[j] = NO_ACTION;
			mul_move.position[j] = 0.0;
		      }
/*
 * move motor four +1 relative step
 */
		      mul_move.action[motor] = RELATIVE_MOVE;
		      mul_move.position[motor] = 1.0;
                      status = dev_putget(ps[idev],DevMoveMultiple,
                                               &mul_move,D_MULMOVE_TYPE,
                                               NULL,D_VOID_TYPE,
                                               &error);
/*
 * poll motor until it has stopped
 */
		      do {
		        mot_state_vla.length = 2;
		        mot_state_vla.sequence = mot_state;
	              	status = dev_putget(ps[idev],DevReadState,
	                                       &motor,D_LONG_TYPE,
	                                       &mot_state_vla,D_VAR_LONGARR,
	                                       &error);
			printf("mot_state[0] %d ",mot_state[0]);
		      } while (mot_state[0] != DEVON);
		      printf("\n");
                      gettimeofday(&second,&tzp);
		      if (status < 0) dev_printerror_no(SEND,NULL,error);
                      if (first.tv_usec > second.tv_usec)                                             {
                         second.tv_usec += 1000000;
                         second.tv_sec--;
                      }
                      lapsed.tv_usec = second.tv_usec - first.tv_usec;
                      lapsed.tv_sec = second.tv_sec - first.tv_sec;
                      flapsed += (float)lapsed.tv_sec + (float)lapsed.tv_usec/1000000.0;
		      }
                      printf("DevMoveMultiple returned %d , average elapsed time  %6.6f ms\n",
                                status,flapsed*10.); 
		      break;


	   case (0) :
		      exit(0);

	   default : break;
	   }
	}
	return 0;
}

