//static char RcsId[] = "$Header: /segfs/dserver/classes++/motor/oregon/oms/include/RCS/Oms.h,v 1.2 2000/03/16 23:03:27 goetz Exp $";

//+**********************************************************************
//
// File:	Oms.h
//
// Project:	Fast stepping stepper motors in VME and/or PC/104
//
// Description:	public include file containing definitions and declarations 
//		for implementing the Oms class in C++.
//
// Author(s):	Andy Gotz
//
// Original:	March 1999
//
// $Revision: 1.2 $
//
// $Date: 2000/03/16 23:03:27 $
//
// $Author: goetz $
//
// $Log: Oms.h,v $
// Revision 1.2  2000/03/16 23:03:27  goetz
// multiple commandsnow treat only nb_axes of channels[]
//
// Revision 1.1  1999/04/13 19:28:38  goetz
// Initial revision
//
//
//+**********************************************************************

#ifndef _OMS_H
#define _OMS_H
		
// global constants

#define OMS_MAX_MOTORS 		8
#define OMS_MAX_BUF		127
#define OMS_MAX_VELOCITY 	1044000
#define	OMS_MAX_ACCELERATION	8000000
#define OMS_ACC_LINEAR		1
#define OMS_ACC_COSINE		2
#define OMS_ACC_PARABOLIC 	3
#define OMS_LIMIT		4
#define	OMS_HOME		5
#define OMS_DONE		6
#define OMS_MOT_NOTHING		7
#define	OMS_MOT_NOT_MOVING	8
#define OMS_MOT_FINISHED	9

#define OMS_ABSOLUTE_MOVE	1
#define OMS_RELATIVE_MOVE	2
#define OMS_REFERENCE_MOVE	3
#define OMS_CONTINUOUS_MOVE	4

#define OMS_POSITIVE		1
#define OMS_NEGATIVE		2

class Oms {

//
// private members
// 

private :

   char		*device_name;
   short	device_fd;

   long MotorToAxis (long motor, char *axis, long *error);
   long EndOfMovement (short *todo, long nb_axes, long channel[], short moment[], short endofmove[], long *error);
//
// protected members
//

protected:

//
// public members
//
public:

   Oms (char *name, long *error);
   ~Oms ();

   long ResetCard (long *error);
   long InitialiseCard (long *error);
   long SoftLimits (long motor, long *error);
   long InitialiseMotor (long motor, long velocity, long firststeprate,
                         long acceleration, short mode, short power,
                         long *error);
   long AutoPower (long motor, short autopower, long *error);
   long SetVelocity (long motor, long velocity, long *error);
   long SetFirstStepRate (long motor, long firststeprate, long *error);
   long SetAcceleration (long motor, long acceleration, long *error);
   long SetAccelerationMode (long motor, long mode, long *error);
   long LoadPosition (long motor, long position, long *error);
   long MoveRelative (long motor, long position, long backlash, long direction, long *error);
   long MoveAbsolute (long motor, long position, long backlash, long direction, long *error);
   long MoveReference (long motor, long value, long *error);
   long MoveContinuous (long motor, long direction, long speed, long *error);
   long MoveMultiple (short move_type, long nb_axes, long channels[], 
                      short action[], long position[], 
                      long direction[], long backlash[], long *error);
   long Abort (long motor, long *error);
   long ReadStatus (long motor, long *status, long *error);
   long ReadMultipleStatus (long nb_axes, long channels[], long status[], long *error);
   long ReadPosition (long motor, long *position, long *error);
   long ReadMultiplePositions (long nb_axes, long channels[], long positions[], long *error);
   
//
// Some very simple member functions to get object private data
//

// inline short get_nada(void) {return(nada);}
};

#endif /* _OMS_H */
