#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

void
usage (void)
{
	printf ("Usage: ./readport 0x220\n");
	exit (1);
}

int
main (int argc, char **argv)
{
	int fd;
	long int port;
	char *endptr;
	unsigned char val;

	if (argc != 2)
		usage();
	port = strtol(*++argv, &endptr, 0);
	if (*endptr || port < 0 || port > 65535)
		usage();

	fd = open("/dev/port", O_RDONLY);
	if (fd < 0) {
		perror("open");
		return 1;
	}
	if (lseek(fd, port, SEEK_SET) != port) {
		perror("lseek");
		return 1;
	}
	if (read(fd, &val, 1) != 1) {
		perror("read");
		return 1;
	}
	printf ("%04x = %02x\n", port, val);
	close(fd);
	return 0;
}
