/***********************************************************************
 *  Device driver public header file for PC58/VME58/PC68
 * --------------------------------------------------------------------
 *  This code is based on a driver for the PC58, written by
 *     Tony Denault
 *     Institute for Astronomy, University of Hawaii
 *
 *  Modified for VME58 and PC68 by richard@sleepie.demon.co.uk
 ***********************************************************************
 */

#ifndef _LINUX_OMSLIB_H
#define _LINUX_OMSLIB_H

/*----------------------------------------------------------------------
 * Define a few convenient datatypes
 *---------------------------------------------------------------------*/

#ifndef __KERNEL__
typedef unsigned char u8;
typedef unsigned long u32;
#endif

/*----------------------------------------------------------------------
 * OMS_req_t, the common structure used to pass ioctl requests in to,
 * and get responses from, the driver.  A pointer to this structure
 * is passed as the third parameter in the ioctl call.
 *---------------------------------------------------------------------*/

typedef struct {
	unsigned char axes;	/* Bit 0 for axis X, 1 for Y, etc	*/
	unsigned char signal;	/* Signal number to wake caller		*/
	int timeout;		/* Timeout in seconds (0 for default)	*/
	char *cmdstr;		/* ASCII command to issue to OMS board	*/
	int cmdlen;		/* Length of cmdstr			*/

	char *rspstr;		/* Buffer for any response string	*/
	int rsplen;		/* Length of response buffer		*/
	unsigned char f_done;	/* Current done flags			*/
	unsigned char f_slip;	/* Current slip flags			*/
	unsigned char f_limit;	/* Current limit flags			*/
	unsigned char f_cmderr;	/* Current command error flags		*/
	unsigned char f_io_lo;	/* Current state of i/o bits 0-7	*/
	unsigned char f_io_hi;	/* Current state of i/o bits 8-13	*/
	long positions[8];	/* Current axes positions		*/
	long *mem_params;	/* Pointer to 8*12 entry array for
				 * shared memory axis parameters	*/
} OMS_req_t, *OMS_req_ptr;

/*----------------------------------------------------------------------
 * Error codes returned from the driver; can be mapped to a string via
 * oms_strerror().  Some of these are generated by the library, after
 * it has analysed driver error returns.
 *---------------------------------------------------------------------*/

#define OMS_ERR_NONE		0

#define OMS_ERR_BASE_VALUE	0x10000

#define OMS_ERR_INV_FUN		OMS_ERR_BASE_VALUE + 1
#define OMS_ERR_MULTI_AXES	OMS_ERR_BASE_VALUE + 2
#define OMS_ERR_AXIS_BUSY	OMS_ERR_BASE_VALUE + 3
#define OMS_ERR_NIF		OMS_ERR_BASE_VALUE + 4
#define OMS_ERR_TIMEOUT		OMS_ERR_BASE_VALUE + 5
#define OMS_ERR_NO_AXES		OMS_ERR_BASE_VALUE + 6
#define OMS_ERR_BAD_AXES	OMS_ERR_BASE_VALUE + 7
#define OMS_ERR_DONE_PENDING	OMS_ERR_BASE_VALUE + 8
#define OMS_ERR_RESP_OVERLOAD	OMS_ERR_BASE_VALUE + 9
#define OMS_ERR_TOO_LONG	OMS_ERR_BASE_VALUE + 10
#define OMS_ERR_POS_DATA	OMS_ERR_BASE_VALUE + 11
#define OMS_ERR_NO_SPACE	OMS_ERR_BASE_VALUE + 12
#define OMS_ERR_INT_QUEUED	OMS_ERR_BASE_VALUE + 13
#define OMS_ERR_BAD_RESP	OMS_ERR_BASE_VALUE + 14
#define OMS_ERR_SLIP		OMS_ERR_BASE_VALUE + 15
#define OMS_ERR_LIMIT		OMS_ERR_BASE_VALUE + 16
#define OMS_ERR_CMDERR		OMS_ERR_BASE_VALUE + 17

#define OMS_ERR_RANGE		17	/* Must match last error no used */

/*----------------------------------------------------------------------
 * Driver request types - used as the request parameter in the ioctl call
 *---------------------------------------------------------------------*/

#define OMS_RESET		1	/* Full hard reset of board and
					 * driver			   */
#define OMS_REG_HANDLER		2	/* Register an board error handler */
#define OMS_READ_INTS		3	/* Read current interrupt flags    */
#define OMS_ACK_INTS		4	/* Read and acjknowledge int flags */
#define OMS_READ_POSITIONS	5	/* Read positions of all 8 axes    */
#define OMS_READ_AXES_INFO	6	/* Read axis info from shared mem. */
#define OMS_CMD_BLK		7	/* Issue a cmnd and block til done */
#define OMS_CMD_SIG		8	/* Issue cmd, signal when done     */
#define OMS_CMD_SIG_ACK		9	/* Issue cmd, sig & ack when done  */
#define OMS_CMD_RET		10	/* Issue cmd and return		   */
#define OMS_CMD_RESP		11	/* Issue cmd, wait for response    */
#define OMS_DUMP		12	/* Dump driver info to console     */
#define OMS_DEBUG		13	/* Set drvier debug level          */
#define OMS_CMD_FORCE		14	/* Like OMS_CMD_BLK, but will work
					 * even with interrupts queued or
					 * pending (for error recovery)    */
#if 0
#define OMS_LOG_IO		15	/* Request the I/O log buffer	   */
#endif

/*----------------------------------------------------------------------
 * Axis data offsets in OMS_req_t.positions[] array
 *---------------------------------------------------------------------*/

#define OMS_X_POS		0x00
#define OMS_Y_POS		0x01
#define OMS_Z_POS		0x02
#define OMS_T_POS		0x03
#define OMS_U_POS		0x04
#define OMS_V_POS		0x05
#define OMS_R_POS		0x06
#define OMS_S_POS		0x07

/*----------------------------------------------------------------------
 * Axis masks, for specifing relevant axes in ioctl commands
 *---------------------------------------------------------------------*/

#define OMS_X_AXIS		0x01
#define OMS_Y_AXIS		0x02
#define OMS_Z_AXIS		0x04
#define OMS_T_AXIS		0x08
#define OMS_U_AXIS		0x10
#define OMS_V_AXIS		0x20
#define OMS_R_AXIS		0x40
#define OMS_S_AXIS		0x80


/*----------------------------------------------------------------------
 * Prototypes for library functions
 *---------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
extern char * oms_strerror(int n);
extern int oms_cmd_blk(int fd, int axis, char *cmd, int timeout);
extern int oms_read_positions(int fd, long *ppos);
extern int oms_stop_axis(int fd, int axis, int timeout);
extern int oms_check_limit(int fd, int axis);
extern int oms_cmd_resp (int fd, char *cmdstr, char *rspstr, int maxlen);
extern void oms_log(char *fmt, ...);
extern char oms_axis_name(int axis);
extern int oms_ack_all_ints(int fd, int axis);
#ifdef __cplusplus
	}
#endif /* __cplusplus */



#endif /*  _LINUX_OMSLIB_H  */

