/*----------------------------------------------------------------------
 * Function: oms_interrupt()
 *
 * This is the interrupt handler for all boards.  The 'dev_id' parameter
 * identifies the relevant OMS_table[] entry.  Basically we just grab the
 * current interrupt status from the board and wake up or signal
 * processes as appropriate.
 *---------------------------------------------------------------------*/

static void
oms_interrupt (int irq, void *dev_id, struct pt_regs *regs)
{
	u8 status;
	u8 control;
	OMS_table_ptr tp = (OMS_table_ptr)dev_id;
	int i;
	u8 mask;

/*
 * WAITING FOR INOPUT FROM OMS BEFORE IMPLEMENTING THIS
 *
 * save the control register in case a limit has been hit and it needs
 * to be changed - andy 11apr99
 *
 *	control = read_oms_reg(tp, OMS_CNTL_REG);
 */

	while ((status = read_oms_reg(tp, OMS_STATUS_REG)) & 0x80)
	{
		if (oms_debug > 3)
			printk("%s: Got IRQ 0x%02x, status 0x%02x", me, irq, status);

#ifdef VME58
		if ((status & (OMS_STATUS_REG_int_req_status |
				OMS_STATUS_REG_encoder_slip  |
				OMS_STATUS_REG_overtravel    |
				OMS_STATUS_REG_done          |
				OMS_STATUS_REG_command_error)) ==
					OMS_STATUS_REG_int_req_status)
		{
			u8 d1;

			if (oms_debug > 0)
				printk ("%s: I/O bits 0 or 1 (assumed)", me);
			/* Hmm, what do we do with these? */
			 	d1 = read_oms_reg(tp, OMS_DIO_LO_REG);  /* Unlatch interrupt */
				if (oms_debug > 3) printk (" value : %02x",d1);

		}
#endif

		if (status & OMS_STATUS_REG_command_error)
		{
			printk (KERN_ALERT "%s: Command error\n", me);
			tp->i_cmderr = 0xff;		/* Flag on all axes	*/
		}
		if ((status & OMS_STATUS_REG_encoder_slip))
		{
			u8 d1;

			if (oms_debug > 3) printk (" - Slip");
 			d1 = read_oms_reg(tp, OMS_SLIP_REG);
			if (oms_debug > 3) printk (" value : %02x",d1);
			tp->i_slip |= d1;
			/*tp->i_slip = 0xff; - andy */
		}
		if ((status & OMS_STATUS_REG_overtravel))
		{
			u8 d1;

			if (oms_debug > 3) printk (" - Limit");
 			d1 = read_oms_reg(tp, OMS_LIMIT_REG);
			if (oms_debug > 3) printk (" value : %02x",d1);
			tp->i_limit |= d1;
			/*tp->i_limit = 0xff; - andy */
/* 
 * WAITING FOR INOPUT FROM OMS BEFORE IMPLEMENTING THIS
 *
 * disable limit interrupt, wait for host to drive off limit and
 * tell driver to reenable limit interrupt - andy 11apr99
 *
 *			control &= ~OMS_CNTL_REG_limit_register_int_enb;
 *			write_oms_reg(tp, OMS_CNTL_REG, control);
 */

		}
		if ((status & OMS_STATUS_REG_done))
		{
			u8 d1, d2;

			if (oms_debug > 3) printk (" - Done");

			d1 = read_oms_reg(tp, OMS_DONE_REG);
			d2 = read_oms_reg(tp, OMS_DONE_REG);

			if ((d1 & d2) && oms_debug > 2)
				printk("%s: Duplicate DONEs: %02x, %02x\n",
						me, d1, d2);
			tp->i_done |= d1 | d2;
		}
#ifdef PC68
		/* Handle char I/O */
		if (status & OMS_STATUS_REG_rxbuf_full)
		{
			OMS_dram_ptr dp = tp->address;
			int c = read_oms_reg(tp, OMS_DATA_REG);
	
			if (oms_debug > 3)
				printk (" - RxFull");
			dp->inbuf[dp->input_put_index] = c;
			dp->input_put_index = (dp->input_put_index + 1) %
					OMS_BUF_SIZE;
			if (oms_debug > 5)
				printk("%s: Read char '%c' (%02x)\n", me,
					(c >= ' ' && c < 0x7f) ? c : '.', c);
		}
		if (status & OMS_STATUS_REG_txbuf_empty)
		{
			OMS_dram_ptr dp = tp->address;
			int c = dp->outbuf[dp->output_get_index];
	
			if (oms_debug > 3)
				printk (" - TxEmpty");
			if (dp->output_get_index != dp->output_put_index)
			{
				write_oms_reg(tp, OMS_DATA_REG, c);
				dp->output_get_index =
				     (dp->output_get_index + 1) % OMS_BUF_SIZE;
				if (oms_debug > 5)
					printk("%s: Wrote char '%c' (%02x)\n",
					    me, (c >= ' ' && c < 0x7f) ?
						c : '.', c);
				if (dp->output_get_index ==
						dp->output_put_index)
				{
					write_oms_reg (tp, OMS_CNTL_REG,
					    read_oms_reg(tp, OMS_CNTL_REG) &
						~OMS_CNTL_REG_txbuf_empty_enb);
				}
			}
		}
#endif
		if (oms_debug > 3)
			printk("\n");
	}

	/* Wake any processes waiting on OMS_CMD_BLK */

	wake_up_interruptible(&tp->blk_waitq);

	/* Signal any processes waiting on OMS_CMD_SIG or OMS_CMD_SIG_ACK */

	/* Signal any processes who have registered error handlers */

	/* Now any axes which are BUSY_PENDING for which we have queued
	 * a DONE interrupt, can be set not busy and we can clear the
	 * DONE flag.  This happens if a command is killed while a DONE
	 * is outstanding.
	 */
	for (i = 0, mask = 1; i < 8; i++, mask <<= 1)
	{
		if ((tp->i_done & mask) && tp->busy[i] == OMS_BUSY_PENDING)
		{
			tp->busy[i] = 0;
			tp->i_done ^= mask;
		}
	}
}
