 
/*--------------------------
**  include files
**--------------------------
*/
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>

#include "omslib.h" 

static char *OMS_Error_Strings[] = {
	"No error!",
	"Invalid function",
	"Multiple axes specified",
	"Axis is busy",
	"Non-implemented function",
	"Timeout",
	"No axes specified",
	"Bad axis specification",
	"DONE interrupt pending",
	"Response overload",
	"String too long",
	"Bad position data from board",
	"Insufficient output buffer space",
	"Interrupt queued",
};


char *
oms_strerror(int error)
{
	if( error >= OMS_ERR_BASE_VALUE &&
			error <= OMS_ERR_BASE_VALUE + OMS_ERR_RANGE)
		return OMS_Error_Strings[error - OMS_ERR_BASE_VALUE];
	else
		return NULL;
}

