/*********************************************************************
 FILE:         Vpapaxe.h
 PROJECT:      Device Servers
 PURPOSE:      public include for the VpapaxeClass
 AUTHOR(s):    Timo Mett\"al\"a
 ORIGINAL:     May 1992

 Copyright (c) 1992 by European Synchrotron Radiation Facility,
                      Grenoble, France

 *********************************************************************/

#ifndef _VPAPAXE_H
#define _VPAPAXE_H

#define  VPAP_FAULT    3000
#define  ENC_FAULT     3001
#define  STEPS         1
#define  MM            2
#define  MICRON        3 
#define  ROTATION      4
#define  DEGREE        5
#define  ARCSEC        6
#define  USERUNIT      20 

#define  SERVO_ON 0
#define  SERVO_OFF -1

#include <Vpap.h>
#include <IncEnco.h>
#include <AbsEnco.h>
#include <Varoc.h>
#include <Relay.h>

/* defines the class record pointer that is used to create Device instances */ 

typedef  struct _VpapaxeClassRec *VpapaxeClass;


/* defines instance record pointer of the vpapaxe device that is used to
   initialise new instances */

typedef struct _VpapaxeRec *Vpapaxe;

extern VpapaxeClass vpapaxeClass;
extern Vpapaxe vpapaxe;

#endif




