/*********************************************************************

 File:		vpap.h

 Project:	Device Servers

 Description:

 Author(s);	Timo Mettala

 Original:	16 November 1990



 Copyright (c) 1992 by European Synchrotron Radiation Facility,
                      Grenoble, France

		       All Rights Reserved

 *********************************************************************/

/*  $Log:	Vpap.h,v $
 * Revision 4.26  99/12/27  09:02:35  09:02:35  domingue (Mc.Dominguez)
 * correct heavy;DevLock
 * 
 * Revision 4.25  1999/11/03  15:54:21  domingue
 * correct MAX24 bug;heavy time_start corrected
 *
 * Revision 4.24  99/08/27  15:36:15  15:36:15  domingue (Mc.Dominguez)
 * setstepmode res; ReadHardStatus chip vers; accel new
 * 
 * Revision 4.23  99/05/12  09:56:42  09:56:42  domingue (Mc.Dominguez)
 * _os9_getime for heavy motors when start
 * 
 * Revision 4.22  99/02/25  17:54:29  17:54:29  domingue (Mc.Dominguez)
 * remoce message in ReadStatus
 * 
 * Revision 4.21  99/02/25  17:47:28  17:47:28  domingue (Mc.Dominguez)
 * ReadStatus gives userbit&alar&status
 * 
 * Revision 4.20  99/02/23  09:18:47  09:18:47  domingue (Mc.Dominguez)
 * acceleration new algo
 * 
 * Revision 4.19  98/12/03  17:01:34  17:01:34  domingue (Mc.Dominguez)
 * MAX24_unsigned;read_state when motion starts,DevReadHard;rounds fsr on low
 * 
 * Revision 4.18  1998/05/11  14:07:18  domingue
 * backlash+DevMoveReference status + init_enable + 4 CC133
 *
 * Revision 4.17  1998/01/12  15:11:29  domingue
 * correct movereference pb
 *
 * Revision 4.16  1997/12/18  15:26:36  domingue
 * link with api6.x
 *
 * Revision 4.15  1997/06/12  07:28:32  domingue
 * all error messages
 *
 * Revision 4.14  1997/06/09  07:28:00  domingue
 * message correction - state_handler: comment message
 *
 * Revision 4.13  1997/05/27  12:57:00  domingue
 * add TIME_C compil option, correct DevMoveReference, min-max detection
 *
 * Revision 4.12  1996/08/19  10:43:43  domingue
 * add errno messages, suppress tsleep in ReadPos
 *
 * Revision 4.11  96/08/05  13:11:07  13:11:07  domingue (Mc.Dominguez)
 * FORTRAN added
 * 
 * Revision 4.10  96/04/26  11:22:03  11:22:03  domingue (Mc.Dominguez)
 * add print and debug messages
 * 
 * Revision 4.9  96/03/29  11:29:29  11:29:29  domingue (Mc.Dominguez)
 * *** empty log message ***
 * 
 * Revision 4.8  96/03/27  10:11:18  10:11:18  domingue (MC Dominguez)
 * Add position saving in NVRAM
 * 
 * Revision 4.7  96/03/15  10:05:41  10:05:41  domingue (MC Dominguez)
 * errno + MAXBACKLASH set to 40000
 * 
 * Revision 4.6  96/03/11  14:30:48  14:30:48  domingue (MC Dominguez)
 * tsleep between write and read
 * 
 * Revision 4.5  96/01/16  16:52:02  16:52:02  domingue (MC Dominguez)
 * tsleep correction (when time too small)
 * 
 * Revision 4.4  96/01/03  13:25:36  13:25:36  domingue (MC Dominguez)
 * tsleep modification
 * 
 * Revision 4.3  95/10/31  10:21:03  10:21:03  domingue (MC Dominguez)
 * *** empty log message ***
 * 
 * Revision 4.1  95/04/04  10:16:13  10:16:13  domingue (MC Dominguez)
 * ucc version
 * 
 * Revision 4.0  95/03/30  10:51:19  10:51:19  domingue (M.C Dominguez)
 * ucc version
 * 
 * Revision 3.23  1994/03/25  15:45:42  mettala
 *  Parameter and position readout not from the chip when backlash correction also with CY550
 *
 * Revision 3.22  1993/12/16  16:08:35  mettala
 * readstate improved: uses tsleep
 *
 * Revision 3.21  1993/12/14  21:48:56  mettala
 * Final tuning of readstate...
 *
 * Revision 3.20  1993/12/14  18:19:43  mettala
 * Readstate improved again
 *
 * Revision 3.19  1993/12/14  10:30:41  mettala
 * Flush the output buffer before readpos
 *
 * Revision 3.18  93/11/29  10:09:57  10:09:57  mettala (Timo Mettala)
 * Improved state read when backlash correction
 * 
 * Revision 3.17  93/10/01  17:20:23  17:20:23  mettala (Timo Mettala)
 *  Changed startmemory write sm->vpap.last_cmd
 * 
 * Revision 3.16  93/07/13  13:25:48  13:25:48  mettala (Timo Mettala)
 * Inserted missing DevTrigMotion commanfd
 * 
 * Revision 3.15  1993/06/21  14:59:36  mettala
 * *** empty log message ***
 *
 * Revision 3.14  93/06/14  15:13:24  15:13:24  mettala (Timo Mettala)
 * New commands, backlash correction, estimated position, CY550 support
 * 
 * Revision 3.14  93/06/14  13:31:41  13:31:41  mettala (Timo Mettala)
 * New commands, backlash correction, estimated position, CY550 support
 * 
 * Revision 3.8  92/09/03  15:04:04  15:04:04  mettala (Timo Mettala)
 * New commands for Maxe
 * 
 * Revision 3.7  92/09/03  14:16:01  14:16:01  mettala (Timo Mettala)
 * New commands for Maxe class, ported to margaux
 * 
 * Revision 3.6  92/07/24  09:27:37  09:27:37  mettala (Timo Mettala)
 * Corrected bug in object_initialise
 * 
 * Revision 3.4  1992/07/02  10:07:51  mettala
 * ReadState checks powerdriver state
 *
 * Revision 3.3  1992/05/21  08:56:02  mettala
 * Corrected bug in readstate and abortcommand
 *
 * Revision 3.2  1992/05/15  07:44:32  mettala
 * Corrected move reference and power module enable
 *
 * Revision 3.1  1992/05/06  09:10:14  mettala
 * Added new resource for powerdriver
 *
 * Revision 3.0  1992/04/27  08:11:15  mettala
 * Updated to version 3.0
 *
 * Revision 2.1  1992/04/01  14:42:55  mettala
 * Passed to version 2.1
 *
 * Revision 2.1  1992/04/01  14:42:55  mettala
 * Passed to version 2.1
 *
 * Revision 1.1  1992/03/31  17:26:09  mettala
 * First released version
 * */

#ifndef _Vpap_h
#define _Vpap_h


#define LIMITSOFF  0
#define NEGATLIMIT 1
#define POSITLIMIT 2
#define NEGPOSLIMIT 3

#define NO_WRITE_TRIG 0
#define WRITE_TRIG 1

#define HALF_STEP_MODE  1
#define FULL_STEP_MODE  2

#define MAXVEL 20833
#define MAXACC 1660050

#define MAXBACKLASH    800000

#if !defined(FORTRAN)
#include <StepperMotor.h>

typedef  struct _VpapClassRec *VpapClass;
typedef  struct _VpapRec *Vpap;

extern VpapClass vpapClass;
extern Vpap      vpap;

#endif /* FORTRAN */
#endif	/* _Vpap_h */
